/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDDLFormat;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectPersistAction;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSourceType;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablespace;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;
import org.jkiss.dbeaver.model.struct.DBSObjectState;

public class OracleMaterializedView
extends OracleTableBase
implements OracleSourceObject,
DBSObjectLazy<OracleDataSource> {
    private static final Log log = Log.getLog(OracleMaterializedView.class);
    private final AdditionalInfo additionalInfo = new AdditionalInfo();
    private String query;
    private OracleDDLFormat currentDDLFormat;

    public OracleMaterializedView(OracleSchema schema, String name) {
        super(schema, name, false);
    }

    public OracleMaterializedView(OracleSchema schema, ResultSet dbResult) {
        super(schema, dbResult);
    }

    @Property(viewable=true, order=10)
    @LazyProperty(cacheValidator=OracleTablespace.TablespaceReferenceValidator.class)
    public Object getContainer(DBRProgressMonitor monitor) throws DBException {
        return this.getAdditionalInfo((DBRProgressMonitor)monitor).container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PropertyGroup
    @LazyProperty(cacheValidator=OracleTableBase.AdditionalInfoValidator.class)
    public AdditionalInfo getAdditionalInfo(DBRProgressMonitor monitor) throws DBCException {
        AdditionalInfo additionalInfo = this.additionalInfo;
        synchronized (additionalInfo) {
            if (!this.additionalInfo.loaded && monitor != null) {
                this.loadAdditionalInfo(monitor);
            }
            return this.additionalInfo;
        }
    }

    @Override
    public OracleSourceType getSourceType() {
        return OracleSourceType.MATERIALIZED_VIEW;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) {
        if (this.query == null) {
            this.currentDDLFormat = OracleDDLFormat.getCurrentFormat((OracleDataSource)this.getDataSource());
        }
        OracleDDLFormat newFormat = OracleDDLFormat.FULL;
        boolean isFormatInOptions = options.containsKey("oracle.ddl.format");
        if (isFormatInOptions) {
            newFormat = (OracleDDLFormat)((Object)options.get("oracle.ddl.format"));
        }
        if (this.query == null || this.currentDDLFormat != newFormat && this.isPersisted()) {
            try {
                if (this.query == null || !isFormatInOptions) {
                    this.query = OracleUtils.getDDL(monitor, this.getTableTypeName(), this, this.currentDDLFormat, options);
                } else {
                    this.query = OracleUtils.getDDL(monitor, this.getTableTypeName(), this, newFormat, options);
                    this.currentDDLFormat = newFormat;
                }
            }
            catch (DBException e) {
                String message = e.getMessage();
                if (message != null) {
                    message = message.replace("*/", "* /");
                }
                this.query = "/*\nError generating materialized view DDL:\n" + message + "\n*/";
                log.warn((Object)"Error getting view definition from system package", (Throwable)e);
            }
        }
        return this.query;
    }

    public void setObjectDefinitionText(String source) {
        this.query = source;
    }

    public String getMViewText() {
        return this.query;
    }

    public void setCurrentDDLFormat(OracleDDLFormat currentDDLFormat) {
        this.currentDDLFormat = currentDDLFormat;
    }

    private void loadAdditionalInfo(DBRProgressMonitor monitor) throws DBCException {
        if (!this.isPersisted()) {
            this.additionalInfo.loaded = true;
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table status");){
            try {
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), (OracleDataSource)this.getDataSource(), "MVIEWS") + " WHERE OWNER=? AND MVIEW_NAME=?");){
                    dbStat.setString(1, this.getSchema().getName());
                    dbStat.setString(2, this.getName());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            this.additionalInfo.mviewValid = "VALID".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COMPILE_STATE"));
                            this.additionalInfo.container = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONTAINER_NAME");
                            this.additionalInfo.updatable = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"UPDATABLE", (String)"Y");
                            this.additionalInfo.rewriteEnabled = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"REWRITE_ENABLED", (String)"Y");
                            this.additionalInfo.rewriteCapability = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REWRITE_CAPABILITY");
                            this.additionalInfo.refreshMode = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REFRESH_MODE");
                            this.additionalInfo.refreshMethod = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REFRESH_METHOD");
                            this.additionalInfo.buildMode = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"BUILD_MODE");
                            this.additionalInfo.fastRefreshable = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FAST_REFRESHABLE");
                            this.additionalInfo.lastRefreshType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LAST_REFRESH_TYPE");
                            this.additionalInfo.lastRefreshDate = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_REFRESH_DATE");
                            this.additionalInfo.staleness = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STALENESS");
                        }
                        this.additionalInfo.loaded = true;
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    @Override
    public DBEPersistAction[] getCompileActions(DBRProgressMonitor monitor) {
        return new DBEPersistAction[]{new OracleObjectPersistAction(OracleObjectType.MATERIALIZED_VIEW, "Compile materialized view", "ALTER MATERIALIZED VIEW " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + " COMPILE")};
    }

    @Override
    @NotNull
    public DBSObjectState getObjectState() {
        return this.valid ? DBSObjectState.NORMAL : DBSObjectState.INVALID;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
        this.valid = OracleUtils.getObjectStatus(monitor, this, OracleObjectType.MATERIALIZED_VIEW);
    }

    public Object getLazyReference(Object propertyId) {
        return this.additionalInfo.container;
    }

    public boolean isView() {
        return true;
    }

    @Override
    public OracleTableBase.TableAdditionalInfo getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Override
    protected String getTableTypeName() {
        return "MATERIALIZED_VIEW";
    }

    @Override
    protected String queryTableComment(JDBCSession session) throws SQLException {
        return JDBCUtils.queryString((Connection)session, (String)"SELECT COMMENTS FROM ALL_MVIEW_COMMENTS WHERE OWNER=? AND MVIEW_NAME=?", (Object[])new Object[]{this.getSchema().getName(), this.getName()});
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((OracleSchema)this.getContainer()).constraintCache.clearObjectCache(this);
        return ((OracleSchema)this.getContainer()).tableCache.refreshObject(monitor, (OracleSchema)this.getContainer(), this);
    }

    public static class AdditionalInfo
    extends OracleTableBase.TableAdditionalInfo {
        private volatile boolean loaded = false;
        private boolean mviewValid;
        private Object container;
        private boolean updatable;
        private boolean rewriteEnabled;
        private boolean valid;
        private String rewriteCapability;
        private String refreshMode;
        private String refreshMethod;
        private String buildMode;
        private String fastRefreshable;
        private String lastRefreshType;
        private Date lastRefreshDate;
        private String staleness;

        @Property(viewable=false, order=14)
        public boolean isUpdatable() {
            return this.updatable;
        }

        @Property(viewable=false, order=15)
        public boolean isRewriteEnabled() {
            return this.rewriteEnabled;
        }

        @Property(viewable=false, order=16)
        public String getRewriteCapability() {
            return this.rewriteCapability;
        }

        @Property(viewable=false, order=17)
        public String getRefreshMode() {
            return this.refreshMode;
        }

        @Property(viewable=false, order=18)
        public String getRefreshMethod() {
            return this.refreshMethod;
        }

        @Property(viewable=false, order=19)
        public String getBuildMode() {
            return this.buildMode;
        }

        @Property(viewable=false, order=20)
        public String getFastRefreshable() {
            return this.fastRefreshable;
        }

        @Property(viewable=false, order=21)
        public String getLastRefreshType() {
            return this.lastRefreshType;
        }

        @Property(viewable=false, order=22)
        public Date getLastRefreshDate() {
            return this.lastRefreshDate;
        }

        @Property(viewable=false, order=23)
        public String getStaleness() {
            return this.staleness;
        }
    }
}

