/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UIColors;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.gis.internal.GISViewerActivator;

public class GeometryDataUtils {
    private static final Log log = Log.getLog(GeometryDataUtils.class);

    public static List<GeomAttrs> extractGeometryAttributes(IResultSetController controller) {
        ArrayList<GeomAttrs> result = new ArrayList<GeomAttrs>();
        ResultSetModel model = controller.getModel();
        List attributes = model.getVisibleAttributes();
        ArrayList<DBDAttributeBinding> descAttrs = new ArrayList<DBDAttributeBinding>();
        for (DBDAttributeBinding attr : attributes) {
            if (attr.getValueHandler().getValueObjectType((DBSTypedObject)attr.getAttribute()) == DBGeometry.class) {
                GeomAttrs geomAttrs = new GeomAttrs(attr, descAttrs);
                result.add(geomAttrs);
                continue;
            }
            descAttrs.add(attr);
        }
        return result;
    }

    public static void setGeometryProperties(@NotNull IResultSetController controller, @NotNull GeomAttrs geomAttrs, @NotNull DBGeometry geometry, @NotNull RGB geometryColor, @NotNull ResultSetRow row) {
        ResultSetModel model = controller.getModel();
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        for (DBDAttributeBinding binding : geomAttrs.descAttrs) {
            Object description = model.getCellValue(binding, row);
            if (DBUtils.isNullValue((Object)description) || description instanceof String && ((String)description).isEmpty()) continue;
            info.put(binding.getName(), description);
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("id", DBUtils.getObjectFullName((DBPNamedObject)geomAttrs.geomAttr, (DBPEvaluationContext)DBPEvaluationContext.UI));
        properties.put("color", String.format("#%02x%02x%02x", geometryColor.red, geometryColor.green, geometryColor.blue));
        properties.put("info", info);
        geometry.setProperties(properties);
    }

    @NotNull
    public static RGB makeGeometryColor(int index) {
        if (index == 0) {
            return Display.getCurrent().getSystemColor(9).getRGB();
        }
        return UIColors.getColor((int)index).getRGB();
    }

    public static int getDefaultSRID() {
        int srid = GISViewerActivator.getDefault().getPreferences().getInt("gis.view.defaultSRID");
        if (srid == 0) {
            return 4326;
        }
        return srid;
    }

    public static class GeomAttrs {
        public final DBDAttributeBinding geomAttr;
        public final List<DBDAttributeBinding> descAttrs;

        public GeomAttrs(DBDAttributeBinding geomAttr, List<DBDAttributeBinding> descAttrs) {
            this.geomAttr = geomAttr;
            this.descAttrs = descAttrs;
        }

        public DBDAttributeBinding getGeomAttr() {
            return this.geomAttr;
        }

        public List<DBDAttributeBinding> getDescAttrs() {
            return this.descAttrs;
        }
    }
}

