/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.colors;

import org.eclipse.jface.resource.StringConverter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UITextUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.colors.ColorAction;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.utils.CommonUtils;

public class SetRowColorAction
extends ColorAction {
    private ResultSetViewer resultSetViewer;
    private final DBDAttributeBinding attribute;
    private final Object value;

    public SetRowColorAction(ResultSetViewer resultSetViewer, DBDAttributeBinding attr, Object value) {
        super(resultSetViewer, NLS.bind((String)ResultSetMessages.actions_name_color_by, (Object)(String.valueOf(attr.getName()) + " = " + UITextUtils.getShortText((GC)resultSetViewer.getSizingGC(), (String)CommonUtils.toString((Object)value), (int)100))));
        this.resultSetViewer = resultSetViewer;
        this.attribute = attr;
        this.value = value;
    }

    public void run() {
        RGB color;
        Shell shell = UIUtils.createCenteredShell((Shell)this.resultSetViewer.getControl().getShell());
        try {
            ColorDialog cd = new ColorDialog(shell);
            color = cd.open();
            if (color == null) {
                return;
            }
        }
        finally {
            UIUtils.disposeCenteredShell((Shell)shell);
        }
        try {
            DBVEntity vEntity = this.getColorsVirtualEntity();
            vEntity.setColorOverride(this.attribute, this.value, null, StringConverter.asString((RGB)color));
            this.updateColors(vEntity);
        }
        catch (IllegalStateException e) {
            DBWorkbench.getPlatformUI().showError("Row color", "Can't set row color", (Throwable)e);
        }
    }
}

