/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import org.eclipse.draw2dl.AbstractPointListShape;
import org.eclipse.draw2dl.Graphics;
import org.eclipse.draw2dl.geometry.Geometry;
import org.eclipse.draw2dl.geometry.Point;

public class PolylineShape
extends AbstractPointListShape {
    private int tolerance = 2;

    @Override
    protected boolean shapeContainsPoint(int x, int y) {
        Point location = this.getLocation();
        return Geometry.polylineContainsPoint(this.points, x - location.x, y - location.y, this.tolerance);
    }

    @Override
    protected void fillShape(Graphics graphics) {
    }

    @Override
    protected void outlineShape(Graphics graphics) {
        graphics.pushState();
        graphics.translate(this.getLocation());
        graphics.drawPolyline(this.points);
        graphics.popState();
    }

    public void setTolerance(int tolerance) {
        this.tolerance = tolerance;
    }
}

