/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl.graph;

import org.eclipse.draw2dl.geometry.Insets;
import org.eclipse.draw2dl.graph.DirectedGraph;
import org.eclipse.draw2dl.graph.GraphVisitor;
import org.eclipse.draw2dl.graph.Node;
import org.eclipse.draw2dl.graph.Rank;

class VerticalPlacement
extends GraphVisitor {
    VerticalPlacement() {
    }

    @Override
    void visit(DirectedGraph g) {
        int currentY = g.getMargin().top;
        g.rankLocations = new int[g.ranks.size() + 1];
        int row = 0;
        while (row < g.ranks.size()) {
            g.rankLocations[row] = currentY;
            Rank rank = g.ranks.getRank(row);
            int rowHeight = 0;
            rank.bottomPadding = 0;
            rank.topPadding = 0;
            int n = 0;
            while (n < rank.size()) {
                Node node = rank.getNode(n);
                Insets pad = g.getPadding(node);
                rowHeight = Math.max(node.height, rowHeight);
                rank.topPadding = Math.max(pad.top, rank.topPadding);
                rank.bottomPadding = Math.max(pad.bottom, rank.bottomPadding);
                ++n;
            }
            rank.setDimensions(currentY += rank.topPadding, rowHeight);
            currentY += rank.height + rank.bottomPadding;
            ++row;
        }
        g.rankLocations[row] = currentY;
        g.size.height = currentY;
    }
}

