/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreBackupRestoreSettings;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseRestoreSettings;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreRestoreWizard;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreToolWizardPageSettings;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;

class PostgreRestoreWizardPageSettings
extends PostgreToolWizardPageSettings<PostgreRestoreWizard> {
    private TextWithOpenFile inputFileText;
    private Combo formatCombo;
    private Button cleanFirstButton;
    private Button noOwnerCheck;

    PostgreRestoreWizardPageSettings(PostgreRestoreWizard wizard) {
        super(wizard, PostgreMessages.wizard_restore_page_setting_title_setting);
        this.setTitle(PostgreMessages.wizard_restore_page_setting_title);
        this.setDescription(PostgreMessages.wizard_restore_page_setting_description);
    }

    protected boolean determinePageCompletion() {
        if (((PostgreDatabaseRestoreSettings)((PostgreRestoreWizard)this.wizard).getSettings()).getInputFile() == null) {
            this.setErrorMessage("Input file not specified");
            return false;
        }
        return super.determinePageCompletion();
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        Listener updateListener = event -> this.updateState();
        Group formatGroup = UIUtils.createControlGroup((Composite)composite, (String)PostgreMessages.wizard_restore_page_setting_label_setting, (int)2, (int)768, (int)0);
        this.formatCombo = UIUtils.createLabelCombo((Composite)formatGroup, (String)PostgreMessages.wizard_restore_page_setting_label_format, (int)12);
        this.formatCombo.setLayoutData((Object)new GridData(32));
        PostgreBackupRestoreSettings.ExportFormat[] exportFormatArray = PostgreBackupRestoreSettings.ExportFormat.values();
        int n = exportFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            PostgreBackupRestoreSettings.ExportFormat format = exportFormatArray[n2];
            this.formatCombo.add(format.getTitle());
            ++n2;
        }
        this.formatCombo.select(((PostgreDatabaseRestoreSettings)((PostgreRestoreWizard)this.wizard).getSettings()).getFormat().ordinal());
        this.formatCombo.addListener(13, updateListener);
        this.cleanFirstButton = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_restore_page_setting_btn_clean_first, null, (boolean)((PostgreDatabaseRestoreSettings)((PostgreRestoreWizard)this.wizard).getSettings()).isCleanFirst(), (int)2);
        this.cleanFirstButton.addListener(13, updateListener);
        this.noOwnerCheck = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_checkbox_no_owner, null, (boolean)((PostgreDatabaseRestoreSettings)((PostgreRestoreWizard)this.wizard).getSettings()).isNoOwner(), (int)2);
        this.noOwnerCheck.addListener(13, updateListener);
        Group inputGroup = UIUtils.createControlGroup((Composite)composite, (String)PostgreMessages.wizard_restore_page_setting_label_input, (int)2, (int)768, (int)0);
        UIUtils.createControlLabel((Composite)inputGroup, (String)PostgreMessages.wizard_restore_page_setting_label_backup_file);
        this.inputFileText = new TextWithOpenFile((Composite)inputGroup, PostgreMessages.wizard_restore_page_setting_label_choose_backup_file, new String[]{"*.backup", "*.sql", "*"});
        this.inputFileText.setLayoutData((Object)new GridData(768));
        this.inputFileText.getTextControl().addListener(24, updateListener);
        this.inputFileText.setText(((PostgreDatabaseRestoreSettings)((PostgreRestoreWizard)this.wizard).getSettings()).getInputFile());
        this.createExtraArgsInput((Composite)inputGroup);
        Composite extraGroup = UIUtils.createComposite((Composite)composite, (int)2);
        this.createSecurityGroup(extraGroup);
        this.setControl((Control)composite);
    }

    public void saveState() {
        PostgreDatabaseRestoreSettings settings = (PostgreDatabaseRestoreSettings)((PostgreRestoreWizard)this.wizard).getSettings();
        settings.setFormat(PostgreBackupRestoreSettings.ExportFormat.values()[this.formatCombo.getSelectionIndex()]);
        settings.setInputFile(this.inputFileText.getText());
        settings.setCleanFirst(this.cleanFirstButton.getSelection());
        settings.setNoOwner(this.noOwnerCheck.getSelection());
    }

    protected void updateState() {
        this.saveState();
        this.inputFileText.setOpenFolder(((PostgreDatabaseRestoreSettings)((PostgreRestoreWizard)this.wizard).getSettings()).getFormat() == PostgreBackupRestoreSettings.ExportFormat.DIRECTORY);
        this.updatePageCompletion();
        this.getContainer().updateButtons();
    }
}

