/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreCommandGrantPrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObjectPrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeGrant;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureKind;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRolePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSPackage;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSSequence;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.editors.AbstractDatabaseObjectEditor;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorUtils;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorLabelProvider;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilter;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PostgresRolePrivilegesEditor
extends AbstractDatabaseObjectEditor<PostgrePrivilegeOwner> {
    private PageControl pageControl;
    private boolean isLoaded;
    private DatabaseNavigatorTree roleOrObjectTable;
    private Composite permEditPanel;
    private Table permissionTable;
    private ControlEnableState permissionsEnable;
    private DBSObject[] currentObjects;
    private PostgrePrivilege[] currentPermissions;
    private Map<String, PostgrePrivilege> permissionMap = new HashMap<String, PostgrePrivilege>();
    private Text objectDescriptionText;

    public void createPartControl(Composite parent) {
        this.pageControl = new PageControl(parent);
        CustomSashForm composite = UIUtils.createPartDivider((IWorkbenchPart)this.getSite().getPart(), (Composite)this.pageControl, (int)256);
        composite.setLayoutData((Object)new GridData(1808));
        this.roleOrObjectTable = new DatabaseNavigatorTree((Composite)composite, (DBNNode)DBWorkbench.getPlatform().getNavigatorModel().getRoot(), 65538, false, (INavigatorFilter)(this.isRoleEditor() ? new DatabaseObjectFilter() : null));
        this.roleOrObjectTable.setLayoutData((Object)new GridData(1808));
        TreeViewer treeViewer = this.roleOrObjectTable.getViewer();
        treeViewer.setLabelProvider((IBaseLabelProvider)new DatabaseNavigatorLabelProvider((Viewer)treeViewer){

            public Font getFont(Object element) {
                if (element instanceof DBNDatabaseNode) {
                    DBSObject object = ((DBNDatabaseNode)element).getObject();
                    if (object instanceof PostgreSchema) {
                        String schemaPrefix = String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)object)) + ".";
                        for (String tableName : PostgresRolePrivilegesEditor.this.permissionMap.keySet()) {
                            if (!tableName.startsWith(schemaPrefix)) continue;
                            return this.boldFont;
                        }
                    } else if (PostgresRolePrivilegesEditor.this.getObjectPermissions(object) != null) {
                        return this.boldFont;
                    }
                }
                return null;
            }
        });
        treeViewer.addSelectionChangedListener(event -> this.handleSelectionChange());
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof DBNNode && !(element instanceof DBNDatabaseNode)) {
                    return false;
                }
                if (element instanceof DBNDatabaseFolder) {
                    DBXTreeFolder meta = ((DBNDatabaseFolder)element).getMeta();
                    Class childType = meta.getSource().getObjectClass(meta.getType());
                    if (childType == null) {
                        return false;
                    }
                    return PostgreTableReal.class.isAssignableFrom(childType) || PostgreSequence.class.isAssignableFrom(childType) || PostgreProcedure.class.isAssignableFrom(childType);
                }
                return true;
            }
        });
        this.permEditPanel = new Composite((Composite)composite, 0);
        this.permEditPanel.setLayout((Layout)new GridLayout(1, true));
        this.permissionTable = new Table(this.permEditPanel, 65568);
        this.permissionTable.setLayoutData((Object)new GridData(768));
        this.permissionTable.setHeaderVisible(true);
        this.permissionTable.setLinesVisible(true);
        UIUtils.createTableColumn((Table)this.permissionTable, (int)16384, (String)PostgreMessages.dialog_create_table_column_name_permission);
        UIUtils.createTableColumn((Table)this.permissionTable, (int)0x1000000, (String)PostgreMessages.dialog_create_table_column_name_with_garant);
        UIUtils.createTableColumn((Table)this.permissionTable, (int)0x1000000, (String)PostgreMessages.dialog_create_table_column_name_with_hierarchy);
        this.permissionTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    PostgresRolePrivilegesEditor.this.updateCurrentPrivileges(((TableItem)e.item).getChecked(), (PostgrePrivilegeType)e.item.getData());
                }
            }
        });
        this.permissionTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                super.mouseDown(e);
            }
        });
        if (!this.isRoleEditor()) {
            PostgrePrivilegeType[] postgrePrivilegeTypeArray = ((PostgrePrivilegeOwner)this.getDatabaseObject()).getDataSource().getSupportedPrivilegeTypes();
            int n = postgrePrivilegeTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PostgrePrivilegeType pt = postgrePrivilegeTypeArray[n2];
                if (pt.isValid() && pt.supportsType(((PostgrePrivilegeOwner)this.getDatabaseObject()).getClass())) {
                    TableItem privItem = new TableItem(this.permissionTable, 16384);
                    privItem.setText(0, pt.name());
                    privItem.setData((Object)pt);
                }
                ++n2;
            }
        }
        Composite buttonPanel = new Composite(this.permEditPanel, 0);
        buttonPanel.setLayoutData((Object)new GridData(768));
        buttonPanel.setLayout((Layout)new RowLayout());
        UIUtils.createPushButton((Composite)buttonPanel, (String)PostgreMessages.dialog_create_push_button_grant_all, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean hadNonChecked = false;
                TableItem[] tableItemArray = PostgresRolePrivilegesEditor.this.permissionTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (!item.getChecked()) {
                        hadNonChecked = true;
                    }
                    item.setChecked(true);
                    ++n2;
                }
                if (hadNonChecked) {
                    PostgresRolePrivilegesEditor.this.updateCurrentPrivileges(true, null);
                }
            }
        });
        UIUtils.createPushButton((Composite)buttonPanel, (String)PostgreMessages.dialog_create_push_button_revoke_all, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean hadChecked = false;
                TableItem[] tableItemArray = PostgresRolePrivilegesEditor.this.permissionTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        hadChecked = true;
                    }
                    item.setChecked(false);
                    ++n2;
                }
                if (hadChecked) {
                    PostgresRolePrivilegesEditor.this.updateCurrentPrivileges(false, null);
                }
            }
        });
        this.objectDescriptionText = new Text(this.permEditPanel, 586);
        this.objectDescriptionText.setLayoutData((Object)new GridData(1808));
        this.pageControl.createOrSubstituteProgressPanel(this.getSite());
        this.updateObjectPermissions(null);
    }

    private void handleSelectionChange() {
        List selectedObjects = NavigatorUtils.getSelectedObjects((ISelection)this.roleOrObjectTable.getViewer().getSelection());
        if (CommonUtils.isEmpty((Collection)selectedObjects)) {
            this.updateObjectPermissions(null);
        } else {
            this.updateObjectPermissions(selectedObjects);
        }
    }

    private PostgrePrivilege getObjectPermissions(DBSObject object) {
        if (object instanceof PostgreProcedure) {
            String fqProcName = String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)((PostgreProcedure)object).getSchema())) + "." + ((PostgreProcedure)object).getSpecificName();
            return this.permissionMap.get(fqProcName);
        }
        return this.permissionMap.get(DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.DDL));
    }

    private void updateCurrentPrivileges(boolean grant, PostgrePrivilegeType privilegeType) {
        if (ArrayUtils.isEmpty((Object[])this.currentObjects)) {
            DBWorkbench.getPlatformUI().showError("Update privilege", "Can't update privilege - no current object");
            return;
        }
        PostgrePrivilegeOwner databaseObject = (PostgrePrivilegeOwner)this.getDatabaseObject();
        int i = 0;
        while (i < this.currentObjects.length) {
            block11: {
                PostgrePrivilegeType[] postgrePrivilegeTypeArray;
                PostgrePrivilege permission;
                DBSObject currentObject;
                block12: {
                    block10: {
                        currentObject = this.currentObjects[i];
                        permission = this.currentPermissions[i];
                        if (permission != null) break block10;
                        if (!grant) break block11;
                        if (this.isRoleEditor()) {
                            String objectName;
                            PostgrePrivilegeGrant.Kind kind;
                            PostgrePrivilegeOwner permissionsOwner = (PostgrePrivilegeOwner)currentObject;
                            if (permissionsOwner instanceof PostgreProcedure) {
                                kind = ((PostgreProcedure)permissionsOwner).getKind() == PostgreProcedureKind.p ? PostgrePrivilegeGrant.Kind.PROCEDURE : PostgrePrivilegeGrant.Kind.FUNCTION;
                                objectName = ((PostgreProcedure)permissionsOwner).getUniqueName();
                            } else {
                                kind = permissionsOwner instanceof PostgreSchema ? PostgrePrivilegeGrant.Kind.SCHEMA : (permissionsOwner instanceof PostgreSequence ? PostgrePrivilegeGrant.Kind.SEQUENCE : PostgrePrivilegeGrant.Kind.TABLE);
                                objectName = permissionsOwner.getName();
                            }
                            permission = new PostgreRolePrivilege(databaseObject, kind, permissionsOwner.getSchema().getName(), objectName, Collections.emptyList());
                        } else {
                            String currentUser = databaseObject.getDataSource().getContainer().getActualConnectionConfiguration().getUserName();
                            PostgrePrivilegeGrant privGrant = new PostgrePrivilegeGrant(currentUser, currentObject.getName(), databaseObject.getDatabase().getName(), databaseObject.getSchema().getName(), databaseObject.getName(), privilegeType, false, false);
                            permission = new PostgreObjectPrivilege(databaseObject, currentObject.getName(), Collections.singletonList(privGrant));
                        }
                        this.currentPermissions[i] = permission;
                        this.permissionMap.put(permission.getName(), permission);
                        break block12;
                    }
                    if (privilegeType != null) {
                        boolean hasPriv;
                        boolean bl = hasPriv = permission.getPermission(privilegeType) != 0;
                        if (grant != hasPriv && !grant) {
                            this.permissionMap.remove(permission.getName());
                        }
                    }
                }
                if (privilegeType == null) {
                    postgrePrivilegeTypeArray = null;
                } else {
                    PostgrePrivilegeType[] postgrePrivilegeTypeArray2 = new PostgrePrivilegeType[1];
                    postgrePrivilegeTypeArray = postgrePrivilegeTypeArray2;
                    postgrePrivilegeTypeArray2[0] = privilegeType;
                }
                this.addChangeCommand((DBECommand)new PostgreCommandGrantPrivilege(databaseObject, grant, currentObject, permission, postgrePrivilegeTypeArray), (DBECommandReflector)new DBECommandReflector<PostgrePrivilegeOwner, PostgreCommandGrantPrivilege>(){

                    public void redoCommand(PostgreCommandGrantPrivilege cmd) {
                    }

                    public void undoCommand(PostgreCommandGrantPrivilege cmd) {
                    }
                });
            }
            ++i;
        }
    }

    private void updateObjectPermissions(List<DBSObject> objects) {
        TableItem[] tableItemArray;
        boolean editEnabled;
        int n;
        boolean hasBadObjects = CommonUtils.isEmpty(objects);
        if (this.isRoleEditor()) {
            this.permissionTable.removeAll();
            if (!CommonUtils.isEmpty(objects)) {
                Class<?> objectType = objects.get(0).getClass();
                PostgrePrivilegeType[] postgrePrivilegeTypeArray = ((PostgrePrivilegeOwner)this.getDatabaseObject()).getDataSource().getSupportedPrivilegeTypes();
                n = postgrePrivilegeTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PostgrePrivilegeType pt = postgrePrivilegeTypeArray[n2];
                    if (pt.isValid() && pt.supportsType(objectType)) {
                        TableItem privItem = new TableItem(this.permissionTable, 16384);
                        privItem.setText(0, pt.name());
                        privItem.setData((Object)pt);
                    }
                    ++n2;
                }
                this.permissionTable.getParent().layout(true);
                UIUtils.packColumns((Table)this.permissionTable, (boolean)false);
            }
        }
        StringBuilder objectNames = new StringBuilder();
        if (!hasBadObjects) {
            for (DBSObject object : objects) {
                if (!(object instanceof PostgrePrivilegeOwner)) {
                    hasBadObjects = true;
                    break;
                }
                if (objectNames.length() > 0) {
                    objectNames.append(", ");
                }
                objectNames.append(DBUtils.getObjectFullName((DBPDataSource)object.getDataSource(), (DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.DML));
            }
        }
        if (hasBadObjects) {
            this.objectDescriptionText.setText(PostgreMessages.dialog_object_description_text_no_objects);
            this.currentPermissions = null;
            this.currentObjects = null;
            editEnabled = false;
        } else {
            this.objectDescriptionText.setText(objectNames.toString());
            this.currentObjects = objects.toArray(new DBSObject[0]);
            this.currentPermissions = new PostgrePrivilege[this.currentObjects.length];
            int i = 0;
            while (i < this.currentObjects.length) {
                this.currentPermissions[i] = this.getObjectPermissions(this.currentObjects[i]);
                ++i;
            }
            boolean bl = editEnabled = !CommonUtils.isEmpty(objects);
        }
        if (editEnabled) {
            if (this.permissionsEnable != null) {
                this.permissionsEnable.restore();
                this.permissionsEnable = null;
            }
        } else if (this.permissionsEnable == null) {
            this.permissionsEnable = ControlEnableState.disable((Control)this.permEditPanel);
        }
        if (ArrayUtils.isEmpty((Object[])this.currentPermissions)) {
            tableItemArray = this.permissionTable.getItems();
            int n3 = tableItemArray.length;
            n = 0;
            while (n < n3) {
                TableItem item = tableItemArray[n];
                item.setChecked(false);
                item.setText(1, "");
                item.setText(2, "");
                ++n;
            }
        } else {
            tableItemArray = this.permissionTable.getItems();
            int n4 = tableItemArray.length;
            n = 0;
            while (n < n4) {
                TableItem item = tableItemArray[n];
                PostgrePrivilegeType privType = (PostgrePrivilegeType)item.getData();
                short perm = this.currentPermissions[0] == null ? (short)0 : this.currentPermissions[0].getPermission(privType);
                item.setChecked((perm & 1) != 0);
                if ((perm & 2) != 0) {
                    item.setText(1, "X");
                } else {
                    item.setText(1, "");
                }
                if ((perm & 4) != 0) {
                    item.setText(2, "X");
                } else {
                    item.setText(2, "");
                }
                ++n;
            }
        }
    }

    private boolean isRoleEditor() {
        return this.getDatabaseObject() instanceof PostgreRole;
    }

    public void setFocus() {
        if (this.pageControl != null) {
            this.pageControl.activate(true);
        }
        if (this.roleOrObjectTable != null) {
            this.roleOrObjectTable.getViewer().getControl().setFocus();
        }
    }

    public synchronized void activatePart() {
        if (this.isLoaded) {
            return;
        }
        this.isLoaded = true;
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.permissionTable, (boolean)false));
        LoadingJob.createService((ILoadService)new DatabaseLoadService<Collection<PostgrePrivilege>>("Load permissions", this.getExecutionContext()){

            public Collection<PostgrePrivilege> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException {
                monitor.beginTask("Load privileges from database..", 1);
                try {
                    monitor.subTask("Load " + ((PostgrePrivilegeOwner)PostgresRolePrivilegesEditor.this.getDatabaseObject()).getName() + " privileges");
                    Collection collection = ((PostgrePrivilegeOwner)PostgresRolePrivilegesEditor.this.getDatabaseObject()).getPrivileges(monitor, false);
                    return collection;
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    monitor.done();
                }
            }
        }, this.pageControl.createLoadVisualizer()).schedule();
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        if (force || source instanceof DBNEvent && ((DBNEvent)source).getSource() == DBNEvent.UPDATE_ON_SAVE || !this.isLoaded) {
            this.isLoaded = false;
            UIUtils.syncExec(() -> this.updateObjectPermissions(null));
            this.activatePart();
            return IRefreshablePart.RefreshResult.REFRESHED;
        }
        return IRefreshablePart.RefreshResult.IGNORED;
    }

    private static class DatabaseObjectFilter
    extends DatabaseNavigatorTreeFilter {
        private DatabaseObjectFilter() {
        }

        public boolean filterFolders() {
            return false;
        }

        public boolean isLeafObject(Object object) {
            if (object instanceof DBNDatabaseItem) {
                DBSObject dbObject = ((DBNDatabaseItem)object).getObject();
                return dbObject instanceof DBSEntity || dbObject instanceof DBSProcedure || dbObject instanceof DBSTableIndex || dbObject instanceof DBSPackage || dbObject instanceof DBSSequence || dbObject instanceof DBAUser;
            }
            return false;
        }

        public boolean select(Object element) {
            return true;
        }
    }

    private class PageControl
    extends ProgressPageControl {
        PageControl(Composite parent) {
            super(parent, 0x10000000);
        }

        ProgressPageControl.ProgressVisualizer<Collection<PostgrePrivilege>> createLoadVisualizer() {
            return new ProgressPageControl.ProgressVisualizer<Collection<PostgrePrivilege>>((ProgressPageControl)this){

                public void completeLoading(Collection<PostgrePrivilege> privs) {
                    DBNDatabaseNode rootNode;
                    super.completeLoading(privs);
                    if (privs == null) {
                        return;
                    }
                    ((PageControl)PageControl.this).PostgresRolePrivilegesEditor.this.permissionMap.clear();
                    for (PostgrePrivilege perm : privs) {
                        ((PageControl)PageControl.this).PostgresRolePrivilegesEditor.this.permissionMap.put(perm.getName(), perm);
                    }
                    VoidProgressMonitor monitor = new VoidProgressMonitor();
                    if (PostgresRolePrivilegesEditor.this.isRoleEditor()) {
                        DBNDatabaseNode dbNode = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)((PostgrePrivilegeOwner)PostgresRolePrivilegesEditor.this.getDatabaseObject()).getDatabase(), (boolean)true);
                        rootNode = DBNUtils.getChildFolder((DBRProgressMonitor)monitor, (DBNDatabaseNode)dbNode, PostgreSchema.class);
                    } else {
                        DBNDatabaseNode dsNode = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)((PostgrePrivilegeOwner)PostgresRolePrivilegesEditor.this.getDatabaseObject()).getDataSource(), (boolean)true);
                        rootNode = DBNUtils.getChildFolder((DBRProgressMonitor)monitor, (DBNDatabaseNode)dsNode, PostgreRole.class);
                    }
                    if (rootNode == null) {
                        DBWorkbench.getPlatformUI().showError("Object tree", "Can't detect root node for objects tree");
                    } else {
                        ((PageControl)PageControl.this).PostgresRolePrivilegesEditor.this.roleOrObjectTable.reloadTree((DBNNode)rootNode);
                    }
                    PostgresRolePrivilegesEditor.this.handleSelectionChange();
                }
            };
        }

        public void fillCustomActions(IContributionManager contributionManager) {
            super.fillCustomActions(contributionManager);
            contributionManager.add((IContributionItem)new Separator());
            IWorkbenchPartSite workbenchSite = PostgresRolePrivilegesEditor.this.getSite();
            if (workbenchSite != null) {
                DatabaseEditorUtils.contributeStandardEditorActions((IWorkbenchSite)workbenchSite, (IContributionManager)contributionManager);
            }
        }
    }
}

