/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceViewDescriptor;

public class DataSourceViewRegistry {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dataSourceView";
    private static DataSourceViewRegistry instance = null;
    private final List<DataSourceViewDescriptor> views = new ArrayList<DataSourceViewDescriptor>();

    public static synchronized DataSourceViewRegistry getInstance() {
        if (instance == null) {
            instance = new DataSourceViewRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private DataSourceViewRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement viewElement = iConfigurationElementArray[n2];
            if (viewElement.getName().equals("view")) {
                this.views.add(new DataSourceViewDescriptor(viewElement));
            }
            ++n2;
        }
    }

    public DataSourceViewDescriptor findView(DBPDataSourceProviderDescriptor provider, String targetID) {
        DBPDataSourceProviderDescriptor pd = provider;
        while (pd != null) {
            for (DataSourceViewDescriptor view : this.views) {
                if (!view.getDataSources().contains(pd.getId()) || !targetID.equals(view.getTargetID())) continue;
                return view;
            }
            pd = pd.getParentProvider();
        }
        return null;
    }

    public List<DataSourceViewDescriptor> getViews(DBPDataSourceProviderDescriptor provider, String targetID) {
        ArrayList<DataSourceViewDescriptor> result = new ArrayList<DataSourceViewDescriptor>();
        DBPDataSourceProviderDescriptor pd = provider;
        while (pd != null) {
            for (DataSourceViewDescriptor view : this.views) {
                if (!view.getDataSources().contains(pd.getId()) || !targetID.equals(view.getTargetID())) continue;
                result.add(view);
            }
            pd = pd.getParentProvider();
        }
        return result;
    }
}

