/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.ForeignKeyInfo;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableConstraintColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKey;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKeyColumnTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.ext.generic.model.TableTriggerCache;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyDeferability;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.utils.CommonUtils;

public abstract class GenericTableBase
extends JDBCTable<GenericDataSource, GenericStructContainer>
implements DBPRefreshableObject,
DBPSystemObject,
DBPScriptObject {
    private static final Log log = Log.getLog(GenericTableBase.class);
    private String tableType;
    private boolean isSystem;
    private String description;
    private Long rowCount;
    private List<? extends GenericTrigger> triggers;
    private final String tableCatalogName;
    private final String tableSchemaName;

    public GenericTableBase(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super((DBSObject)container, tableName, dbResult != null);
        this.tableType = tableType;
        if (this.tableType == null) {
            this.tableType = "";
        }
        if (dbResult != null) {
            this.description = GenericUtils.safeGetString(container.getTableCache().tableObject, (ResultSet)dbResult, "REMARKS");
        }
        GenericMetaModel metaModel = container.getDataSource().getMetaModel();
        this.isSystem = metaModel.isSystemTable(this);
        boolean mergeEntities = container.getDataSource().isMergeEntities();
        if (mergeEntities && dbResult != null) {
            this.tableCatalogName = GenericUtils.safeGetString(container.getTableCache().tableObject, (ResultSet)dbResult, "TABLE_CATALOG");
            this.tableSchemaName = GenericUtils.safeGetString(container.getTableCache().tableObject, (ResultSet)dbResult, "TABLE_SCHEM");
        } else {
            this.tableCatalogName = null;
            this.tableSchemaName = null;
        }
    }

    public TableCache getCache() {
        return ((GenericStructContainer)this.getContainer()).getTableCache();
    }

    protected boolean isTruncateSupported() {
        return CommonUtils.getBoolean((Object)((GenericDataSource)this.getDataSource()).getContainer().getDriver().getDriverParameter("supports-truncate"), (boolean)false);
    }

    public GenericStructContainer getParentObject() {
        return ((GenericStructContainer)this.getContainer()).getObject();
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        if (this.isView() && context == DBPEvaluationContext.DDL && !((GenericDataSource)this.getDataSource()).getMetaModel().useCatalogInObjectNames()) {
            return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getSchema(), this});
        }
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getCatalog(), this.getSchema(), this});
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public void setSystem(boolean system) {
        this.isSystem = system;
    }

    @Property(viewable=true, order=2)
    public String getTableType() {
        return this.tableType;
    }

    @Property(viewable=true, optional=true, order=3)
    public GenericCatalog getCatalog() {
        if (!CommonUtils.isEmpty((String)this.tableCatalogName)) {
            ((GenericDataSource)this.getDataSource()).getCatalog(this.tableCatalogName);
        }
        return ((GenericStructContainer)this.getContainer()).getCatalog();
    }

    public String getCatalogName() {
        return this.tableCatalogName;
    }

    @Property(viewable=true, optional=true, order=4)
    public GenericSchema getSchema() {
        GenericStructContainer container = (GenericStructContainer)this.getContainer();
        if (!CommonUtils.isEmpty((String)this.tableSchemaName)) {
            if (!(container instanceof GenericCatalog)) {
                return ((GenericDataSource)this.getDataSource()).getSchema(this.tableSchemaName);
            }
            try {
                return ((GenericCatalog)container).getSchema((DBRProgressMonitor)new VoidProgressMonitor(), this.tableSchemaName);
            }
            catch (Exception e) {
                log.error((Object)e);
                return null;
            }
        }
        return container.getSchema();
    }

    public String getSchemaName() {
        return this.tableSchemaName;
    }

    @Nullable
    public List<? extends GenericTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((GenericStructContainer)this.getContainer()).getTableCache().getChildren(monitor, (DBSObject)((GenericStructContainer)this.getContainer()), (DBSObject)this);
    }

    public GenericTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (GenericTableColumn)((GenericStructContainer)this.getContainer()).getTableCache().getChild(monitor, (DBSObject)((GenericStructContainer)this.getContainer()), (DBSObject)this, attributeName);
    }

    public void addAttribute(GenericTableColumn column) {
        ((GenericStructContainer)this.getContainer()).getTableCache().getChildrenCache((DBSObject)this).cacheObject((DBSObject)column);
    }

    public void removeAttribute(GenericTableColumn column) {
        ((GenericStructContainer)this.getContainer()).getTableCache().getChildrenCache((DBSObject)this).removeObject((DBSObject)column, false);
    }

    public Collection<? extends GenericTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        if (((GenericDataSource)this.getDataSource()).getInfo().supportsIndexes()) {
            return ((GenericStructContainer)this.getContainer()).getIndexCache().getObjects(monitor, (DBSObject)((GenericStructContainer)this.getContainer()), (DBSObject)this);
        }
        return null;
    }

    @Nullable
    public List<GenericUniqueKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (((GenericDataSource)this.getDataSource()).getInfo().supportsReferentialIntegrity() || ((GenericDataSource)this.getDataSource()).getInfo().supportsIndexes()) {
            this.getAttributes(monitor);
            return ((GenericStructContainer)this.getContainer()).getConstraintKeysCache().getObjects(monitor, (DBSObject)((GenericStructContainer)this.getContainer()), (DBSObject)this);
        }
        return null;
    }

    public GenericUniqueKey getConstraint(@NotNull DBRProgressMonitor monitor, String name) throws DBException {
        if (((GenericDataSource)this.getDataSource()).getInfo().supportsReferentialIntegrity() || ((GenericDataSource)this.getDataSource()).getInfo().supportsIndexes()) {
            this.getAttributes(monitor);
            return (GenericUniqueKey)((GenericStructContainer)this.getContainer()).getConstraintKeysCache().getObject(monitor, (DBSObject)((GenericStructContainer)this.getContainer()), (DBSObject)this, name);
        }
        return null;
    }

    public void addUniqueKey(GenericUniqueKey constraint) {
        ((GenericStructContainer)this.getContainer()).getConstraintKeysCache().cacheObject((DBSObject)constraint);
    }

    public Collection<GenericTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (((GenericDataSource)this.getDataSource()).getInfo().supportsReferentialIntegrity()) {
            return this.loadReferences(monitor);
        }
        return null;
    }

    public Collection<GenericTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (((GenericDataSource)this.getDataSource()).getInfo().supportsReferentialIntegrity()) {
            return ((GenericStructContainer)this.getContainer()).getForeignKeysCache().getObjects(monitor, (DBSObject)((GenericStructContainer)this.getContainer()), (DBSObject)this);
        }
        return null;
    }

    public GenericTableForeignKey getAssociation(@NotNull DBRProgressMonitor monitor, String name) throws DBException {
        if (((GenericDataSource)this.getDataSource()).getInfo().supportsReferentialIntegrity()) {
            return (GenericTableForeignKey)((GenericStructContainer)this.getContainer()).getForeignKeysCache().getObject(monitor, (DBSObject)((GenericStructContainer)this.getContainer()), (DBSObject)this, name);
        }
        return null;
    }

    @Association
    @Nullable
    public Collection<GenericTableBase> getSubTables() {
        return null;
    }

    @Property(viewable=true, editableExpr="object.dataSource.metaModel.tableCommentEditable", updatableExpr="object.dataSource.metaModel.tableCommentEditable", length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((GenericStructContainer)this.getContainer()).getIndexCache().clearObjectCache((DBSObject)this);
        ((GenericStructContainer)this.getContainer()).getConstraintKeysCache().clearObjectCache((DBSObject)this);
        ((GenericStructContainer)this.getContainer()).getForeignKeysCache().clearObjectCache((DBSObject)this);
        return ((GenericStructContainer)this.getContainer()).getTableCache().refreshObject(monitor, (DBSObject)((GenericStructContainer)this.getContainer()), (DBSObject)this);
    }

    @Property(viewable=false, expensive=true, order=5, category="Statistics")
    @Nullable
    public Long getRowCount(DBRProgressMonitor monitor) {
        if (this.rowCount != null) {
            return this.rowCount;
        }
        if (this.isView() || !this.isPersisted()) {
            return null;
        }
        if (Boolean.FALSE.equals(((GenericDataSource)this.getDataSource()).getContainer().getDriver().getDriverParameter("supports-select-count"))) {
            return null;
        }
        if (this.rowCount == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read row count");){
                    this.rowCount = this.countData((DBCExecutionSource)new AbstractExecutionSource((DBSDataContainer)this, session.getExecutionContext(), (Object)this), session, null, 0L);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (DBException e) {
                log.debug((Object)("Can't fetch row count: " + e.getMessage()));
            }
        }
        if (this.rowCount == null) {
            this.rowCount = -1L;
        }
        return this.rowCount;
    }

    @Nullable
    public Long getRowCountFromIndexes(DBRProgressMonitor monitor) {
        try {
            Collection<? extends GenericTableIndex> indexList = this.getIndexes(monitor);
            if (!CommonUtils.isEmpty(indexList)) {
                for (GenericTableIndex genericTableIndex : indexList) {
                    long cardinality;
                    if (!genericTableIndex.isUnique() || (cardinality = genericTableIndex.getCardinality()) <= 0L) continue;
                    return cardinality;
                }
            }
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return null;
    }

    public boolean isPhysicalTable() {
        return !this.isView();
    }

    public abstract String getDDL();

    private List<GenericTableForeignKey> loadReferences(DBRProgressMonitor monitor) throws DBException {
        if (!this.isPersisted() || !((GenericDataSource)this.getDataSource()).getInfo().supportsReferentialIntegrity()) {
            return new ArrayList<GenericTableForeignKey>();
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table relations");){
                GenericMetaObject fkObject = ((GenericDataSource)this.getDataSource()).getMetaObject("foreign-key");
                List<ForeignKeyInfo> fkInfos = this.loadReferenceInfoList(session, fkObject);
                ArrayList<GenericTableForeignKey> fkList = new ArrayList<GenericTableForeignKey>();
                HashMap<String, GenericTableForeignKey> fkMap = new HashMap<String, GenericTableForeignKey>();
                for (ForeignKeyInfo info : fkInfos) {
                    GenericTableForeignKey fk;
                    Collection uniqueKeys;
                    DBSForeignKeyDeferability deferability;
                    DBSForeignKeyModifyRule deleteRule = JDBCUtils.getCascadeFromNum((int)info.deleteRuleNum);
                    DBSForeignKeyModifyRule updateRule = JDBCUtils.getCascadeFromNum((int)info.updateRuleNum);
                    switch (info.deferabilityNum) {
                        case 5: {
                            deferability = DBSForeignKeyDeferability.INITIALLY_DEFERRED;
                            break;
                        }
                        case 6: {
                            deferability = DBSForeignKeyDeferability.INITIALLY_IMMEDIATE;
                            break;
                        }
                        case 7: {
                            deferability = DBSForeignKeyDeferability.NOT_DEFERRABLE;
                            break;
                        }
                        default: {
                            deferability = DBSForeignKeyDeferability.UNKNOWN;
                        }
                    }
                    if (info.fkTableName == null) {
                        log.debug((Object)"Null FK table name");
                        continue;
                    }
                    GenericTableBase fkTable = ((GenericDataSource)this.getDataSource()).findTable(monitor, info.fkTableCatalog, info.fkTableSchema, info.fkTableName);
                    if (fkTable == null) {
                        log.warn((Object)("Can't find FK table " + info.fkTableName));
                        continue;
                    }
                    GenericTableColumn pkColumn = this.getAttribute(monitor, info.pkColumnName);
                    if (pkColumn == null) {
                        log.warn((Object)("Can't find PK column " + info.pkColumnName));
                        continue;
                    }
                    GenericTableColumn fkColumn = fkTable.getAttribute(monitor, info.fkColumnName);
                    if (fkColumn == null) {
                        log.warn((Object)("Can't find FK table " + fkTable.getFullyQualifiedName(DBPEvaluationContext.DDL) + " column " + info.fkColumnName));
                        continue;
                    }
                    GenericUniqueKey pk = null;
                    if (!CommonUtils.isEmpty((String)info.pkName) && (pk = (GenericUniqueKey)DBUtils.findObject((Collection)this.getConstraints(monitor), (String)info.pkName)) == null) {
                        log.debug((Object)("Unique key '" + info.pkName + "' not found in table " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + " for FK " + info.fkName));
                    }
                    if (pk == null && (uniqueKeys = this.getConstraints(monitor)) != null) {
                        for (GenericUniqueKey pkConstraint : uniqueKeys) {
                            if (!pkConstraint.getConstraintType().isUnique() || DBUtils.getConstraintAttribute((DBRProgressMonitor)monitor, (DBSEntityReferrer)pkConstraint, (DBSEntityAttribute)pkColumn) == null) continue;
                            pk = pkConstraint;
                            break;
                        }
                    }
                    if (pk == null) {
                        log.warn((Object)("Can't find unique key for table " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + " column " + pkColumn.getName()));
                        pk = ((GenericDataSource)this.getDataSource()).getMetaModel().createConstraintImpl(this, info.pkName, DBSEntityConstraintType.PRIMARY_KEY, null, true);
                        pk.addColumn(new GenericTableConstraintColumn(pk, pkColumn, info.keySeq));
                        this.addUniqueKey(pk);
                    }
                    if (CommonUtils.isEmpty((String)info.fkName)) {
                        info.fkName = String.valueOf(info.fkTableName.toUpperCase()) + "_FK" + info.keySeq;
                        fk = (GenericTableForeignKey)DBUtils.findObject(fkTable.getAssociations(monitor), (String)info.fkName);
                    } else {
                        fk = (GenericTableForeignKey)DBUtils.findObject(fkTable.getAssociations(monitor), (String)info.fkName);
                        if (fk == null) {
                            log.warn((Object)("Can't find foreign key '" + info.fkName + "' for table " + fkTable.getFullyQualifiedName(DBPEvaluationContext.DDL)));
                        }
                    }
                    if (fk != null && !fkList.contains((Object)fk)) {
                        fkList.add(fk);
                    }
                    if (fk != null) continue;
                    fk = (GenericTableForeignKey)((Object)fkMap.get(info.fkName));
                    if (fk == null) {
                        fk = new GenericTableForeignKey(fkTable, info.fkName, null, (DBSEntityReferrer)pk, deleteRule, updateRule, deferability, true);
                        fkMap.put(info.fkName, fk);
                        fkList.add(fk);
                    }
                    GenericTableForeignKeyColumnTable fkColumnInfo = new GenericTableForeignKeyColumnTable(fk, fkColumn, info.keySeq, pkColumn);
                    fk.addColumn(fkColumnInfo);
                }
                return fkList;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            if (ex instanceof SQLFeatureNotSupportedException) {
                log.debug((Object)"Error reading references", (Throwable)ex);
                return Collections.emptyList();
            }
            throw new DBException((Throwable)ex, this.getDataSource());
        }
    }

    public List<ForeignKeyInfo> loadReferenceInfoList(@NotNull JDBCSession session, GenericMetaObject fkObject) throws SQLException {
        ArrayList<ForeignKeyInfo> fkInfos = new ArrayList<ForeignKeyInfo>();
        JDBCDatabaseMetaData metaData = session.getMetaData();
        Throwable throwable = null;
        Object var6_7 = null;
        try (JDBCResultSet dbResult = metaData.getExportedKeys(this.getCatalog() == null ? null : this.getCatalog().getName(), this.getSchema() == null ? null : this.getSchema().getName(), this.getName());){
            while (dbResult.next()) {
                ForeignKeyInfo fkInfo = new ForeignKeyInfo();
                fkInfo.fetchColumnsInfo(fkObject, dbResult);
                fkInfos.add(fkInfo);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return fkInfos;
    }

    @Nullable
    @Association
    public List<? extends GenericTrigger> getTriggers(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.triggers == null) {
            GenericStructContainer parentObject = this.getParentObject();
            if (parentObject != null) {
                TableTriggerCache tableTriggerCache = parentObject.getTableTriggerCache();
                if (tableTriggerCache != null) {
                    this.triggers = tableTriggerCache.getObjects(monitor, (DBSObject)parentObject, (DBSObject)this);
                }
            } else {
                this.loadTriggers(monitor);
            }
        }
        return this.triggers;
    }

    private void loadTriggers(DBRProgressMonitor monitor) throws DBException {
        this.triggers = ((GenericDataSource)this.getDataSource()).getMetaModel().loadTriggers(monitor, (GenericStructContainer)this.getContainer(), this);
        if (this.triggers == null) {
            this.triggers = new ArrayList<GenericTrigger>();
        } else {
            DBUtils.orderObjects(this.triggers);
        }
    }

    public List<? extends GenericTrigger> getTriggerCache() {
        return this.triggers;
    }

    public boolean supportUniqueIndexes() {
        return true;
    }

    public Collection<DBSIndexType> getTableIndexTypes() {
        return Collections.singletonList(DBSIndexType.OTHER);
    }
}

