/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oceanbase.mysql.model;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLEngine;
import org.jkiss.dbeaver.ext.mysql.model.MySQLPrivilege;
import org.jkiss.dbeaver.ext.oceanbase.model.plan.OceanbasePlanAnalyzer;
import org.jkiss.dbeaver.ext.oceanbase.mysql.model.OceanbaseMySQLCatalog;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCBasicDataTypeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCStandardValueHandlerProvider;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCDataType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;

public class OceanbaseMySQLDataSource
extends MySQLDataSource {
    private final JDBCBasicDataTypeCache<MySQLDataSource, JDBCDataType> dataTypeCache;
    private final String tenantType;
    private final OceanbaseCatalogCache oceanbaseCatalogCache = new OceanbaseCatalogCache();

    public OceanbaseMySQLDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container);
        this.dataTypeCache = new JDBCBasicDataTypeCache((DBSObject)this);
        this.tenantType = container.getConnectionConfiguration().getProviderProperty("tenantType");
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
        this.oceanbaseCatalogCache.getAllObjects(monitor, (DBSObject)this);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBCQueryPlanner.class) {
            return adapter.cast((Object)new OceanbasePlanAnalyzer(this));
        }
        if (adapter == DBDValueHandlerProvider.class) {
            return adapter.cast(new JDBCStandardValueHandlerProvider());
        }
        return (T)super.getAdapter(adapter);
    }

    public MySQLEngine getEngine(String name) {
        return (MySQLEngine)DBUtils.findObject((Collection)this.getEngines(), (String)name, (boolean)true);
    }

    public MySQLEngine getDefaultEngine() {
        return this.getEngine("oceanbase");
    }

    public MySQLPrivilege getPrivilege(DBRProgressMonitor monitor, String name) throws DBException {
        if (name.equalsIgnoreCase("SHOW DB")) {
            return (MySQLPrivilege)DBUtils.findObject((Collection)this.getPrivileges(monitor), (String)"Show databases", (boolean)true);
        }
        return (MySQLPrivilege)DBUtils.findObject((Collection)this.getPrivileges(monitor), (String)name, (boolean)true);
    }

    public Collection<? extends DBSDataType> getLocalDataTypes() {
        return this.dataTypeCache.getCachedObjects();
    }

    public DBSDataType getLocalDataType(String typeName) {
        return (DBSDataType)this.dataTypeCache.getCachedObject(typeName);
    }

    public DBSDataType getLocalDataType(int typeID) {
        return this.dataTypeCache.getCachedObject(typeID);
    }

    public boolean isMySQLMode() {
        return this.tenantType.equals("MySQL");
    }

    public Collection<? extends MySQLCatalog> getChildren(@NotNull DBRProgressMonitor monitor) {
        return this.getCatalogs();
    }

    public MySQLCatalog getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) {
        return this.getCatalog(childName);
    }

    @NotNull
    public Class<? extends MySQLCatalog> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) {
        return OceanbaseMySQLCatalog.class;
    }

    OceanbaseCatalogCache getOceanbaseCatalogCache() {
        return this.oceanbaseCatalogCache;
    }

    public MySQLCatalog getCatalog(String name) {
        return (MySQLCatalog)this.oceanbaseCatalogCache.getCachedObject(name);
    }

    public Collection<MySQLCatalog> getCatalogs() {
        return new ArrayList<MySQLCatalog>(this.oceanbaseCatalogCache.getCachedObjects());
    }

    public boolean supportsInformationSchema() {
        return true;
    }

    static class OceanbaseCatalogCache
    extends JDBCObjectCache<OceanbaseMySQLDataSource, OceanbaseMySQLCatalog> {
        OceanbaseCatalogCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OceanbaseMySQLDataSource owner) throws SQLException {
            StringBuilder catalogQuery = new StringBuilder("show databases");
            DBSObjectFilter catalogFilters = owner.getContainer().getObjectFilter(MySQLCatalog.class, null, false);
            if (catalogFilters != null) {
                JDBCUtils.appendFilterClause((StringBuilder)catalogQuery, (DBSObjectFilter)catalogFilters, (String)"`Database`", (boolean)true);
            }
            JDBCPreparedStatement dbStat = session.prepareStatement(catalogQuery.toString());
            if (catalogFilters != null) {
                JDBCUtils.setFilterParameters((PreparedStatement)dbStat, (int)1, (DBSObjectFilter)catalogFilters);
            }
            return dbStat;
        }

        protected OceanbaseMySQLCatalog fetchObject(@NotNull JDBCSession session, @NotNull OceanbaseMySQLDataSource owner, @NotNull JDBCResultSet resultSet) {
            return new OceanbaseMySQLCatalog(owner, (ResultSet)resultSet);
        }
    }
}

