/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class PostgreMaterializedView
extends PostgreViewBase {
    private boolean withData;
    private long tablespaceId;

    public PostgreMaterializedView(PostgreSchema catalog) {
        super(catalog);
    }

    public PostgreMaterializedView(PostgreSchema catalog, ResultSet dbResult) {
        super(catalog, dbResult);
        this.withData = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"relispopulated");
        this.tablespaceId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"reltablespace");
    }

    public boolean isWithData() {
        return this.withData;
    }

    public void setWithData(boolean withData) {
        this.withData = withData;
    }

    public Collection<PostgreIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return this.getSchema().getIndexCache().getObjects(monitor, this.getSchema(), this);
    }

    @Override
    protected String readExtraDefinition(JDBCSession session, Map<String, Object> options) throws DBException {
        Collection<PostgreIndex> indexes = this.getIndexes(session.getProgressMonitor());
        if (!CommonUtils.isEmpty(indexes)) {
            StringBuilder indexDefs = new StringBuilder("\n-- View indexes:\n");
            for (PostgreIndex index : indexes) {
                String indexDefinition = index.getObjectDefinitionText(session.getProgressMonitor(), options);
                indexDefs.append(indexDefinition).append(";\n");
            }
            return indexDefs.toString();
        }
        return null;
    }

    @Override
    public String getTableTypeName() {
        return "MATERIALIZED VIEW";
    }

    @Property(viewable=true, editable=true, updatable=true, order=20, listProvider=PostgreTableBase.TablespaceListProvider.class)
    public PostgreTablespace getTablespace(DBRProgressMonitor monitor) throws DBException {
        if (this.tablespaceId == 0L) {
            return this.getDatabase().getDefaultTablespace(monitor);
        }
        return (PostgreTablespace)PostgreUtils.getObjectById(monitor, this.getDatabase().tablespaceCache, this.getDatabase(), this.tablespaceId);
    }

    public void setTablespace(PostgreTablespace tablespace) {
        this.tablespaceId = tablespace.getObjectId();
    }
}

