/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreMaterializedView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObjectPrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeGrant;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRoleMember;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRolePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPPersistedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBARole;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class PostgreRole
implements PostgreObject,
PostgrePrivilegeOwner,
DBPPersistedObject,
DBPSaveableObject,
DBPRefreshableObject,
DBPNamedObject2,
DBARole,
DBAUser,
PostgreScriptObject,
DBPScriptObjectExt2 {
    public static final String CAT_SETTINGS = "Settings";
    public static final String CAT_FLAGS = "Flags";
    private static final Log log = Log.getLog(PostgreRole.class);
    protected final PostgreDatabase database;
    protected long oid;
    protected String name;
    protected boolean superUser;
    protected boolean inherit;
    protected boolean createRole;
    protected boolean createDatabase;
    protected boolean canLogin;
    protected boolean replication;
    protected boolean bypassRls;
    protected int connLimit;
    protected String password;
    protected Date validUntil;
    protected boolean persisted;
    private MembersCache membersCache = new MembersCache(true);
    private MembersCache belongsCache = new MembersCache(false);
    private final String lineBreak = System.getProperty("line.separator");

    public PostgreRole(PostgreDatabase database, String name, String password, boolean isUser) {
        this.database = database;
        this.name = name;
        this.password = password;
        this.canLogin = isUser;
        this.persisted = false;
    }

    public PostgreRole(PostgreDatabase database, ResultSet dbResult) throws SQLException {
        this.database = database;
        this.loadInfo(dbResult);
    }

    protected void loadInfo(ResultSet dbResult) {
        this.persisted = true;
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"rolname");
        this.superUser = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolsuper");
        this.inherit = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolinherit");
        this.createRole = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolcreaterole");
        this.createDatabase = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolcreatedb");
        this.canLogin = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolcanlogin");
        this.replication = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolreplication");
        this.bypassRls = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolbypassrls");
        this.connLimit = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"rolconnlimit");
        this.password = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"rolpassword");
        this.validUntil = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"rolvaliduntil");
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.database;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return this.database.getDataSource();
    }

    public boolean isUser() {
        return this.canLogin;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.database;
    }

    @Property(viewable=true, order=2)
    public long getObjectId() {
        return this.oid;
    }

    @Property(editable=true, updatable=true, order=10, visibleIf=PostgreRoleCanBeSuperUserValidator.class)
    public boolean isSuperUser() {
        return this.superUser;
    }

    public void setSuperUser(boolean superUser) {
        this.superUser = superUser;
    }

    @Property(editable=true, updatable=true, order=11, visibleIf=PostgreRoleInheritValidator.class)
    public boolean isInherit() {
        return this.inherit;
    }

    public void setInherit(boolean inherit) {
        this.inherit = inherit;
    }

    @Property(editable=true, updatable=true, order=12)
    public boolean isCreateRole() {
        return this.createRole;
    }

    public void setCreateRole(boolean createRole) {
        this.createRole = createRole;
    }

    @Property(editable=true, updatable=true, order=13, visibleIf=PostgreRoleCanCreateDBValidator.class)
    public boolean isCreateDatabase() {
        return this.createDatabase;
    }

    public void setCreateDatabase(boolean createDatabase) {
        this.createDatabase = createDatabase;
    }

    @Property(editable=true, updatable=true, order=14)
    public boolean isCanLogin() {
        return this.canLogin;
    }

    public void setCanLogin(boolean canLogin) {
        this.canLogin = canLogin;
    }

    @Property(editable=true, updatable=true, order=15)
    public boolean isReplication() {
        return this.replication;
    }

    public void setReplication(boolean replication) {
        this.replication = replication;
    }

    @Property(editable=true, updatable=true, order=16)
    public boolean isBypassRls() {
        return this.bypassRls;
    }

    public void setBypassRls(boolean bypassRls) {
        this.bypassRls = bypassRls;
    }

    @Property(category="Settings", editable=true, updatable=true, order=20)
    public int getConnLimit() {
        return this.connLimit;
    }

    public void setConnLimit(int connLimit) {
        this.connLimit = connLimit;
    }

    @Property(hidden=true, category="Settings", editable=true, updatable=true, order=21)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Property(category="Settings", editable=true, updatable=true, order=22)
    public Date getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(Date validUntil) {
        this.validUntil = validUntil;
    }

    @Association
    public Collection<PostgreRoleMember> getMembers(DBRProgressMonitor monitor) throws DBException {
        return this.membersCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreRoleMember> getBelongs(DBRProgressMonitor monitor) throws DBException {
        return this.belongsCache.getAllObjects(monitor, this);
    }

    @Override
    public PostgreSchema getSchema() {
        return null;
    }

    @Override
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        return this;
    }

    public boolean supportsObjectDefinitionOption(String option) {
        return "ddl.includePermissions".equals(option);
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        String lineBreak = System.getProperty("line.separator");
        StringBuilder ddl = new StringBuilder();
        ddl.append("-- DROP ROLE ").append(DBUtils.getQuotedIdentifier((DBSObject)this)).append(";\n\n");
        ddl.append("CREATE ROLE ").append(DBUtils.getQuotedIdentifier((DBSObject)this)).append(" WITH ");
        this.addOptionToDDL(ddl, this.isSuperUser(), "SUPERUSER");
        this.addOptionToDDL(ddl, this.isCreateDatabase(), "CREATEDB");
        this.addOptionToDDL(ddl, this.isCreateRole(), "CREATEROLE");
        this.addOptionToDDL(ddl, this.isInherit(), "INHERIT");
        this.addOptionToDDL(ddl, this.isCanLogin(), "LOGIN");
        this.addOptionToDDL(ddl, this.isReplication(), "REPLICATION");
        this.addOptionToDDL(ddl, this.isBypassRls(), "BYPASSRLS");
        if (this.getConnLimit() > 0) {
            ddl.append(lineBreak);
            ddl.append("\tCONNECTION LIMIT ").append(this.getConnLimit());
        } else {
            ddl.append(lineBreak);
            ddl.append("\tCONNECTION LIMIT UNLIMITED");
        }
        if (this.getValidUntil() != null) {
            ddl.append(lineBreak);
            ddl.append("\tVALID UNTIL '").append(this.getValidUntil().toString()).append("'");
        }
        ddl.append(";");
        if (CommonUtils.getOption(options, (String)"ddl.includePermissions")) {
            ddl.append("\n");
            ArrayList<DBEPersistAction> actions = new ArrayList<DBEPersistAction>();
            PostgreUtils.getObjectGrantPermissionActions(monitor, this, actions, options);
            ddl.append("\n").append(SQLUtils.generateScript((DBPDataSource)this.getDataSource(), (DBEPersistAction[])actions.toArray(new DBEPersistAction[0]), (boolean)false));
        }
        return ddl.toString();
    }

    private void addOptionToDDL(StringBuilder ddl, boolean isOptionOn, String option) {
        ddl.append(this.lineBreak).append("\t");
        if (isOptionOn) {
            ddl.append(option);
        } else {
            ddl.append("NO").append(option);
        }
    }

    public List<PostgrePrivilege> getPrivileges(DBRProgressMonitor monitor, boolean includeNestedObjects) {
        ArrayList<PostgrePrivilege> permissions = new ArrayList<PostgrePrivilege>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read role privileges");){
                boolean supportsOnlySchemasPermissions;
                JDBCPreparedStatement dbStat;
                Object var8_16;
                try {
                    Throwable throwable2 = null;
                    var8_16 = null;
                    try {
                        dbStat = session.prepareStatement("SELECT * FROM information_schema.table_privileges WHERE table_catalog=? AND grantee=?");
                        try {
                            dbStat.setString(1, this.getDatabase().getName());
                            dbStat.setString(2, this.getName());
                            permissions.addAll(PostgreRole.getRolePermissions(this, PostgrePrivilegeGrant.Kind.TABLE, dbStat));
                        }
                        finally {
                            if (dbStat != null) {
                                dbStat.close();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable e) {
                    log.error((Object)"Error reading table privileges", e);
                }
                try {
                    e = null;
                    var8_16 = null;
                    try {
                        dbStat = session.prepareStatement("SELECT * FROM information_schema.routine_privileges WHERE specific_catalog=? AND grantee=?");
                        try {
                            dbStat.setString(1, this.getDatabase().getName());
                            dbStat.setString(2, this.getName());
                            permissions.addAll(PostgreRole.getRolePermissions(this, PostgrePrivilegeGrant.Kind.FUNCTION, dbStat));
                        }
                        finally {
                            if (dbStat != null) {
                                dbStat.close();
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        if (e == null) {
                            e = throwable4;
                        } else if (e != throwable4) {
                            e.addSuppressed(throwable4);
                        }
                        throw e;
                    }
                }
                catch (Throwable e) {
                    log.error((Object)"Error reading routine privileges", e);
                }
                boolean supportsDistinct = this.getDataSource().getServerType().supportsDistinctForStatementsWithAcl();
                boolean bl = supportsOnlySchemasPermissions = !this.getDataSource().isServerVersionAtLeast(9, 0);
                String otherObjectsSQL = supportsOnlySchemasPermissions ? "SELECT n.oid, n.nspacl FROM pg_catalog.pg_namespace n WHERE n.nspacl IS NOT NULL" : "SELECT * FROM (\n\tSELECT " + (supportsDistinct ? "DISTINCT" : "") + " relnamespace,\n" + "\trelacl,\n" + "\trelname,\n" + "\trelkind,\n" + "(aclexplode(relacl)).grantee as granteeI\n" + "FROM\n" + "\tpg_class\n" + "WHERE\n" + "\trelacl IS NOT NULL\n" + "\tAND relnamespace IN (\n" + "SELECT oid\n" + "FROM pg_namespace\n" + "WHERE nspname NOT LIKE 'pg_%' AND nspname != 'information_schema')\n" + "UNION ALL\n" + "SELECT " + (supportsDistinct ? "DISTINCT" : "") + "\n\tn.oid AS relnamespace,\n" + "\tnspacl AS relacl,\n" + "\tn.nspname AS relname,\n" + "\t'C' AS relkind,\n" + "(aclexplode(nspacl)).grantee as granteeI\n" + "FROM\n" + "\tpg_catalog.pg_namespace n\n" + "WHERE\n" + "\tn.nspacl IS NOT NULL \n" + "\t) AS tr\n" + "WHERE tr.granteeI=?" + " AND tr.relkind IN('S', 'm', 'C')";
                Throwable throwable5 = null;
                Object var11_23 = null;
                try (JDBCPreparedStatement dbStat2 = session.prepareStatement(otherObjectsSQL);){
                    if (!supportsOnlySchemasPermissions) {
                        dbStat2.setLong(1, this.getObjectId());
                    }
                    Throwable throwable6 = null;
                    Object var14_28 = null;
                    try (JDBCResultSet dbResult = dbStat2.executeQuery();){
                        while (dbResult.nextRow()) {
                            PostgreSchema schema;
                            long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (int)1);
                            Object acl = JDBCUtils.safeGetObject((ResultSet)dbResult, (int)2);
                            String objectName = null;
                            String objectType = null;
                            if (!supportsOnlySchemasPermissions) {
                                objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relname");
                                objectType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relkind");
                            }
                            if ((schema = this.getDatabase().getSchema(monitor, schemaId)) == null) continue;
                            List<PostgrePrivilege> privileges = null;
                            PostgrePrivilegeGrant.Kind pKind = null;
                            if (supportsOnlySchemasPermissions) {
                                pKind = PostgrePrivilegeGrant.Kind.SCHEMA;
                                privileges = PostgreUtils.extractPermissionsFromACL(monitor, schema, acl);
                            } else if (objectType != null && objectName != null) {
                                pKind = PostgrePrivilegeGrant.Kind.TABLE;
                                if (objectType.equals("C")) {
                                    privileges = PostgreUtils.extractPermissionsFromACL(monitor, schema, acl);
                                    pKind = PostgrePrivilegeGrant.Kind.SCHEMA;
                                } else if (objectType.equals("S")) {
                                    PostgreSequence sequence = schema.getSequence(monitor, objectName);
                                    privileges = PostgreUtils.extractPermissionsFromACL(monitor, sequence, acl);
                                    pKind = PostgrePrivilegeGrant.Kind.SEQUENCE;
                                } else {
                                    PostgreMaterializedView materializedView = schema.getMaterializedView(monitor, objectName);
                                    privileges = PostgreUtils.extractPermissionsFromACL(monitor, materializedView, acl);
                                }
                            }
                            for (PostgrePrivilege p : CommonUtils.safeCollection(privileges)) {
                                if (!(p instanceof PostgreObjectPrivilege) || !this.getName().equals(((PostgreObjectPrivilege)p).getGrantee())) continue;
                                ArrayList<PostgrePrivilegeGrant> grants = new ArrayList<PostgrePrivilegeGrant>();
                                PostgrePrivilege.ObjectPermission[] objectPermissionArray = p.getPermissions();
                                int n = objectPermissionArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    PostgrePrivilege.ObjectPermission perm = objectPermissionArray[n2];
                                    grants.add(new PostgrePrivilegeGrant(perm.getGrantor(), this.getName(), this.getDatabase().getName(), schema.getName(), objectName, perm.getPrivilegeType(), false, false));
                                    ++n2;
                                }
                                permissions.add(new PostgreRolePrivilege(this, pKind, schema.getName(), objectName, grants));
                            }
                        }
                    }
                    catch (Throwable throwable7) {
                        if (throwable6 == null) {
                            throwable6 = throwable7;
                        } else if (throwable6 != throwable7) {
                            throwable6.addSuppressed(throwable7);
                        }
                        throw throwable6;
                    }
                }
                catch (Throwable throwable8) {
                    if (throwable5 == null) {
                        throwable5 = throwable8;
                    } else if (throwable5 != throwable8) {
                        throwable5.addSuppressed(throwable8);
                    }
                    throw throwable5;
                }
                Collections.sort(permissions);
            }
            catch (Throwable throwable9) {
                if (throwable == null) {
                    throwable = throwable9;
                } else if (throwable != throwable9) {
                    throwable.addSuppressed(throwable9);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error reading role privileges", (Throwable)e);
        }
        return permissions;
    }

    @Override
    public String generateChangeOwnerQuery(String owner) {
        return null;
    }

    protected static Collection<PostgrePrivilege> getRolePermissions(PostgreRole role, PostgrePrivilegeGrant.Kind kind, JDBCPreparedStatement dbStat) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCResultSet dbResult = dbStat.executeQuery();){
            LinkedHashMap<String, List> privs = new LinkedHashMap<String, List>();
            while (dbResult.next()) {
                PostgrePrivilegeGrant privilege = new PostgrePrivilegeGrant(kind, (ResultSet)dbResult);
                String tableId = String.valueOf(privilege.getObjectSchema()) + "." + privilege.getObjectName();
                List privList = privs.computeIfAbsent(tableId, k -> new ArrayList());
                privList.add(privilege);
            }
            ArrayList<PostgrePrivilege> result = new ArrayList<PostgrePrivilege>(privs.size());
            for (List priv : privs.values()) {
                result.add(new PostgreRolePrivilege(role, kind, ((PostgrePrivilegeGrant)priv.get(0)).getObjectSchema(), ((PostgrePrivilegeGrant)priv.get(0)).getObjectName(), priv));
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        this.membersCache.clearCache();
        this.belongsCache.clearCache();
        return this;
    }

    public String toString() {
        return this.getName();
    }

    static class MembersCache
    extends JDBCObjectCache<PostgreRole, PostgreRoleMember> {
        private final boolean members;

        MembersCache(boolean members) {
            this.members = members;
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreRole owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM pg_catalog.pg_auth_members WHERE " + (this.members ? "roleid" : "member") + "=?");
            dbStat.setLong(1, owner.getObjectId());
            return dbStat;
        }

        protected PostgreRoleMember fetchObject(@NotNull JDBCSession session, @NotNull PostgreRole owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreRoleMember(owner, (ResultSet)dbResult);
        }
    }

    public static class PostgreRoleCanBeSuperUserValidator
    implements IPropertyValueValidator<PostgreRole, Object> {
        public boolean isValidValue(PostgreRole object, Object value) throws IllegalArgumentException {
            return object.getDataSource().getServerType().supportsSuperusers();
        }
    }

    public static class PostgreRoleCanCreateDBValidator
    implements IPropertyValueValidator<PostgreRole, Object> {
        public boolean isValidValue(PostgreRole object, Object value) throws IllegalArgumentException {
            return object.getDataSource().getServerType().supportsRolesWithCreateDBAbility();
        }
    }

    public static class PostgreRoleInheritValidator
    implements IPropertyValueValidator<PostgreRole, Object> {
        public boolean isValidValue(PostgreRole object, Object value) throws IllegalArgumentException {
            return object.getDataSource().getServerType().supportsInheritance();
        }
    }
}

