/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPReferentialIntegrityController;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreTableRegular
extends PostgreTable
implements DBPReferentialIntegrityController {
    private static final String DISABLE_REFERENTIAL_INTEGRITY_STATEMENT = "ALTER TABLE ? DISABLE TRIGGER ALL";
    private static final String ENABLE_REFERENTIAL_INTEGRITY_STATEMENT = "ALTER TABLE ? ENABLE TRIGGER ALL";

    public PostgreTableRegular(PostgreSchema catalog) {
        super(catalog);
    }

    public PostgreTableRegular(DBRProgressMonitor monitor, PostgreSchema catalog, PostgreTableRegular source) throws DBException {
        super(monitor, (PostgreTableContainer)catalog, source, false);
    }

    public PostgreTableRegular(PostgreSchema catalog, ResultSet dbResult) {
        super(catalog, dbResult);
    }

    public boolean supportsChangingReferentialIntegrity(@NotNull DBRProgressMonitor monitor) {
        return ((PostgreDataSource)this.getDataSource()).getServerType().supportsDisablingAllTriggers();
    }

    public void enableReferentialIntegrity(@NotNull DBRProgressMonitor monitor, boolean enable) throws DBException {
        String sql = this.getChangeReferentialIntegrityStatement(monitor, enable);
        if (sql == null) {
            return;
        }
        sql = sql.replace("?", this.getFullyQualifiedName(DBPEvaluationContext.DDL));
        try {
            DBUtils.executeInMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Changing referential integrity", (String)sql);
        }
        catch (SQLException e) {
            throw new DBException("Unable to change referential integrity", (Throwable)e);
        }
    }

    @Nullable
    public String getChangeReferentialIntegrityStatement(@NotNull DBRProgressMonitor monitor, boolean enable) {
        if (!this.supportsChangingReferentialIntegrity(monitor)) {
            return null;
        }
        if (enable) {
            return ENABLE_REFERENTIAL_INTEGRITY_STATEMENT;
        }
        return DISABLE_REFERENTIAL_INTEGRITY_STATEMENT;
    }
}

