/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.util.Properties;
import org.jkiss.dbeaver.ext.mssql.SQLServerMessages;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.utils.CommonUtils;

public enum SQLServerAuthentication {
    SQL_SERVER_PASSWORD(SQLServerMessages.authentication_sql_server_title, SQLServerMessages.authentication_sql_server_description, true, true, true, (connectionInfo, properties) -> {
        properties.put("integratedSecurity", String.valueOf(false));
        SQLServerAuthentication.setStandardCredentials(connectionInfo, properties);
    }),
    WINDOWS_INTEGRATED(SQLServerMessages.authentication_windows_title, SQLServerMessages.authentication_windows_description, true, false, false, (connectionInfo, properties) -> properties.put("integratedSecurity", String.valueOf(true))),
    NTLM("NTLM", "NTLM authentication", true, true, true, (connectionInfo, properties) -> {
        properties.put("integratedSecurity", String.valueOf(true));
        properties.put("authenticationScheme", "NTLM");
        String userName = connectionInfo.getUserName();
        int divPos = userName.indexOf(64);
        if (divPos != -1) {
            properties.put("domain", userName.substring(divPos + 1));
            properties.put("user", userName.substring(0, divPos));
        }
    }),
    AD_PASSWORD(SQLServerMessages.authentication_ad_password_title, SQLServerMessages.authentication_ad_password_description, false, true, true, (connectionInfo, properties) -> {
        properties.put("integratedSecurity", String.valueOf(false));
        properties.put("authentication", "ActiveDirectoryPassword");
        if (!CommonUtils.isEmpty((String)connectionInfo.getUserName())) {
            properties.put("UserName", connectionInfo.getUserName());
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getUserPassword())) {
            properties.put("Password", connectionInfo.getUserPassword());
        }
    }),
    AD_MSI(SQLServerMessages.authentication_ad_msi_title, SQLServerMessages.authentication_ad_msi_description, false, true, false, (connectionInfo, properties) -> {
        properties.put("authentication", "ActiveDirectoryMSI");
        if (!CommonUtils.isEmpty((String)connectionInfo.getUserName())) {
            properties.put("msiClientId", connectionInfo.getUserName());
            properties.remove("user");
            properties.remove("password");
        }
    }),
    AD_INTERACTIVE(SQLServerMessages.authentication_ad_interactive_title, SQLServerMessages.authentication_ad_interactive_description, false, true, false, (connectionInfo, properties) -> properties.put("authentication", "ActiveDirectoryInteractive")),
    AD_INTEGRATED(SQLServerMessages.authentication_ad_integrated_title, SQLServerMessages.authentication_ad_integrated_description, false, false, false, (connectionInfo, properties) -> {
        properties.put("authentication", "ActiveDirectoryIntegrated");
        properties.remove("user");
        properties.remove("password");
    }),
    KERBEROS_INTEGRATED(SQLServerMessages.authentication_kerberos_title, SQLServerMessages.authentication_kerberos_description, false, false, false, (connectionInfo, properties) -> {
        properties.put("integratedSecurity", String.valueOf(true));
        properties.put("authenticationScheme", "JavaKerberos");
    }),
    OTHER(SQLServerMessages.authentication_other_title, SQLServerMessages.authentication_other_description, true, true, true, (connectionInfo, properties) -> SQLServerAuthentication.setStandardCredentials(connectionInfo, properties));

    private final String title;
    private final String description;
    private final boolean supportsJTDS;
    private final boolean allowsPassword;
    private final boolean allowsUserName;
    private final AuthInitializer initializer;

    private static void setStandardCredentials(DBPConnectionConfiguration connectionInfo, Properties properties) {
        if (!CommonUtils.isEmpty((String)connectionInfo.getUserName())) {
            properties.put("user", connectionInfo.getUserName());
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getUserPassword())) {
            properties.put("password", connectionInfo.getUserPassword());
        }
    }

    private SQLServerAuthentication(String title, String description, boolean supportsJTDS, boolean allowsUserName, boolean allowsPassword, AuthInitializer initializer) {
        this.title = title;
        this.description = description;
        this.supportsJTDS = supportsJTDS;
        this.allowsUserName = allowsUserName;
        this.allowsPassword = allowsPassword;
        this.initializer = initializer;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isSupportsJTDS() {
        return this.supportsJTDS;
    }

    public boolean isAllowsUserName() {
        return this.allowsUserName;
    }

    public boolean isAllowsPassword() {
        return this.allowsPassword;
    }

    public AuthInitializer getInitializer() {
        return this.initializer;
    }

    public static interface AuthInitializer {
        public void initializeAuthentication(DBPConnectionConfiguration var1, Properties var2) throws DBCException;
    }
}

