/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndex;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableUniqueKeyColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;

public class SQLServerTableUniqueKey
extends JDBCTableConstraint<SQLServerTableBase> {
    private SQLServerTableIndex index;
    private List<SQLServerTableUniqueKeyColumn> columns;

    public SQLServerTableUniqueKey(SQLServerTableBase table, String name, String remarks, DBSEntityConstraintType constraintType, SQLServerTableIndex index, boolean persisted) {
        super((JDBCTable)table, name, remarks, constraintType, persisted);
        this.index = index;
    }

    protected SQLServerTableUniqueKey(DBRProgressMonitor monitor, SQLServerTableBase table, DBSEntityConstraint source) throws DBException {
        super((JDBCTable)table, source, false);
        this.index = table.getIndex(monitor, source.getName());
    }

    @Property(viewable=true, order=10)
    public SQLServerTableIndex getIndex() {
        return this.index;
    }

    public List<? extends DBSEntityAttributeRef> getAttributeReferences(DBRProgressMonitor monitor) {
        if (this.columns != null) {
            return this.columns;
        }
        return this.index.getAttributeReferences(monitor);
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((SQLServerTableBase)this.getTable()).getDatabase(), ((SQLServerTableBase)this.getTable()).getSchema(), this.getTable(), this});
    }

    @NotNull
    public SQLServerDataSource getDataSource() {
        return (SQLServerDataSource)((SQLServerTableBase)this.getTable()).getDataSource();
    }

    public void addColumn(SQLServerTableUniqueKeyColumn column) {
        if (this.columns == null) {
            this.columns = new ArrayList<SQLServerTableUniqueKeyColumn>();
        }
        this.columns.add(column);
    }

    void setColumns(List<SQLServerTableUniqueKeyColumn> columns) {
        this.columns = columns;
    }
}

