/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.internal.ui.palette.editparts;

import org.eclipse.draw2dl.Clickable;
import org.eclipse.draw2dl.Figure;
import org.eclipse.draw2dl.Graphics;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.Label;
import org.eclipse.draw2dl.LayoutManager;
import org.eclipse.draw2dl.RangeModel;
import org.eclipse.draw2dl.ScrollBar;
import org.eclipse.draw2dl.ScrollBarLayout;
import org.eclipse.draw2dl.Toggle;
import org.eclipse.draw2dl.TreeSearch;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Insets;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.PointList;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.gef3.internal.ui.palette.PaletteColorUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class PaletteScrollBar
extends ScrollBar {
    private static final PointList OUTER_DOWN_TRIANGLE = new PointList(3);
    private static final PointList INNER_DOWN_TRIANGLE = new PointList(3);
    private static final PointList OUTER_UP_TRIANGLE = new PointList(3);
    private static final PointList INNER_UP_TRIANGLE = new PointList(3);
    public static final int BUTTON_HEIGHT = 7;
    private static final int BUTTON_WIDTH = 76;
    private static final int SCROLL_TIME = 200;
    private static final Image TRANSPARENCY;
    protected Label downLabel;
    protected Label upLabel;

    static {
        Display display = Display.getCurrent();
        PaletteData pData = new PaletteData(255, 65280, 0xFF0000);
        RGB rgb = display.getSystemColor(18).getRGB();
        int fillColor = pData.getPixel(rgb);
        ImageData iData = new ImageData(1, 1, 24, pData);
        iData.setPixel(0, 0, fillColor);
        iData.setAlpha(0, 0, 200);
        TRANSPARENCY = new Image((Device)display, iData);
        OUTER_DOWN_TRIANGLE.addPoint(new Point(34, 2));
        OUTER_DOWN_TRIANGLE.addPoint(new Point(38, 6));
        OUTER_DOWN_TRIANGLE.addPoint(new Point(42, 2));
        INNER_DOWN_TRIANGLE.addPoint(new Point(35, 2));
        INNER_DOWN_TRIANGLE.addPoint(new Point(37, 5));
        INNER_DOWN_TRIANGLE.addPoint(new Point(41, 2));
        OUTER_UP_TRIANGLE.addPoint(new Point(33, 5));
        OUTER_UP_TRIANGLE.addPoint(new Point(38, 0));
        OUTER_UP_TRIANGLE.addPoint(new Point(42, 5));
        INNER_UP_TRIANGLE.addPoint(new Point(34, 5));
        INNER_UP_TRIANGLE.addPoint(new Point(38, 1));
        INNER_UP_TRIANGLE.addPoint(new Point(42, 5));
    }

    public boolean containsPoint(int x, int y) {
        return this.findDescendantAtExcluding(x, y, Figure.IdentitySearch.INSTANCE) != null;
    }

    protected Clickable createDefaultDownButton() {
        return this.createTransparentArrowButton(true);
    }

    protected Clickable createDefaultUpButton() {
        return this.createTransparentArrowButton(false);
    }

    private Toggle createTransparentArrowButton(final boolean down) {
        Toggle button = new Toggle(){

            protected void paintFigure(Graphics g) {
                if (!this.getModel().isMouseOver()) {
                    g.drawImage(TRANSPARENCY, new Rectangle(0, 0, 1, 1), this.getBounds());
                } else {
                    g.setBackgroundColor(this.getModel().isArmed() ? PaletteColorUtil.getSelectedColor() : PaletteColorUtil.getHoverColor());
                    g.fillRectangle(this.getBounds());
                }
                g.translate(this.getLocation());
                PointList outerPoints = PaletteScrollBar.this.transpose(down ? OUTER_DOWN_TRIANGLE : OUTER_UP_TRIANGLE);
                PointList innerPoints = PaletteScrollBar.this.transpose(down ? INNER_DOWN_TRIANGLE : INNER_UP_TRIANGLE);
                g.setBackgroundColor(PaletteColorUtil.WIDGET_LIST_BACKGROUND);
                g.fillPolygon(outerPoints);
                g.setBackgroundColor(PaletteColorUtil.WIDGET_DARK_SHADOW);
                g.fillPolygon(innerPoints);
                g.translate(this.getLocation().getNegated());
            }
        };
        button.setRolloverEnabled(true);
        button.setRequestFocusEnabled(false);
        return button;
    }

    private PointList transpose(PointList origPoints) {
        PointList transposedPoints = new PointList(origPoints.size());
        int i = 0;
        while (i < origPoints.size()) {
            transposedPoints.addPoint(this.transposer.t(origPoints.getPoint(i)));
            ++i;
        }
        return transposedPoints;
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        IFigure result = super.findFigureAt(x, y, search);
        if (result != this) {
            return result;
        }
        return null;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return new Dimension(wHint, hHint);
    }

    protected void initialize() {
        super.initialize();
        this.setLayoutManager((LayoutManager)new ScrollBarLayout(this.transposer){

            protected Rectangle layoutButtons(ScrollBar scrollBar) {
                Rectangle bounds = this.transposer.t(scrollBar.getClientArea());
                Dimension buttonSize = new Dimension(76, 7);
                PaletteScrollBar.this.getButtonUp().setBounds(this.transposer.t(new Rectangle(bounds.getTop().getTranslated(-(buttonSize.width / 2), 0), buttonSize)));
                Rectangle r = new Rectangle(bounds.getBottom().getTranslated(-(buttonSize.width / 2), -buttonSize.height), buttonSize);
                PaletteScrollBar.this.getButtonDown().setBounds(this.transposer.t(r));
                Rectangle trackBounds = bounds.getCropped(new Insets(buttonSize.height, 0, buttonSize.height, 0));
                RangeModel model = scrollBar.getRangeModel();
                PaletteScrollBar.this.getButtonUp().setVisible(model.getValue() != model.getMinimum());
                PaletteScrollBar.this.getButtonDown().setVisible(model.getValue() != model.getMaximum() - model.getExtent());
                return trackBounds;
            }
        });
        this.setPageUp(null);
        this.setPageDown(null);
        this.setThumb(null);
        this.setOpaque(false);
    }

    protected void stepDown() {
        this.timedStep(false);
    }

    protected void stepUp() {
        this.timedStep(true);
    }

    protected void timedStep(boolean up) {
        int increment = Math.max(this.getExtent() * 1 / 2, this.getStepIncrement());
        int value = this.getValue();
        long startTime = System.currentTimeMillis();
        long elapsedTime = System.currentTimeMillis() - startTime;
        while (elapsedTime < 200L) {
            int step = (int)((long)increment * elapsedTime / 200L);
            step = up ? value - step : value + step;
            this.setValue(step);
            this.getUpdateManager().performUpdate();
            elapsedTime = System.currentTimeMillis() - startTime;
        }
    }

    protected void updateDownLabel() {
        this.getButtonDown().setVisible(this.getValue() < this.getMaximum() - this.getExtent());
    }

    protected void updateUpLabel() {
        this.getButtonUp().setVisible(this.getValue() > this.getMinimum());
    }
}

