/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.ui.svg;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.File;
import org.apache.batik.ext.awt.image.codec.png.PNGImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriterRegistry;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclipse.draw2dl.FreeformLayeredPane;
import org.eclipse.draw2dl.Graphics;
import org.eclipse.draw2dl.IClippingStrategy;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.Layer;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.gef3.editparts.LayerManager;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.ui.export.ERDExportFormatHandler;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.erd.ui.part.DiagramPart;
import org.jkiss.dbeaver.ext.ui.svg.GraphicsToGraphics2DAdaptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;

public class ERDExportSVG
implements ERDExportFormatHandler {
    private static final Log log = Log.getLog(ERDExportSVG.class);
    private static boolean pngWriterRegistered;

    private static synchronized void checkWriterRegister() {
        if (!pngWriterRegistered) {
            ImageWriterRegistry.getInstance().register((ImageWriter)new PNGImageWriter());
            pngWriterRegistered = true;
        }
    }

    public void exportDiagram(EntityDiagram diagram, IFigure diagramFigure, DiagramPart diagramPart, File targetFile) throws DBException {
        ERDExportSVG.checkWriterRegister();
        try {
            IFigure figure = diagramPart.getFigure();
            Rectangle contentBounds = figure instanceof FreeformLayeredPane ? ((FreeformLayeredPane)figure).getFreeformExtent() : figure.getBounds();
            String svgNS = "http://www.w3.org/2000/svg";
            Document document = XMLUtils.createDocument();
            document.createAttributeNS(svgNS, "svg");
            SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
            svgGenerator.setSVGCanvasSize(new Dimension(contentBounds.width, contentBounds.height));
            GraphicsToGraphics2DAdaptor graphics = new GraphicsToGraphics2DAdaptor((Graphics2D)svgGenerator);
            graphics.translate(contentBounds.x * -1, contentBounds.y * -1);
            ERDExportSVG.paintDiagram(graphics, figure);
            LayerManager layerManager = (LayerManager)diagramPart.getViewer().getEditPartRegistry().get(LayerManager.ID);
            IFigure connectionLayer = layerManager.getLayer((Object)"Connection Layer");
            if (connectionLayer != null) {
                ERDExportSVG.paintDiagram(graphics, connectionLayer);
            }
            String filePath = targetFile.getAbsolutePath();
            svgGenerator.stream(filePath);
            ShellUtils.launchProgram((String)filePath);
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Save ERD as SVG", null, (Throwable)e);
        }
    }

    public static void paintDiagram(Graphics g, IFigure figure) {
        g.pushState();
        try {
            int j;
            Rectangle[] clipping;
            IClippingStrategy clippingStrategy = figure.getClippingStrategy();
            for (IFigure child : figure.getChildren()) {
                if (child instanceof Layer) {
                    ERDExportSVG.paintDiagram(g, child);
                    continue;
                }
                if (!child.isVisible()) continue;
                clipping = null;
                clipping = clippingStrategy != null ? clippingStrategy.getClip(child) : new Rectangle[]{child.getBounds()};
                j = 0;
                while (j < clipping.length) {
                    if (clipping[j].intersects(g.getClip(Rectangle.SINGLETON))) {
                        g.clipRect(clipping[j]);
                        child.paint(g);
                        g.restoreState();
                    }
                    ++j;
                }
            }
            for (IFigure child : figure.getChildren()) {
                if (child instanceof Layer) {
                    ERDExportSVG.paintDiagram(g, child);
                    continue;
                }
                if (!child.isVisible()) continue;
                clipping = null;
                clipping = clippingStrategy != null ? clippingStrategy.getClip(child) : new Rectangle[]{child.getBounds()};
                j = 0;
                while (j < clipping.length) {
                    if (clipping[j].intersects(g.getClip(Rectangle.SINGLETON))) {
                        g.clipRect(clipping[j]);
                        child.paint(g);
                        g.restoreState();
                    }
                    ++j;
                }
            }
        }
        finally {
            g.popState();
        }
    }
}

