# Camera|../common/camera.svg|

## Overview

Camera is an easy-to-use camera application that supports multiple functions such as taking pictures, recording videos, and switching between multiple camera devices.

## Guide

You can run, close or create shortcuts for Camera in the following ways.

### Run Camera

1. Click ![launcher](icon/deepin-launcher.svg) in the Dock and enter the Launcher interface.
2. Locate ![camera](icon/camera.svg) by scrolling the mouse wheel or searching "camera" in the Launcher interface and click it to run.
3. Right-click ![camera](icon/camera.svg) and you can:

 - Click **Send to desktop** to create a desktop shortcut.
 - Click **Send to dock** to fix the application in the dock.
 - Click **Add to startup** to add the application to startup and it will automatically run when the system starts up.

### Exit Camera

- On the Camera interface, click![close_icon](icon/close.svg)to exit Camera.
- Right-click ![camera](icon/camera.svg) in the dock and select **Close All** to exit Camera.
- On the Camera interface, click ![icon_menu](icon/icon_menu.svg) and select **Exit** to exit Camera.

## Operations

You can use the Camera application if your computer comes with a camera or is connected to a camera. Select photo or video mode on the Camera interface after running it.

### Take Photos

Photo mode is defaulted when Camera starts up. Click ![photograph](icon/photograph.svg) icon to take photos, and the photos will be displayed on the interface.

![image](jpg/image.png)

### Record Videos

On the Camera interface, click ![transcribe-bottom](icon/transcribe-bottom.svg) icon to to enter video mode. Click ![transcribe](icon/transcribe.svg) icon to start recording, and click ![stop](icon/stop.svg) icon to stop recording after video recording is completed. Video files will be displayed on the interface, and will also be saved in the default path.

![video](jpg/video.png)

### Process Photos and Videos

On the Camera interface, right-click the photos or video files to select copy, delete, and open folder.

Copy: copy the selected photo to another path.

Delete: delete the selected photo.

Open folder: open the folder where photos and videos are located.

![right-menu](jpg/right-menu.png)



## Main Menu

On the main menu, you can change settings for Camera, switch window themes, view help manual, and get more information about Camera.

### Settings

1. On the Camera interface, click ![界面按钮图标](icon/icon_menu.svg).

2. Click **Settings** to adjust **Basic**, **Shoot** and **Output** settings.

   - **Basic** setting: set up the **File location** for photos and videos.

   - **Shoot** setting: set up the **Burst mode** and **Self-timer delay** options.

     ![settings](jpg/settings.png)

   - **Output** setting: set up the **Output format** and **Resolution settings** for photos and videos.
   
     ![output-settings](jpg/output-settings.png)

#### Theme


The window theme provides three theme types, namely Light Theme, Dark Theme, and System Theme (default).

1.  On the Camera interface, click ![icon_menu](icon/icon_menu.svg).

2.  Click **Theme** to select a theme.

### Help

1.  On the Camera interface, click ![icon_menu](icon/icon_menu.svg).
2.  Click **Help** to view the manual of Camera.

### About

1.  On the Camera interface, click ![icon_menu](icon/icon_menu.svg).
2.  Click **About** to view the version and introduction of Camera. 

### Exit

1.   On the Camera interface, click ![icon_menu](icon/icon_menu.svg). 
2.  Click **Exit** to exit Camera.


<div class="version-info"><span>Update Date: 2020-09-30</span><span> Version: 1.0</span></div>