# Font Manager|deepin-font-manager|

## Overview

Font manager is a powerful font management tool. With Font Manager, you are not only able to search, install, enable, disable, and delete fonts among others, but also preview fonts by inputting texts and setting the text size. 

It supports fonts in ttf, ttc, and otf formats.

![0|main](fig/main.png)

## Guide

You can run, exit, and create shortcuts for Font Manager in the following ways.

### Run Font Manager

1. Click ![launcher](../common/deepin_launcher.svg) in the dock to enter the Launcher interface.

2. Locate ![deepin_font_manager](../common/deepin_font_manager.svg) by scrolling the mouse wheel or searching "font manager" in the Launcher interface, and click it to run.

3. Right-click ![deepin_font_manager](../common/deepin_font_manager.svg) , and you can:

   - Click **Send to desktop** to create a desktop shortcut
   - Click **Send to dock** to fix it in the Dock.
   - Click **Add to startup** to add the application to startup, and it will automatically run when the system starts up.
   
### Exit Font Manager

- Click ![close](../common/close_icon.svg) on the Font Manager interface to exit Font Manager.
- Right-click ![deepin_font_manager](../common/deepin_font_manager.svg) in the dock, and select **Close All** to exit.
- Click ![icon_menu](../common/icon_menu.svg) on the Font Manager interface, and select **Exit** to exit.

### View Shortcuts

On the Font Manager interface, press **Ctrl** + **Shift** + **?** on the keyboard to view shortcuts. Proficiency in shortcuts will greatly improve your efficiency.

![hotkey](fig/hotkey.png)

## Operations

### Introduce Interface

| Name       | Description                                                  |
| ---------- | ------------------------------------------------------------ |
| All fonts  | A collection of system fonts and user fonts, with all fonts displayed by default. |
| System     | Font lists that come with the system. The fonts in this font set cannot be deleted or disabled. |
| User       | Font lists installed by the user.                            |
| Favorites  | Your favorite font lists.                                    |
| Active     | All font collections under the startup status.               |
| Chinese    | Chinese characters in all font sets.                         |
| Monospaced | All fonts with the same character width.                     |

### Install Fonts

With Font Manager, you can not only install a single font but also install multiple fonts in a batch in the following ways:

- On the Font Manager interface, click ![add](../common/icon_plus.svg), select ![icon_menu](../common/icon_menu.svg)> **Add font** or right-click a font to select **Add font**.


- Double-click the font file.
-  Right-click the font file and select **Open with** > ![deepin_font_manager](../common/deepin_font_manager.svg) **Font Manager** to enter the Font Manager interface, and install the font.
- Drag the font file directly to the Font Manager icon  or its interface.

> ![notes](../common/notes.svg) Notes: 
>
> - Font Manager will detect your fonts automatically. If the font has been installed locally, a prompt message will pop up to advise you that an identical version has already been installed. You can select **Exit** or **Continue** to exit or continue the installation.
> -  You can go to **Control Center** > **Personalization** >  **Font** and set the font as **Standard Font**.

### Preview Fonts

Each text block of the font in the font sets presents the corresponding font style, and you can view the display effect by previewing fonts.

The default preview copy is **Don't let your dreams be dreams**, and is displayed in English.

1. Enter texts in the font preview input box at the bottom of the Font Manager interface.
2. Set the font size by dragging the scroll bar horizontally.
3. View the display effect in the font set list.

   > ![notes](../common/notes.svg) Notes: Drag the scroll bar to the left to reduce the font size, and drag it to the right to enlarge the font size. The font size ranges from 6px to 60px.

### Search Fonts

1. Click![search](../common/search.svg)in the search box on top of the Font Manager interface.

2.  Enter keywords and the search results will be displayed automatically.
   
3. Click ![0|close](../common/close_icon.svg) or delete the entered information in the search box to clear the current search criteria or cancel the search.


### Export Fonts

1. Right-click a font in the User list.

2.  Select **Export**.

The exported font is saved in the desk folder by default, with Font as its default folder name.

> ![notes](../common/notes.svg) Notes: Single and batch font(s) export are supported. System font cannot be exported.


### Favorite/Unfavorite Fonts

You can favorite or unfavorite a font via Font Manager.

1. Click the ![uncollect](../common/uncollection_normal.svg) icon to the right of an unfavorited font or right-click the font to select **Favorite** to favorite the font. 

2. Click the ![collect](../common/collection_normal.svg) icon to the right of an favorited font or right-click the font to select **Unfavorite** to unfavorite the font.  

   The favorited font will be displayed in the **Favorites** list.
   
> ![notes](../common/notes.svg) Notes: Favorite/Unfavorite are available for a single font and a batch of fonts.

### Enable/Disable Fonts

You can enable or disable a user font (enabled by default) in the Font Manager interface. 

1. Uncheck the checked font or right-click the font to select **Disable** to disable the font.
2. Check the unchecked font or right-click it to select **Enable**. The font will be enabled and displayed in the **Active** list. 

> ![notes](../common/notes.svg) Notes: Enable/Disable functions are available for a single font and a batch of fonts. System font and font currently being used can not be disabled.

### View Basic Font Information

You can view the basic font information via Font Manager.

1. Right-click the font and select **Details** in the font sets list on the Font Manager interface.

2. You can view the font icon, name, style, type, version, and description information.

![0|info](fig/info.png)

### View Font Installation Location

When the font is installed successfully, you can view its installation location via File Manager.

Right-click a font in the font sets list and select **Display in file manager** on the Font Manager interface to view the specific installation location.

### Delete Fonts

You can delete a font through Font Manager.

> ![notes](../common/notes.svg) Notes: Delete function is available for a single font and a batch of fonts. System font and font currently being used can not be deleted.

1. Select a font in the **User** list on the Font Manager interface, right-click and select **Delete**.
2. Click **Delete** in the pop-up box.

![0|font-delete](fig/font-delete.png)

## Main Menu

On the main menu, you can switch window themes, view help manual, and get more information about Font Manager.

### Theme

The window theme provides three theme types, namely Light Theme, Dark Theme, and System Theme.

1. On the Font Manager interface, click ![icon_menu](../common/icon_menu.svg).
2. Click **Theme** to select one theme.

### Help

1. On the Font Manager interface, click ![icon_menu](../common/icon_menu.svg).
2. Click **Help** to view the manual of Font Manager.

### About

1. On the Font Manager interface, click ![icon_menu](../common/icon_menu.svg).
2. Click **About** to view the version and introduction of Font Manager.

### Exit

1. On the Font Manager interface, click ![icon_menu](../common/icon_menu.svg).
2. Click **Exit** to exit Font Manager.