# 文件查看器|deepin-reader|

## 概述

文件查看器是系統自帶的文件查看軟體。不僅可以打開、查看文件，還可以對文件進行添加書籤、添加注釋以及對選擇的文字進行突顯顯示等操作。


## 使用入門

透過以下方式執行或關閉文件查看器，或者建立文件查看器的捷徑。


### 執行文件查看器

1. 點擊桌面底部的 ![deepin_launcher](../common/deepin_launcher.svg)，進入啟動器介面。
2. 上下滾動滑鼠滾輪瀏覽或透過搜尋，找到文件查看器 ![deepin_reader_24](../common/deepin_reader_24.svg)點擊執行。
3. 右鍵單擊 ![deepin_reader_24](../common/deepin_reader_24.svg)，您可以：

 - 點擊 **建立桌面捷徑**，在桌面建立捷徑。
 - 點擊 **釘選到Dock**，將應用程式固定到Dock。
 - 點擊 **開機啟動**，將應用程式添加到開機啟動項，在電腦開機時自動執行該應用。

   


### 關閉文件查看器

- 在文件查看器介面點擊 ![close_icon](../common/close_icon.svg)，關閉文件查看器。
- 在任務欄右鍵單擊 ![deepin_reader_24](../common/deepin_reader_24.svg)，選擇 **全部關閉** 來關閉文件查看器。
- 在文件查看器介面點擊 ![icon_menu](../common/icon_menu.svg)，選擇 **離開** 來關閉文件查看器。


### 查看快捷鍵

在文件查看器介面上，按下鍵盤上的 **Ctrl + Shift + ?** 組合鍵來查看快捷鍵，熟練地使用快捷鍵，將大大提升您的操作效率。

![1|hotkey](fig/hotkey.png)


## 基本功能

文件查看器具備基本的文件管理功能，可以執行開啟、儲存、列印文件，管理分頁、書籤、注釋等操作。


### 開啟文件

文件查看器支援查看DOCX、PDF和DJVU格式的文件，您可採用以下方式開啟文件

- 直接將文件拖曳到介面或其圖示上，同時拖曳多個文件到應用時，一個視窗打開多個分頁顯示各個文件。
- 右鍵單擊文件，選擇 **用其他程式開啟 > 選擇預設開啟程式**，在程式列表中選擇文件查看器開啟。

   > ![tips](../common/tips.svg)竅門：直接雙擊文件會使用預設程式開啟文件，您可以右鍵單擊文件，在 **屬性 > 用其他程式開啟** 中選擇一個預設程式。

- 在文件查看器初始介面，點擊 **選擇文件**。
- 在文件查看器介面，使用 **Ctrl + O** 組合鍵，選擇文件開啟。

   > ![notes](../common/notes.svg)說明：當有多個視窗時，在最早打開的視窗中打開文件，同一個文件只能打開一次。

### 儲存文件

對目前正在編輯、修改的文件進行儲存。

- 單擊 ![icon_menu](../common/icon_menu.svg) > **儲存** 或 **Ctrl + S** 組合鍵儲存文件。
- 單擊 ![icon_menu](../common/icon_menu.svg) > **另存為** 或 **Ctrl + Shift + S** ，另存文件。
  
### 列印文件

在文件查看器中使用列印，需要您連接並配置好印表機。

1. 在文件查看器中打開一個文件，在文件介面單擊滑鼠右鍵選擇 **列印**，也可以使用組合鍵 **Ctrl + P** 打開列印預覽。
2. 在列印預覽介面，您可以預覽文件，選擇印表機並設定列印頁面。
3. 在列印預覽介面，單擊 **進階設定**，可配置紙張大小、列印方式等相關參數。
4. 單擊 **列印** 即可將文件發送到印表機列印。

![printer](fig/printer.png)

![printer](fig/setting.png)

### 管理分頁

新增分頁

- 點擊 ![icon_menu](../common/icon_menu.svg) > **新分頁**，新增一個分頁。
- 當分頁達兩個或兩個以上時，點擊 **+** 按鈕添加新分頁。

切換/調整分頁

- 支援在同一視窗內拖曳調整分頁排序。
- 當分頁過多時會顯示 ![previous](../common/previous.svg) 或 ![next](../common/next.svg) 按鈕，單擊可左右移動。
- 滾動滑鼠切換分頁。 


視窗間的操作

- 支援拖曳分頁移出目前視窗，建立一個新的視窗。
- 支援拖曳一個分頁從一個視窗移動到另外一個視窗中。


### 管理書籤

在文件查看器介面，開啟一個文件。

- 添加書籤
   - 右鍵單擊文件查看器中的文件頁，選擇 **添加書籤**，可以為目前正在瀏覽的頁面添加書籤。
   - 將滑鼠移至瀏覽頁面右上角書籤區域顯示 ![view](../common/bookmark.svg)，點擊書籤圖示為目前頁添加書籤，書籤圖示變為藍色填充色。
- 刪除書籤：
   - 在已添加書籤的頁面，右鍵單擊書籤，選擇 **刪除書籤** 來刪除書籤。
   - 滑鼠移到書籤位置, 點擊有填充顏色的書籤，可以取消(刪除)該書籤。

   > ![notes](../common/notes.svg)說明：滑鼠移到書籤位置附近才會顯示書籤圖示。滑鼠移出書籤區域，書籤圖示消失。當添加書籤後，該圖示一直顯示。


### 管理注釋

在文件查看器介面，開啟一個文件。

- 添加注釋

   + 使用選擇工具選擇一段文字內容，單擊滑鼠右鍵選擇 **添加注釋**，完成注釋後被選中的文字內容會被突顯顯示。
   + 在文件空白處或者需要添加注釋的地方，單擊滑鼠右鍵選擇 **添加注釋**，完成注釋後該處會顯示一個突顯注釋圖示。

   > ![notes](../common/notes.svg)說明：如果注釋視窗不輸入內容，直接單擊其他區域，則添加注釋不成功或該條注釋自動刪除。輸入文字內容後，單擊其他區域，注釋內容自動儲存。

- 複製注釋
   -  在頁面上，右鍵單擊已完成注釋的突顯文字內容，在右鍵選單中選擇 **複製**，可以複製該條注釋的全部內容。
   -  在頁面上，右鍵單擊注釋圖示，在右鍵選單中選擇 **複製**，可以複製該條注釋的全部內容。
   -  點擊 ![menu](../common/thumbnail_normal_light.svg)，在左側選擇注釋目錄 ![view](../common/comments_normal_light.svg)，選定一個注釋，右鍵單擊選擇 **複製**，可以複製這條注釋的全部內容。

- 顯示注釋  
   1.  將滑鼠懸停至注釋圖示上，在出現的浮框中顯示部分注釋內容。
   2.  點擊注釋圖示，彈出注釋視窗，可以查看、重新編輯注釋內容。

- 刪除注釋
   - 右鍵點擊已完成注釋的突顯文字內容，在右鍵選單中選擇 **取消突顯**，可以刪除該條注釋內容。
   - 右鍵點擊注釋圖示，在右鍵選單中選擇 **刪除注釋**，可以刪除該條注釋內容。
   - 在左側選擇注釋目錄 ![view](../common/comments_normal_light.svg)，選定一個注釋，右鍵單擊選擇 **刪除注釋**，刪除這條注釋，對應頁面上的這條注釋內容也刪除。

   > ![notes](../common/notes.svg)說明：
   > + 支援在目前頁移動注釋圖示。
   > + DJVU格式的文件不支援添加注釋。

## 常用操作

文件查看器具備很多特色功能，這些功能都是為了讓文件管理更加簡單、高效。

### 搜尋

目前搜尋只針對目前分頁。

1. 在文件查看器介面，開啟一個文件。
2. 在文件頁面點擊滑鼠右鍵，選擇 **搜尋** 或使用快捷鍵 **Ctrl + F** 打開搜尋視窗。
3. 在搜尋框中，单击![search](../common/search.svg)，输入关键字。
4. 按下鍵盤上的 **Enter** 鍵進行搜尋。

   - 當搜尋到匹配的訊息時，側邊欄會顯示全部搜尋結果，文件中會突顯顯示匹配項。
   - 當沒有搜尋到匹配的訊息時，側邊欄會顯示「無搜尋結果」。

5.  當搜尋到匹配訊息後，點擊搜尋視窗的 ![search](../common/previousup.svg) 或 ![search](../common/nextdown.svg) 可逐個尋找上一個或下一個匹配項。
6. 點擊某條搜尋結果，跳轉到對應頁面，該頁面的搜尋結果突顯顯示。   
   
   > ![attention](../common/attention.svg)注意：不可搜尋文件中由文字轉換成圖片的內容。

7.  清除搜尋框中的訊息，即可清除搜尋結果。   
   
   > ![notes](../common/notes.svg)說明：DJVU格式的文件不支援搜尋功能。

### 快速翻頁

您能夠使用下列方法之一在文件的頁面中移動：

- 右鍵單擊，在快捷選單中選擇  **前一頁** 或 **後一頁** 。

- 如果您想直接瀏覽文件的開頭或結尾，可在右鍵選單中選擇 **第一頁** 或 **最後一頁**。

- 按下鍵盤上的 ![Down](../common/Down.svg) 或 ![Up](../common/Up.svg) 鍵。

- 在側邊欄縮圖目錄下，輸入頁碼數後按下 **Enter** 鍵。

### 切換目錄

在側邊欄，您可以切換文件縮圖目錄 ![view](../common/view_normal.svg)、文件目錄 ![catalog](../common/catalog.svg) 、書籤目錄 ![view](../common/bookmark_normal.svg)、注釋目錄 ![view](../common/comments_normal_light.svg) 。

### 全螢幕

1. 在文件查看器介面，單擊滑鼠右鍵選擇 **全螢幕** 或使用快捷鍵 **F11**，文件將以全螢幕形式展示。
2. 將滑鼠移到視窗頂部或者左側區域，呼出頂部工具列或側邊工具列；將滑鼠移出區域外，工具列自動隱藏。
3. 在全螢幕狀態下，呼出頂部工具列後點擊縮圖 ![icon](../common/thumbnail_normal_light.svg)，側邊工具列會一直顯示。
4. 按下鍵盤上的 **Esc** 鍵或使用快捷鍵 **F11** 退出全螢幕。

### 幻燈片秀

1. 在文件查看器介面，單擊滑鼠右鍵選擇 **幻燈片秀**，文件頁面將以幻燈片形式進行播放。
2. 點擊 ![play](../common/previous.svg) 或 ![play](../common/next.svg)切換文件頁面，也可以點擊 ![play](../common/suspend_normal.svg) 停止播放。
3. 按下鍵盤上的 **Esc** 鍵退出播放。


### 放大和縮小

使用下列方法之一放大或縮小頁面：

- 按下鍵盤上的 **Ctrl + “+”** 或 **Ctrl + “-”** 。
- 按下鍵盤上的 **Ctrl** 鍵的同時按住滑鼠中鍵向上或向下滑動。
- 在文件查看器介面選單欄，點擊 “**+** ”放大或 “**-**” 縮小 。
- 可在工具列中手動輸入縮略比例，或在下拉框選擇：10%、25%、50%、75%、100%、125%、150%、175%、200%、300%、400%、500%。文件跟著比例依次放大縮小。

   > ![notes](../common/notes.svg)說明：當使用觸控屏或觸控板電腦時，二指張開，放大文件；二指捏合，縮小文件。

### 調整頁面檢視

在工具列縮放比例下拉框中，您可以：

- 點擊 **雙頁顯示**，進入雙頁顯示模式。
- 點擊 **預設大小**，頁面以100%比例顯示。
- 點擊 **適合頁面**，目前視窗顯示整頁。
- 點擊 **適應高度**，頁面高度在視窗內全部顯示。
- 點擊 **適應寬度**，頁面寬度在視窗內全部顯示。  

### 設定突顯

1. 在文件查看器介面選中文字，單擊滑鼠右鍵選擇 **突顯**，此時有不同的突顯顏色可供選擇。 
2. 選定一種顏色，被選中的文字內容將以該顏色為底紋突顯顯示。   
3. 選中已經突顯顯示的文字，點擊 **取消突顯**，可以刪除文字突顯顯示效果。

   > ![notes](../common/notes.svg)說明：
   > - 當再次突顯文字時，可右鍵直接選擇 **突顯**，預設使用您上次選擇的突顯顏色。
   > - DJVU格式的文件不支援突顯設定。

### 旋轉

1. 在文件查看器介面，開啟一個文件。
2. 單擊滑鼠右鍵選擇 **左旋轉** 或 **右旋轉**，頁面全部同時向左或向右旋轉90°。

   > ![notes](../common/notes.svg)說明：當使用觸控屏或觸控板電腦時，二指放在文件區域並保持距離，同時旋轉手指來旋轉文件。

### 查看文件訊息

1. 在文件查看器介面，開啟一個文件。
2. 單擊滑鼠右鍵選擇 **文件訊息**，展示文件的屬性相關參數訊息。

## 主選單

在主選單中，您可以建立視窗、建立分頁、 [儲存文件](#儲存文件)、[搜尋文件](#搜尋)、切換視窗主題、查看說明手冊，了解文件查看器的更多訊息。


### 在檔案管理器中顯示

1. 在文件查看器介面，點擊 ![icon_menu](../common/icon_menu.svg)。
2. 點擊 **在檔案管理器中顯示**，開啟並定位該文件存放在資料夾的位置。

### 放大鏡

1. 在文件查看器介面，開啟一個文件。
2. 點擊 ![icon_menu](../common/icon_menu.svg) >  **放大鏡**。將滑鼠移動到頁面需要查看的區域，則該區域內容放大。
3. 按下鍵盤上的 **Esc** 鍵或右鍵單擊，即可取消放大鏡功能。

### 切換工具

1. 在文件查看器介面，單擊  ![icon_menu](../common/icon_menu.svg)。
2. 選擇 **工具**，支援兩種工具切換。
   - **選擇工具** 支援選擇文字內容。
   - **手形工具** 支援在文件中移動。


### 主題

視窗主題包含亮色主題、暗色主題和系統主題。

1. 在文件查看器介面，點擊 ![icon_menu](../common/icon_menu.svg)。
2. 點擊 **主題**，選擇一個主題顏色。

### 說明

查看說明手冊，透過說明進一步讓您了解和使用文件查看器。

1. 在文件查看器介面，點擊 ![icon_menu](../common/icon_menu.svg)。
2. 點擊 **說明**。
3. 查看關於文件查看器的說明手冊。


### 關於

1. 在文件查看器介面，點擊 ![icon_menu](../common/icon_menu.svg)。
2. 點擊 **關於**。
3. 查看關於文件查看器的版本和介紹。

### 離開

1. 在文件查看器介面，點擊 ![icon_menu](../common/icon_menu.svg)。
2. 點擊 **離開**。

