#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 dhall
version:              1.40.1
visibility:           public
id:                   dhall-1.40.1-BBA0sJUT1VO1oGrd484Mh1
key:                  dhall-1.40.1-BBA0sJUT1VO1oGrd484Mh1
license:              BSD-3-Clause
copyright:            2017 Gabriel Gonzalez
maintainer:           Gabriel439@gmail.com
author:               Gabriel Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  acc400f3b91463533171bdb3451dc2af
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics Dhall.Parser
    Dhall.Parser.Expression Dhall.Parser.Token Dhall.Pretty Dhall.Repl
    Dhall.Schemas Dhall.Set Dhall.Src Dhall.Substitution Dhall.TH
    Dhall.Tags Dhall.Tutorial Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.Eval Dhall.Import.Types Dhall.Marshal.Internal
    Dhall.Normalize Dhall.Parser.Combinators Dhall.Pretty.Internal
    Dhall.Syntax Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.0.1/site-local/dhall-1.40.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/dhall-1.40.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.40.1-BBA0sJUT1VO1oGrd484Mh1
depends:
    Diff-0.4.0-F7vyJzYzam9CwrUJdg8bD2
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S
    aeson-pretty-0.8.9-AXFdNE1ZWy326pjreSMahS
    ansi-terminal-0.11-Kvq5JBN7BE16HA1JfrRBzw
    atomic-write-0.2.0.7-IPdFizn7ZjdKIiRcDYK6iL base-4.15.0.0
    bytestring-0.10.12.1
    case-insensitive-1.2.1.0-J1gQtd73c5YHY9YtfdlefR
    cborg-0.2.5.0-G8isyjKSwV9I2ixUk7eYz0
    cborg-json-0.2.3.0-5abXPxFK4Ng94pZQydQV0P containers-0.6.4.1
    contravariant-1.5.5-1Tz7FaRP9yoKqkcBKkQ76A
    cryptonite-0.29-19SjDRwWNox27CMfesQpq4
    data-fix-0.3.2-FIAjuUl9RSe337ThPKUScQ deepseq-1.4.5.0
    directory-1.3.6.1 dotgen-0.4.3-D7BYbylA690EQm5UJkgmHT
    either-5.0.1.1-G5W4rd5K8xuDISfnWigtKP exceptions-0.10.4
    filepath-1.4.2.1 half-0.3.1-76Ia61sNxf53I73xlsxmdK
    hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH haskeline-0.8.1.0
    http-client-0.7.9-FqmYjByM3mW7WXdqjAmvxU
    http-client-tls-0.3.5.3-E3YrvnwOLk7FnDgjHH7fkr
    http-types-0.12.3-5xSWCbzPZMJ3FKkHNvWW2m
    lens-family-core-2.1.0-E2lAjFxxScaCmUozZIjJxS
    megaparsec-9.2.0-4jOz50swwTdC1OkC7cXk5Y
    memory-0.16.0-CGaPOmXCTce28vOCDDnDFr
    mmorph-1.2.0-Ajh0k0abpSlDb3Q6HDcBvb mtl-2.2.2
    network-uri-2.6.4.1-32se5oU1b9O36LNwPHSlHj
    optparse-applicative-0.16.1.0-2gAu0ltAuRsE34mFhrRUQs
    parser-combinators-1.3.0-5jHqYWwdpCqFWQLuYLRvi6
    parsers-0.12.10-Fygk0UygGWIJGasEEw3Ph0
    pretty-simple-4.0.0.0-8VEde7e0qnw3EAOfX0MsJi
    prettyprinter-1.7.1-163EeBePjHLIFZcbZybr4n
    prettyprinter-ansi-terminal-1.1.3-VoiK4SrFFn3Kv8sAYtuCw
    profunctors-5.6.2-BCER5gcx0SlDcSUAEwXMiO
    repline-0.4.0.0-L6GzQNG3zngJuxtUvhlgPf
    scientific-0.3.7.0-LvVousZ2ZB29j7oXDdeCGV
    serialise-0.2.3.0-1nOR1hyH7skL9bUKd1QrHU template-haskell-2.17.0.0
    text-1.2.4.1 text-manipulate-0.3.0.0-1LxePS8HRtsCz6DFKWz2uG
    th-lift-instances-0.1.18-277cz1WljFxFFoGMSqzssz time-1.9.3
    transformers-0.5.6.2
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    uri-encode-1.5.0.7-6aLZTQiA7om92OSbOwO0Gz
    vector-0.12.3.1-41pb7QyPIvSGm54QlMLBN3

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

