/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringTemplateUtils;
import org.elasticsearch.xpack.monitoring.exporter.http.PublishableHttpResource;

public class TemplateHttpResource
extends PublishableHttpResource {
    private static final Logger logger = LogManager.getLogger(TemplateHttpResource.class);
    public static final Map<String, String> PARAMETERS;
    private final String templateName;
    private final Supplier<String> template;

    public TemplateHttpResource(String resourceOwnerName, @Nullable TimeValue masterTimeout, String templateName, Supplier<String> template) {
        super(resourceOwnerName, masterTimeout, PARAMETERS);
        this.templateName = Objects.requireNonNull(templateName);
        this.template = Objects.requireNonNull(template);
    }

    @Override
    protected void doCheck(RestClient client, ActionListener<Boolean> listener) {
        this.versionCheckForResource(client, listener, logger, "/_template", this.templateName, "monitoring template", this.resourceOwnerName, "monitoring cluster", XContentType.JSON.xContent(), MonitoringTemplateUtils.LAST_UPDATED_VERSION);
    }

    @Override
    protected void doPublish(RestClient client, ActionListener<Boolean> listener) {
        this.putResource(client, listener, logger, "/_template", this.templateName, Collections.emptyMap(), this::templateToHttpEntity, "monitoring template", this.resourceOwnerName, "monitoring cluster");
    }

    HttpEntity templateToHttpEntity() {
        StringEntity stringEntity;
        block8: {
            XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, this.template.get());
            try {
                XContentBuilder builder = JsonXContent.contentBuilder();
                IndexTemplateMetadata.Builder.removeType((IndexTemplateMetadata)IndexTemplateMetadata.Builder.fromXContent((XContentParser)parser, (String)this.templateName), (XContentBuilder)builder);
                stringEntity = new StringEntity(BytesReference.bytes((XContentBuilder)builder).utf8ToString(), ContentType.APPLICATION_JSON);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot serialize template [" + this.templateName + "] for monitoring export", ex);
                }
            }
            parser.close();
        }
        return stringEntity;
    }

    static {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("filter_path", "*.version");
        PARAMETERS = Collections.unmodifiableMap(parameters);
    }
}

