/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Collections;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.license.CryptUtils;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseUtils;

class SelfGeneratedLicense {
    SelfGeneratedLicense() {
    }

    public static License create(License.Builder specBuilder, DiscoveryNodes currentNodes) {
        return SelfGeneratedLicense.create(specBuilder, LicenseUtils.compatibleLicenseVersion(currentNodes));
    }

    public static License create(License.Builder specBuilder, int version) {
        String signature;
        License spec = specBuilder.issuer("elasticsearch").version(version).build();
        try {
            XContentBuilder contentBuilder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
            spec.toXContent(contentBuilder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("license_spec_view", "true")));
            byte[] encrypt = version < 4 ? CryptUtils.encryptV3Format(BytesReference.toBytes((BytesReference)BytesReference.bytes((XContentBuilder)contentBuilder))) : CryptUtils.encrypt(BytesReference.toBytes((BytesReference)BytesReference.bytes((XContentBuilder)contentBuilder)));
            byte[] bytes = new byte[8 + encrypt.length];
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.putInt(-version).putInt(encrypt.length).put(encrypt);
            signature = Base64.getEncoder().encodeToString(bytes);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return License.builder().fromLicenseSpec(spec, signature).build();
    }

    public static boolean verify(License license) {
        try {
            License expectedLicense;
            byte[] signatureBytes = Base64.getDecoder().decode(license.signature());
            ByteBuffer byteBuffer = ByteBuffer.wrap(signatureBytes);
            int version = byteBuffer.getInt();
            int contentLen = byteBuffer.getInt();
            byte[] content = new byte[contentLen];
            byteBuffer.get(content);
            byte[] decryptedContent = -version < 4 ? CryptUtils.decryptV3Format(content) : CryptUtils.decrypt(content);
            try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, decryptedContent);){
                parser.nextToken();
                expectedLicense = License.builder().fromLicenseSpec(License.fromXContent(parser), license.signature()).version(-version).build();
            }
            return license.equals(expectedLicense);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static License.LicenseType validateSelfGeneratedType(License.LicenseType type) {
        switch (type) {
            case BASIC: 
            case TRIAL: {
                return type;
            }
        }
        throw new IllegalArgumentException("invalid self generated license type [" + (Object)((Object)type) + "], only " + (Object)((Object)License.LicenseType.BASIC) + " and " + (Object)((Object)License.LicenseType.TRIAL) + " are accepted");
    }
}

