/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.time.Clock;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicensesMetadata;
import org.elasticsearch.license.PostStartTrialRequest;
import org.elasticsearch.license.PostStartTrialResponse;
import org.elasticsearch.license.SelfGeneratedLicense;
import org.elasticsearch.xpack.core.XPackPlugin;

public class StartTrialClusterTask
extends ClusterStateUpdateTask {
    private static final String ACKNOWLEDGEMENT_HEADER = "This API initiates a free 30-day trial for all platinum features. By starting this trial, you agree that it is subject to the terms and conditions at https://www.elastic.co/legal/trial_license/. To begin your free trial, call /start_trial again and specify the \"acknowledge=true\" parameter.";
    private static final Map<String, String[]> ACK_MESSAGES = Collections.singletonMap("security", new String[]{"With a trial license, X-Pack security features are available, but are not enabled by default."});
    private final Logger logger;
    private final String clusterName;
    private final PostStartTrialRequest request;
    private final ActionListener<PostStartTrialResponse> listener;
    private final Clock clock;

    StartTrialClusterTask(Logger logger, String clusterName, Clock clock, PostStartTrialRequest request, ActionListener<PostStartTrialResponse> listener) {
        this.logger = logger;
        this.clusterName = clusterName;
        this.request = request;
        this.listener = listener;
        this.clock = clock;
    }

    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
        LicensesMetadata oldLicensesMetadata = (LicensesMetadata)oldState.metadata().custom("licenses");
        this.logger.debug("started self generated trial license: {}", (Object)oldLicensesMetadata);
        if (!this.request.isAcknowledged()) {
            this.listener.onResponse((Object)new PostStartTrialResponse(PostStartTrialResponse.Status.NEED_ACKNOWLEDGEMENT, ACK_MESSAGES, ACKNOWLEDGEMENT_HEADER));
        } else if (oldLicensesMetadata == null || oldLicensesMetadata.isEligibleForTrial()) {
            this.listener.onResponse((Object)new PostStartTrialResponse(PostStartTrialResponse.Status.UPGRADED_TO_TRIAL));
        } else {
            this.listener.onResponse((Object)new PostStartTrialResponse(PostStartTrialResponse.Status.TRIAL_ALREADY_ACTIVATED));
        }
    }

    public ClusterState execute(ClusterState currentState) throws Exception {
        XPackPlugin.checkReadyForXPackCustomMetadata(currentState);
        LicensesMetadata currentLicensesMetadata = (LicensesMetadata)currentState.metadata().custom("licenses");
        if (!this.request.isAcknowledged()) {
            return currentState;
        }
        if (currentLicensesMetadata == null || currentLicensesMetadata.isEligibleForTrial()) {
            long issueDate = this.clock.millis();
            Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentState.metadata());
            long expiryDate = issueDate + LicenseService.NON_BASIC_SELF_GENERATED_LICENSE_DURATION.getMillis();
            License.Builder specBuilder = License.builder().uid(UUID.randomUUID().toString()).issuedTo(this.clusterName).issueDate(issueDate).type(this.request.getType()).expiryDate(expiryDate);
            if (License.LicenseType.isEnterprise(this.request.getType())) {
                specBuilder.maxResourceUnits(1000);
            } else {
                specBuilder.maxNodes(1000);
            }
            License selfGeneratedLicense = SelfGeneratedLicense.create(specBuilder, currentState.nodes());
            LicensesMetadata newLicensesMetadata = new LicensesMetadata(selfGeneratedLicense, Version.CURRENT);
            mdBuilder.putCustom("licenses", (Metadata.Custom)newLicensesMetadata);
            return ClusterState.builder((ClusterState)currentState).metadata(mdBuilder).build();
        }
        return currentState;
    }

    public void onFailure(String source, @Nullable Exception e) {
        this.logger.error((Message)new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
        this.listener.onFailure(e);
    }
}

