/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Terms;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;

final class SeqIdGeneratingFilterReader
extends FilterDirectoryReader {
    private final long primaryTerm;

    private SeqIdGeneratingFilterReader(DirectoryReader in, SeqIdGeneratingSubReaderWrapper wrapper) throws IOException {
        super(in, (FilterDirectoryReader.SubReaderWrapper)wrapper);
        this.primaryTerm = wrapper.primaryTerm;
    }

    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        return SeqIdGeneratingFilterReader.wrap(in, this.primaryTerm);
    }

    static DirectoryReader wrap(DirectoryReader in, long primaryTerm) throws IOException {
        IdentityHashMap<LeafReader, LeafReaderContext> ctxMap = new IdentityHashMap<LeafReader, LeafReaderContext>();
        for (LeafReaderContext leave : in.leaves()) {
            ctxMap.put(leave.reader(), leave);
        }
        return new SeqIdGeneratingFilterReader(in, new SeqIdGeneratingSubReaderWrapper(ctxMap, primaryTerm));
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    private static class SeqIdGeneratingSubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private final Map<LeafReader, LeafReaderContext> ctxMap;
        private final long primaryTerm;

        SeqIdGeneratingSubReaderWrapper(Map<LeafReader, LeafReaderContext> ctxMap, long primaryTerm) {
            this.ctxMap = ctxMap;
            this.primaryTerm = primaryTerm;
        }

        public LeafReader wrap(final LeafReader reader) {
            LeafReaderContext leafReaderContext = this.ctxMap.get(reader);
            final int docBase = leafReaderContext.docBase;
            return new SequentialStoredFieldsLeafReader(reader){

                protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader2) {
                    return reader2;
                }

                public NumericDocValues getNumericDocValues(String field) throws IOException {
                    if ("_seq_no".equals(field)) {
                        return new FakeNumericDocValues(this.maxDoc()){

                            public long longValue() {
                                return docBase + this.docID;
                            }
                        };
                    }
                    if ("_primary_term".equals(field)) {
                        return new FakeNumericDocValues(this.maxDoc()){

                            public long longValue() {
                                return primaryTerm;
                            }
                        };
                    }
                    if ("_version".equals(field)) {
                        return new FakeNumericDocValues(this.maxDoc()){

                            public long longValue() {
                                return 1L;
                            }
                        };
                    }
                    return super.getNumericDocValues(field);
                }

                public IndexReader.CacheHelper getCoreCacheHelper() {
                    return reader.getCoreCacheHelper();
                }

                public IndexReader.CacheHelper getReaderCacheHelper() {
                    return reader.getReaderCacheHelper();
                }

                public Terms terms(String field) {
                    throw new UnsupportedOperationException("_source only indices can't be searched or filtered");
                }

                public PointValues getPointValues(String field) {
                    throw new UnsupportedOperationException("_source only indices can't be searched or filtered");
                }
            };
        }
    }

    private static abstract class FakeNumericDocValues
    extends NumericDocValues {
        private final int maxDoc;
        int docID = -1;

        FakeNumericDocValues(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        public int docID() {
            return this.docID;
        }

        public int nextDoc() {
            this.docID = this.docID + 1 < this.maxDoc ? ++this.docID : Integer.MAX_VALUE;
            return this.docID;
        }

        public int advance(int target) {
            this.docID = target >= this.maxDoc ? Integer.MAX_VALUE : target;
            return this.docID;
        }

        public long cost() {
            return this.maxDoc;
        }

        public boolean advanceExact(int target) {
            this.advance(target);
            return this.docID != Integer.MAX_VALUE;
        }
    }
}

