/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.cluster.routing.allocation;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.DataTier;

public class DataTierAllocationDecider
extends AllocationDecider {
    public static final String NAME = "data_tier";
    public static final String CLUSTER_ROUTING_REQUIRE = "cluster.routing.allocation.require._tier";
    public static final String CLUSTER_ROUTING_INCLUDE = "cluster.routing.allocation.include._tier";
    public static final String CLUSTER_ROUTING_EXCLUDE = "cluster.routing.allocation.exclude._tier";
    public static final String INDEX_ROUTING_REQUIRE = "index.routing.allocation.require._tier";
    public static final String INDEX_ROUTING_INCLUDE = "index.routing.allocation.include._tier";
    public static final String INDEX_ROUTING_PREFER = "index.routing.allocation.include._tier_preference";
    public static final String INDEX_ROUTING_EXCLUDE = "index.routing.allocation.exclude._tier";
    public static final Setting<String> CLUSTER_ROUTING_REQUIRE_SETTING = Setting.simpleString((String)"cluster.routing.allocation.require._tier", DataTierAllocationDecider::validateTierSetting, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<String> CLUSTER_ROUTING_INCLUDE_SETTING = Setting.simpleString((String)"cluster.routing.allocation.include._tier", DataTierAllocationDecider::validateTierSetting, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<String> CLUSTER_ROUTING_EXCLUDE_SETTING = Setting.simpleString((String)"cluster.routing.allocation.exclude._tier", DataTierAllocationDecider::validateTierSetting, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<String> INDEX_ROUTING_REQUIRE_SETTING = Setting.simpleString((String)"index.routing.allocation.require._tier", DataTierAllocationDecider::validateTierSetting, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});
    public static final Setting<String> INDEX_ROUTING_INCLUDE_SETTING = Setting.simpleString((String)"index.routing.allocation.include._tier", DataTierAllocationDecider::validateTierSetting, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});
    public static final Setting<String> INDEX_ROUTING_EXCLUDE_SETTING = Setting.simpleString((String)"index.routing.allocation.exclude._tier", DataTierAllocationDecider::validateTierSetting, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});
    public static final Setting<String> INDEX_ROUTING_PREFER_SETTING = Setting.simpleString((String)"index.routing.allocation.include._tier_preference", DataTierAllocationDecider::validateTierSetting, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});
    private volatile String clusterRequire = null;
    private volatile String clusterInclude = null;
    private volatile String clusterExclude = null;

    private static void validateTierSetting(String setting) {
        Set invalidTiers;
        if (Strings.hasText((String)setting) && (invalidTiers = Arrays.stream(setting.split(",")).filter(tier -> !DataTier.validTierName(tier)).collect(Collectors.toSet())).size() > 0) {
            throw new IllegalArgumentException("invalid tier names: " + invalidTiers);
        }
    }

    public DataTierAllocationDecider(ClusterSettings clusterSettings) {
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_REQUIRE_SETTING, s -> {
            this.clusterRequire = s;
        });
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_INCLUDE_SETTING, s -> {
            this.clusterInclude = s;
        });
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_EXCLUDE_SETTING, s -> {
            this.clusterExclude = s;
        });
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(shardRouting, node.node(), allocation);
    }

    public Decision canAllocate(IndexMetadata indexMetadata, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(indexMetadata, node.node(), allocation);
    }

    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(shardRouting, node.node(), allocation);
    }

    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        Decision decision = this.shouldClusterFilter(node, allocation);
        if (decision != null) {
            return decision;
        }
        decision = this.shouldIndexFilter(indexMetadata, node, allocation);
        if (decision != null) {
            return decision;
        }
        decision = this.shouldIndexPreferTier(indexMetadata, node, allocation);
        if (decision != null) {
            return decision;
        }
        return allocation.decision(Decision.YES, NAME, "node passes include/exclude/require/prefer tier filters", new Object[0]);
    }

    private Decision shouldFilter(ShardRouting shardRouting, DiscoveryNode node, RoutingAllocation allocation) {
        Decision decision = this.shouldClusterFilter(node, allocation);
        if (decision != null) {
            return decision;
        }
        decision = this.shouldIndexFilter(allocation.metadata().getIndexSafe(shardRouting.index()), node, allocation);
        if (decision != null) {
            return decision;
        }
        decision = this.shouldIndexPreferTier(allocation.metadata().getIndexSafe(shardRouting.index()), node, allocation);
        if (decision != null) {
            return decision;
        }
        return allocation.decision(Decision.YES, NAME, "node passes include/exclude/require/prefer tier filters", new Object[0]);
    }

    private Decision shouldFilter(IndexMetadata indexMd, DiscoveryNode node, RoutingAllocation allocation) {
        Decision decision = this.shouldClusterFilter(node, allocation);
        if (decision != null) {
            return decision;
        }
        decision = this.shouldIndexFilter(indexMd, node, allocation);
        if (decision != null) {
            return decision;
        }
        decision = this.shouldIndexPreferTier(indexMd, node, allocation);
        if (decision != null) {
            return decision;
        }
        return allocation.decision(Decision.YES, NAME, "node passes include/exclude/require/prefer tier filters", new Object[0]);
    }

    private Decision shouldIndexPreferTier(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        Settings indexSettings = indexMetadata.getSettings();
        String tierPreference = (String)INDEX_ROUTING_PREFER_SETTING.get(indexSettings);
        if (Strings.hasText((String)tierPreference)) {
            Optional<String> tier = DataTierAllocationDecider.preferredAvailableTier(tierPreference, allocation.nodes());
            if (tier.isPresent()) {
                String tierName = tier.get();
                if (DataTierAllocationDecider.allocationAllowed(OpType.AND, tierName, node)) {
                    return allocation.decision(Decision.YES, NAME, "index has a preference for tiers [%s] and node has tier [%s]", new Object[]{tierPreference, tierName});
                }
                return allocation.decision(Decision.NO, NAME, "index has a preference for tiers [%s] and node does not meet the required [%s] tier", new Object[]{tierPreference, tierName});
            }
            return allocation.decision(Decision.NO, NAME, "index has a preference for tiers [%s], but no nodes for any of those tiers are available in the cluster", new Object[]{tierPreference});
        }
        return null;
    }

    private Decision shouldIndexFilter(IndexMetadata indexMd, DiscoveryNode node, RoutingAllocation allocation) {
        Settings indexSettings = indexMd.getSettings();
        String indexRequire = (String)INDEX_ROUTING_REQUIRE_SETTING.get(indexSettings);
        String indexInclude = (String)INDEX_ROUTING_INCLUDE_SETTING.get(indexSettings);
        String indexExclude = (String)INDEX_ROUTING_EXCLUDE_SETTING.get(indexSettings);
        if (Strings.hasText((String)indexRequire) && !DataTierAllocationDecider.allocationAllowed(OpType.AND, indexRequire, node)) {
            return allocation.decision(Decision.NO, NAME, "node does not match all index setting [%s] tier filters [%s]", new Object[]{INDEX_ROUTING_REQUIRE, indexRequire});
        }
        if (Strings.hasText((String)indexInclude) && !DataTierAllocationDecider.allocationAllowed(OpType.OR, indexInclude, node)) {
            return allocation.decision(Decision.NO, NAME, "node does not match any index setting [%s] tier filters [%s]", new Object[]{INDEX_ROUTING_INCLUDE, indexInclude});
        }
        if (Strings.hasText((String)indexExclude) && DataTierAllocationDecider.allocationAllowed(OpType.OR, indexExclude, node)) {
            return allocation.decision(Decision.NO, NAME, "node matches any index setting [%s] tier filters [%s]", new Object[]{INDEX_ROUTING_EXCLUDE, indexExclude});
        }
        return null;
    }

    private Decision shouldClusterFilter(DiscoveryNode node, RoutingAllocation allocation) {
        if (Strings.hasText((String)this.clusterRequire) && !DataTierAllocationDecider.allocationAllowed(OpType.AND, this.clusterRequire, node)) {
            return allocation.decision(Decision.NO, NAME, "node does not match all cluster setting [%s] tier filters [%s]", new Object[]{CLUSTER_ROUTING_REQUIRE, this.clusterRequire});
        }
        if (Strings.hasText((String)this.clusterInclude) && !DataTierAllocationDecider.allocationAllowed(OpType.OR, this.clusterInclude, node)) {
            return allocation.decision(Decision.NO, NAME, "node does not match any cluster setting [%s] tier filters [%s]", new Object[]{CLUSTER_ROUTING_INCLUDE, this.clusterInclude});
        }
        if (Strings.hasText((String)this.clusterExclude) && DataTierAllocationDecider.allocationAllowed(OpType.OR, this.clusterExclude, node)) {
            return allocation.decision(Decision.NO, NAME, "node matches any cluster setting [%s] tier filters [%s]", new Object[]{CLUSTER_ROUTING_EXCLUDE, this.clusterExclude});
        }
        return null;
    }

    public static Optional<String> preferredAvailableTier(String prioritizedTiers, DiscoveryNodes nodes) {
        String[] tiers = Strings.tokenizeToStringArray((String)prioritizedTiers, (String)",");
        return Arrays.stream(tiers).filter(tier -> DataTierAllocationDecider.tierNodesPresent(tier, nodes)).findFirst();
    }

    static boolean tierNodesPresent(String singleTier, DiscoveryNodes nodes) {
        assert (singleTier.equals(DiscoveryNodeRole.DATA_ROLE.roleName()) || DataTier.validTierName(singleTier)) : "tier " + singleTier + " is an invalid tier name";
        for (ObjectCursor node : nodes.getNodes().values()) {
            if (!((DiscoveryNode)node.value).getRoles().stream().map(DiscoveryNodeRole::roleName).anyMatch(s -> s.equals(DiscoveryNodeRole.DATA_ROLE.roleName()) || s.equals(singleTier))) continue;
            return true;
        }
        return false;
    }

    private static boolean allocationAllowed(OpType opType, String tierSetting, DiscoveryNode node) {
        String[] values;
        for (String value : values = Strings.tokenizeToStringArray((String)tierSetting, (String)",")) {
            if (node.getRoles().contains(DiscoveryNodeRole.DATA_ROLE) || node.getRoles().stream().map(DiscoveryNodeRole::roleName).collect(Collectors.toSet()).contains(value)) {
                if (opType != OpType.OR) continue;
                return true;
            }
            if (opType != OpType.AND) continue;
            return false;
        }
        return opType != OpType.OR;
    }

    private static enum OpType {
        AND,
        OR;

    }
}

