/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.IndexSettingProvider;

public class DataTier {
    public static final String DATA_CONTENT = "data_content";
    public static final String DATA_HOT = "data_hot";
    public static final String DATA_WARM = "data_warm";
    public static final String DATA_COLD = "data_cold";
    public static final Set<String> ALL_DATA_TIERS = new HashSet<String>(Arrays.asList("data_content", "data_hot", "data_warm", "data_cold"));
    public static DiscoveryNodeRole DATA_CONTENT_NODE_ROLE = new DiscoveryNodeRole("data_content", "s", true){

        public boolean isEnabledByDefault(Settings settings) {
            return DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.DATA_ROLE);
        }

        public Setting<Boolean> legacySetting() {
            return Setting.boolSetting((String)"node.data_content", settings -> Boolean.toString(DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.DATA_ROLE)), (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.NodeScope});
        }

        public DiscoveryNodeRole getCompatibilityRole(Version nodeVersion) {
            return nodeVersion.before(Version.V_7_10_0) ? DiscoveryNodeRole.DATA_ROLE : this;
        }
    };
    public static DiscoveryNodeRole DATA_HOT_NODE_ROLE = new DiscoveryNodeRole("data_hot", "h", true){

        public boolean isEnabledByDefault(Settings settings) {
            return DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.DATA_ROLE);
        }

        public Setting<Boolean> legacySetting() {
            return Setting.boolSetting((String)"node.data_hot", settings -> Boolean.toString(DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.DATA_ROLE)), (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.NodeScope});
        }

        public DiscoveryNodeRole getCompatibilityRole(Version nodeVersion) {
            return nodeVersion.before(Version.V_7_10_0) ? DiscoveryNodeRole.DATA_ROLE : this;
        }
    };
    public static DiscoveryNodeRole DATA_WARM_NODE_ROLE = new DiscoveryNodeRole("data_warm", "w", true){

        public boolean isEnabledByDefault(Settings settings) {
            return DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.DATA_ROLE);
        }

        public Setting<Boolean> legacySetting() {
            return Setting.boolSetting((String)"node.data_warm", settings -> Boolean.toString(DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.DATA_ROLE)), (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.NodeScope});
        }

        public DiscoveryNodeRole getCompatibilityRole(Version nodeVersion) {
            return nodeVersion.before(Version.V_7_10_0) ? DiscoveryNodeRole.DATA_ROLE : this;
        }
    };
    public static DiscoveryNodeRole DATA_COLD_NODE_ROLE = new DiscoveryNodeRole("data_cold", "c", true){

        public boolean isEnabledByDefault(Settings settings) {
            return DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.DATA_ROLE);
        }

        public Setting<Boolean> legacySetting() {
            return Setting.boolSetting((String)"node.data_cold", settings -> Boolean.toString(DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.DATA_ROLE)), (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.NodeScope});
        }

        public DiscoveryNodeRole getCompatibilityRole(Version nodeVersion) {
            return nodeVersion.before(Version.V_7_10_0) ? DiscoveryNodeRole.DATA_ROLE : this;
        }
    };

    public static boolean validTierName(String tierName) {
        return DATA_CONTENT.equals(tierName) || DATA_HOT.equals(tierName) || DATA_WARM.equals(tierName) || DATA_COLD.equals(tierName);
    }

    public static boolean isExplicitDataTier(Settings settings) {
        if (settings.hasValue("node.roles")) {
            return settings.getAsList("node.roles").stream().anyMatch(DataTier::validTierName);
        }
        return false;
    }

    public static boolean isContentNode(DiscoveryNode discoveryNode) {
        return discoveryNode.getRoles().contains(DATA_CONTENT_NODE_ROLE) || discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_ROLE);
    }

    public static boolean isHotNode(DiscoveryNode discoveryNode) {
        return discoveryNode.getRoles().contains(DATA_HOT_NODE_ROLE) || discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_ROLE);
    }

    public static boolean isWarmNode(DiscoveryNode discoveryNode) {
        return discoveryNode.getRoles().contains(DATA_WARM_NODE_ROLE) || discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_ROLE);
    }

    public static boolean isColdNode(DiscoveryNode discoveryNode) {
        return discoveryNode.getRoles().contains(DATA_COLD_NODE_ROLE) || discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_ROLE);
    }

    public static class DefaultHotAllocationSettingProvider
    implements IndexSettingProvider {
        private static final Logger logger = LogManager.getLogger(DefaultHotAllocationSettingProvider.class);

        public Settings getAdditionalIndexSettings(String indexName, boolean isDataStreamIndex, Settings indexSettings) {
            Set settings = indexSettings.keySet();
            if (settings.contains("index.routing.allocation.include._tier_preference")) {
                return Settings.builder().put("index.routing.allocation.include._tier_preference", DataTier.DATA_HOT).build();
            }
            if (settings.stream().anyMatch(s -> s.startsWith("index.routing.allocation.require.")) || settings.stream().anyMatch(s -> s.startsWith("index.routing.allocation.exclude.")) || settings.stream().anyMatch(s -> s.startsWith("index.routing.allocation.include."))) {
                logger.debug("index [{}] specifies custom index level routing filtering, skipping tier allocation", (Object)indexName);
                return Settings.EMPTY;
            }
            if (isDataStreamIndex) {
                return Settings.builder().put("index.routing.allocation.include._tier_preference", DataTier.DATA_HOT).build();
            }
            return Settings.builder().put("index.routing.allocation.include._tier_preference", DataTier.DATA_CONTENT).build();
        }
    }
}

