/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.async;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.ByteBufferStreamInput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncResponse;
import org.elasticsearch.xpack.core.async.AsyncTask;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.support.AuthenticationContextSerializer;

public final class AsyncTaskIndexService<R extends AsyncResponse<R>> {
    private static final Logger logger = LogManager.getLogger(AsyncTaskIndexService.class);
    public static final String HEADERS_FIELD = "headers";
    public static final String RESPONSE_HEADERS_FIELD = "response_headers";
    public static final String EXPIRATION_TIME_FIELD = "expiration_time";
    public static final String RESULT_FIELD = "result";
    private final String index;
    private final ClusterService clusterService;
    private final Client client;
    private final SecurityContext securityContext;
    private final NamedWriteableRegistry registry;
    private final Writeable.Reader<R> reader;

    static Settings settings() {
        return Settings.builder().put("index.codec", "best_compression").put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.auto_expand_replicas", "0-1").build();
    }

    static XContentBuilder mappings() throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("_meta").field("version", (ToXContent)Version.CURRENT).endObject().field("dynamic", "strict").startObject("properties").startObject(HEADERS_FIELD).field("type", "object").field("enabled", "false").endObject().startObject(RESPONSE_HEADERS_FIELD).field("type", "object").field("enabled", "false").endObject().startObject(RESULT_FIELD).field("type", "object").field("enabled", "false").endObject().startObject(EXPIRATION_TIME_FIELD).field("type", "long").endObject().endObject().endObject().endObject();
        return builder;
    }

    public AsyncTaskIndexService(String index, ClusterService clusterService, ThreadContext threadContext, Client client, String origin, Writeable.Reader<R> reader, NamedWriteableRegistry registry) {
        this.index = index;
        this.clusterService = clusterService;
        this.securityContext = new SecurityContext(clusterService.getSettings(), threadContext);
        this.client = new OriginSettingClient(client, origin);
        this.registry = registry;
        this.reader = reader;
    }

    public Client getClient() {
        return this.client;
    }

    void createIndexIfNecessary(ActionListener<Void> listener) {
        if (!this.clusterService.state().routingTable().hasIndex(this.index)) {
            try {
                this.client.admin().indices().prepareCreate(this.index).setSettings(AsyncTaskIndexService.settings()).addMapping("_doc", AsyncTaskIndexService.mappings()).execute(ActionListener.wrap(resp -> listener.onResponse(null), exc -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)exc) instanceof ResourceAlreadyExistsException) {
                        listener.onResponse(null);
                    } else {
                        logger.error("failed to create " + this.index + " index", (Throwable)exc);
                        listener.onFailure(exc);
                    }
                }));
            }
            catch (Exception exc2) {
                logger.error("failed to create " + this.index + " index", (Throwable)exc2);
                listener.onFailure(exc2);
            }
        } else {
            listener.onResponse(null);
        }
    }

    public void createResponse(String docId, Map<String, String> headers, R response, ActionListener<IndexResponse> listener) throws IOException {
        HashMap<String, Object> source = new HashMap<String, Object>();
        source.put(HEADERS_FIELD, headers);
        source.put(EXPIRATION_TIME_FIELD, response.getExpirationTime());
        source.put(RESULT_FIELD, this.encodeResponse(response));
        IndexRequest indexRequest = new IndexRequest(this.index).create(true).id(docId).source(source, XContentType.JSON);
        this.createIndexIfNecessary((ActionListener<Void>)ActionListener.wrap(v -> this.client.index(indexRequest, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    public void updateResponse(String docId, Map<String, List<String>> responseHeaders, R response, ActionListener<UpdateResponse> listener) {
        try {
            HashMap<String, Object> source = new HashMap<String, Object>();
            source.put(RESPONSE_HEADERS_FIELD, responseHeaders);
            source.put(RESULT_FIELD, this.encodeResponse(response));
            UpdateRequest request = ((UpdateRequest)new UpdateRequest().index(this.index)).id(docId).doc(source, XContentType.JSON).retryOnConflict(5);
            this.createIndexIfNecessary((ActionListener<Void>)ActionListener.wrap(v -> this.client.update(request, listener), arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateExpirationTime(String docId, long expirationTimeMillis, ActionListener<UpdateResponse> listener) {
        Map<String, Long> source = Collections.singletonMap(EXPIRATION_TIME_FIELD, expirationTimeMillis);
        UpdateRequest request = ((UpdateRequest)new UpdateRequest().index(this.index)).id(docId).doc(source, XContentType.JSON).retryOnConflict(5);
        this.createIndexIfNecessary((ActionListener<Void>)ActionListener.wrap(v -> this.client.update(request, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    public void deleteResponse(AsyncExecutionId asyncExecutionId, ActionListener<DeleteResponse> listener) {
        try {
            DeleteRequest request = new DeleteRequest(this.index).id(asyncExecutionId.getDocId());
            this.createIndexIfNecessary((ActionListener<Void>)ActionListener.wrap(v -> this.client.delete(request, listener), arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public <T extends AsyncTask> T getTask(TaskManager taskManager, AsyncExecutionId asyncExecutionId, Class<T> tClass) throws IOException {
        Task task = taskManager.getTask(asyncExecutionId.getTaskId().getId());
        if (!tClass.isInstance(task)) {
            return null;
        }
        AsyncTask asyncTask = (AsyncTask)task;
        if (!asyncTask.getExecutionId().equals(asyncExecutionId)) {
            return null;
        }
        Authentication auth = this.securityContext.getAuthentication();
        if (!this.ensureAuthenticatedUserIsSame(asyncTask.getOriginHeaders(), auth)) {
            throw new ResourceNotFoundException(asyncExecutionId.getEncoded() + " not found", new Object[0]);
        }
        return (T)asyncTask;
    }

    private void getEncodedResponse(AsyncExecutionId asyncExecutionId, boolean restoreResponseHeaders, ActionListener<Tuple<String, Long>> listener) {
        Authentication current = this.securityContext.getAuthentication();
        GetRequest internalGet = new GetRequest(this.index).preference(asyncExecutionId.getEncoded()).id(asyncExecutionId.getDocId());
        this.client.get(internalGet, ActionListener.wrap(get -> {
            if (!get.isExists()) {
                listener.onFailure((Exception)new ResourceNotFoundException(asyncExecutionId.getEncoded(), new Object[0]));
                return;
            }
            Map headers = (Map)get.getSource().get(HEADERS_FIELD);
            if (!this.ensureAuthenticatedUserIsSame(headers, current)) {
                listener.onFailure((Exception)new ResourceNotFoundException(asyncExecutionId.getEncoded(), new Object[0]));
                return;
            }
            if (restoreResponseHeaders && get.getSource().containsKey(RESPONSE_HEADERS_FIELD)) {
                Map responseHeaders = (Map)get.getSource().get(RESPONSE_HEADERS_FIELD);
                AsyncTaskIndexService.restoreResponseHeadersContext(this.securityContext.getThreadContext(), responseHeaders);
            }
            long expirationTime = (Long)get.getSource().get(EXPIRATION_TIME_FIELD);
            String encoded = (String)get.getSource().get(RESULT_FIELD);
            if (encoded != null) {
                listener.onResponse((Object)new Tuple((Object)encoded, (Object)expirationTime));
            } else {
                listener.onResponse(null);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void getResponse(AsyncExecutionId asyncExecutionId, boolean restoreResponseHeaders, ActionListener<R> listener) {
        this.getEncodedResponse(asyncExecutionId, restoreResponseHeaders, (ActionListener<Tuple<String, Long>>)ActionListener.wrap(t -> listener.onResponse(this.decodeResponse((String)t.v1()).withExpirationTime((Long)t.v2())), arg_0 -> listener.onFailure(arg_0)));
    }

    public void authorizeResponse(AsyncExecutionId asyncExecutionId, boolean restoreResponseHeaders, ActionListener<R> listener) {
        this.getEncodedResponse(asyncExecutionId, restoreResponseHeaders, (ActionListener<Tuple<String, Long>>)ActionListener.wrap(t -> listener.onResponse(null), arg_0 -> listener.onFailure(arg_0)));
    }

    boolean ensureAuthenticatedUserIsSame(Map<String, String> originHeaders, Authentication current) throws IOException {
        if (originHeaders == null || !originHeaders.containsKey("_xpack_security_authentication")) {
            return true;
        }
        if (current == null) {
            return false;
        }
        Authentication origin = AuthenticationContextSerializer.decode(originHeaders.get("_xpack_security_authentication"));
        return this.ensureAuthenticatedUserIsSame(origin, current);
    }

    boolean ensureAuthenticatedUserIsSame(Authentication original, Authentication current) {
        boolean samePrincipal = original.getUser().principal().equals(current.getUser().principal());
        boolean sameRealmType = original.getUser().isRunAs() ? (current.getUser().isRunAs() ? original.getLookedUpBy().getType().equals(current.getLookedUpBy().getType()) : original.getLookedUpBy().getType().equals(current.getAuthenticatedBy().getType())) : (current.getUser().isRunAs() ? original.getAuthenticatedBy().getType().equals(current.getLookedUpBy().getType()) : original.getAuthenticatedBy().getType().equals(current.getAuthenticatedBy().getType()));
        return samePrincipal && sameRealmType;
    }

    String encodeResponse(R response) throws IOException {
        try (BytesStreamOutput out = new BytesStreamOutput();){
            Version.writeVersion((Version)Version.CURRENT, (StreamOutput)out);
            response.writeTo((StreamOutput)out);
            String string = Base64.getEncoder().encodeToString(BytesReference.toBytes((BytesReference)out.bytes()));
            return string;
        }
    }

    R decodeResponse(String value) throws IOException {
        try (ByteBufferStreamInput buf = new ByteBufferStreamInput(ByteBuffer.wrap(Base64.getDecoder().decode(value)));){
            AsyncResponse asyncResponse;
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput((StreamInput)buf, this.registry);){
                in.setVersion(Version.readVersion((StreamInput)in));
                asyncResponse = (AsyncResponse)this.reader.read((StreamInput)in);
            }
            return (R)asyncResponse;
        }
    }

    public static void restoreResponseHeadersContext(ThreadContext threadContext, Map<String, List<String>> responseHeaders) {
        for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
            for (String value : entry.getValue()) {
                threadContext.addResponseHeader(entry.getKey(), value);
            }
        }
    }
}

