/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.async;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.async.DeleteAsyncResultRequest;
import org.elasticsearch.xpack.core.async.DeleteAsyncResultsService;

public class TransportDeleteAsyncResultAction
extends HandledTransportAction<DeleteAsyncResultRequest, AcknowledgedResponse> {
    private final DeleteAsyncResultsService deleteResultsService;
    private final ClusterService clusterService;
    private final TransportService transportService;

    @Inject
    public TransportDeleteAsyncResultAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, NamedWriteableRegistry registry, Client client, ThreadPool threadPool) {
        super("indices:data/read/async_search/delete", transportService, actionFilters, DeleteAsyncResultRequest::new);
        this.transportService = transportService;
        this.clusterService = clusterService;
        AsyncTaskIndexService store = new AsyncTaskIndexService(".async-search", clusterService, threadPool.getThreadContext(), client, "async_search", in -> {
            throw new UnsupportedOperationException("Reading is not supported during deletion");
        }, registry);
        this.deleteResultsService = new DeleteAsyncResultsService(store, transportService.getTaskManager());
    }

    protected void doExecute(Task task, DeleteAsyncResultRequest request, ActionListener<AcknowledgedResponse> listener) {
        AsyncExecutionId searchId = AsyncExecutionId.decode(request.getId());
        DiscoveryNode node = this.clusterService.state().nodes().get(searchId.getTaskId().getNodeId());
        if (this.clusterService.localNode().getId().equals(searchId.getTaskId().getNodeId()) || node == null) {
            this.deleteResultsService.deleteResult(request, listener);
        } else {
            TransportRequestOptions.Builder builder = TransportRequestOptions.builder();
            this.transportService.sendRequest(node, "indices:data/read/async_search/delete", (TransportRequest)request, builder.build(), (TransportResponseHandler)new ActionListenerResponseHandler(listener, AcknowledgedResponse::new, "same"));
        }
    }
}

