/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.Step;

public class CreateSnapshotStep
extends AsyncRetryDuringSnapshotActionStep {
    public static final String NAME = "create-snapshot";
    private static final Logger logger = LogManager.getLogger(CreateSnapshotStep.class);

    public CreateSnapshotStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    void performDuringNoSnapshot(IndexMetadata indexMetadata, ClusterState currentClusterState, AsyncActionStep.Listener listener) {
        String indexName = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata(indexMetadata);
        String policyName = indexMetadata.getSettings().get("index.lifecycle.name");
        String snapshotRepository = lifecycleState.getSnapshotRepository();
        if (!Strings.hasText((String)snapshotRepository)) {
            listener.onFailure(new IllegalStateException("snapshot repository is not present for policy [" + policyName + "] and index [" + indexName + "]"));
            return;
        }
        String snapshotName = lifecycleState.getSnapshotName();
        if (!Strings.hasText((String)snapshotName)) {
            listener.onFailure(new IllegalStateException("snapshot name was not generated for policy [" + policyName + "] and index [" + indexName + "]"));
            return;
        }
        CreateSnapshotRequest request = new CreateSnapshotRequest(snapshotRepository, snapshotName);
        request.indices(new String[]{indexName});
        request.waitForCompletion(true);
        request.includeGlobalState(false);
        request.masterNodeTimeout(CreateSnapshotStep.getMasterTimeout(currentClusterState));
        this.getClient().admin().cluster().createSnapshot(request, ActionListener.wrap(response -> {
            logger.debug("create snapshot response for policy [{}] and index [{}] is: {}", (Object)policyName, (Object)indexName, (Object)Strings.toString((ToXContent)response));
            SnapshotInfo snapInfo = response.getSnapshotInfo();
            if (snapInfo.failedShards() == 0) {
                listener.onResponse(true);
            } else {
                int failures = snapInfo.failedShards();
                int total = snapInfo.totalShards();
                logger.warn("failed to create snapshot successfully, {} failures  out of {} total shards failed", (Object)failures, (Object)total);
                listener.onResponse(false);
            }
        }, listener::onFailure));
    }
}

