/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class ForceMergeStep
extends AsyncActionStep {
    public static final String NAME = "forcemerge";
    private final int maxNumSegments;

    public ForceMergeStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, int maxNumSegments) {
        super(key, nextStepKey, client);
        this.maxNumSegments = maxNumSegments;
    }

    public int getMaxNumSegments() {
        return this.maxNumSegments;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ClusterState currentState, ClusterStateObserver observer, AsyncActionStep.Listener listener) {
        ForceMergeRequest request = new ForceMergeRequest(new String[]{indexMetadata.getIndex().getName()});
        request.maxNumSegments(this.maxNumSegments);
        this.getClient().admin().indices().forceMerge(request, ActionListener.wrap(response -> listener.onResponse(true), listener::onFailure));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxNumSegments);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ForceMergeStep other = (ForceMergeStep)obj;
        return super.equals(obj) && Objects.equals(this.maxNumSegments, other.maxNumSegments);
    }
}

