/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.protocol.xpack.frozen.FreezeRequest;
import org.elasticsearch.xpack.core.frozen.action.FreezeIndexAction;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class FreezeStep
extends AsyncRetryDuringSnapshotActionStep {
    public static final String NAME = "freeze";

    public FreezeStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public void performDuringNoSnapshot(IndexMetadata indexMetadata, ClusterState currentState, AsyncActionStep.Listener listener) {
        this.getClient().admin().indices().execute((ActionType)FreezeIndexAction.INSTANCE, (ActionRequest)((FreezeRequest)new FreezeRequest(indexMetadata.getIndex().getName()).masterNodeTimeout(FreezeStep.getMasterTimeout(currentState))), ActionListener.wrap(response -> {
            if (!response.isAcknowledged()) {
                throw new ElasticsearchException("freeze index request failed to be acknowledged", new Object[0]);
            }
            listener.onResponse(true);
        }, listener::onFailure));
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

