/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.searchablesnapshots.MountSearchableSnapshotAction;
import org.elasticsearch.xpack.core.searchablesnapshots.MountSearchableSnapshotRequest;

public class MountSnapshotStep
extends AsyncRetryDuringSnapshotActionStep {
    public static final String NAME = "mount-snapshot";
    private static final Logger logger = LogManager.getLogger(MountSnapshotStep.class);
    private final String restoredIndexPrefix;

    public MountSnapshotStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, String restoredIndexPrefix) {
        super(key, nextStepKey, client);
        this.restoredIndexPrefix = restoredIndexPrefix;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    public String getRestoredIndexPrefix() {
        return this.restoredIndexPrefix;
    }

    @Override
    void performDuringNoSnapshot(IndexMetadata indexMetadata, ClusterState currentClusterState, AsyncActionStep.Listener listener) {
        String indexName = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata(indexMetadata);
        String policyName = indexMetadata.getSettings().get("index.lifecycle.name");
        String snapshotRepository = lifecycleState.getSnapshotRepository();
        if (!Strings.hasText((String)snapshotRepository)) {
            listener.onFailure(new IllegalStateException("snapshot repository is not present for policy [" + policyName + "] and index [" + indexName + "]"));
            return;
        }
        String snapshotName = lifecycleState.getSnapshotName();
        if (!Strings.hasText((String)snapshotName)) {
            listener.onFailure(new IllegalStateException("snapshot name was not generated for policy [" + policyName + "] and index [" + indexName + "]"));
            return;
        }
        String mountedIndexName = this.restoredIndexPrefix + indexName;
        if (currentClusterState.metadata().index(mountedIndexName) != null) {
            logger.debug("mounted index [{}] for policy [{}] and index [{}] already exists. will not attempt to mount the index again", (Object)mountedIndexName, (Object)policyName, (Object)indexName);
            listener.onResponse(true);
            return;
        }
        MountSearchableSnapshotRequest mountSearchableSnapshotRequest = new MountSearchableSnapshotRequest(mountedIndexName, snapshotRepository, snapshotName, indexName, Settings.builder().put(IndexSettings.INDEX_CHECK_ON_STARTUP.getKey(), Boolean.FALSE.toString()).build(), new String[]{"index.lifecycle.name"}, false);
        this.getClient().execute((ActionType)MountSearchableSnapshotAction.INSTANCE, (ActionRequest)mountSearchableSnapshotRequest, ActionListener.wrap(response -> {
            if (response.status() != RestStatus.OK && response.status() != RestStatus.ACCEPTED) {
                logger.debug("mount snapshot response failed to complete");
                throw new ElasticsearchException("mount snapshot response failed to complete, got response " + response.status(), new Object[0]);
            }
            listener.onResponse(true);
        }, listener::onFailure));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.restoredIndexPrefix);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MountSnapshotStep other = (MountSnapshotStep)obj;
        return super.equals(obj) && Objects.equals(this.restoredIndexPrefix, other.restoredIndexPrefix);
    }
}

