/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class RemoveIndexLifecyclePolicyAction
extends ActionType<Response> {
    public static final RemoveIndexLifecyclePolicyAction INSTANCE = new RemoveIndexLifecyclePolicyAction();
    public static final String NAME = "indices:admin/ilm/remove_policy";

    protected RemoveIndexLifecyclePolicyAction() {
        super(NAME, Response::new);
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements IndicesRequest.Replaceable {
        private String[] indices;
        private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

        public Request(StreamInput in) throws IOException {
            super(in);
            this.indices = in.readStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
        }

        public Request() {
        }

        public Request(String ... indices) {
            if (indices == null) {
                throw new IllegalArgumentException("indices cannot be null");
            }
            this.indices = indices;
        }

        public Request indices(String ... indices) {
            this.indices = indices;
            return this;
        }

        public String[] indices() {
            return this.indices;
        }

        public void indicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.indices);
            this.indicesOptions.writeIndicesOptions(out);
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.indices), this.indicesOptions);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.deepEquals(this.indices, other.indices) && Objects.equals(this.indicesOptions, other.indicesOptions);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField HAS_FAILURES_FIELD = new ParseField("has_failures", new String[0]);
        public static final ParseField FAILED_INDEXES_FIELD = new ParseField("failed_indexes", new String[0]);
        public static final ConstructingObjectParser<Response, Void> PARSER = new ConstructingObjectParser("change_policy_for_index_response", a -> new Response((List)a[0]));
        private List<String> failedIndexes;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.failedIndexes = in.readStringList();
        }

        public Response(List<String> failedIndexes) {
            if (failedIndexes == null) {
                throw new IllegalArgumentException(FAILED_INDEXES_FIELD.getPreferredName() + " cannot be null");
            }
            this.failedIndexes = failedIndexes;
        }

        public List<String> getFailedIndexes() {
            return this.failedIndexes;
        }

        public boolean hasFailures() {
            return !this.failedIndexes.isEmpty();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(HAS_FAILURES_FIELD.getPreferredName(), this.hasFailures());
            builder.field(FAILED_INDEXES_FIELD.getPreferredName(), this.failedIndexes);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.failedIndexes);
        }

        public int hashCode() {
            return Objects.hash(this.failedIndexes);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.failedIndexes, other.failedIndexes);
        }

        static {
            PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), FAILED_INDEXES_FIELD);
            PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), HAS_FAILURES_FIELD);
        }
    }
}

