/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml;

import java.util.Collections;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.xpack.core.ml.utils.MlIndexAndAlias;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public class MlStatsIndex {
    public static final String TEMPLATE_NAME = ".ml-stats";
    private static final String MAPPINGS_VERSION_VARIABLE = "xpack.ml.version";

    private MlStatsIndex() {
    }

    public static String mapping() {
        return MlStatsIndex.mapping("_doc");
    }

    public static String mapping(String mappingType) {
        return TemplateUtils.loadTemplate("/org/elasticsearch/xpack/core/ml/stats_index_mappings.json", Version.CURRENT.toString(), MAPPINGS_VERSION_VARIABLE, Collections.singletonMap("xpack.ml.mapping_type", mappingType));
    }

    public static String indexPattern() {
        return ".ml-stats-*";
    }

    public static String writeAlias() {
        return ".ml-stats-write";
    }

    public static void createStatsIndexAndAliasIfNecessary(Client client, ClusterState state, IndexNameExpressionResolver resolver, ActionListener<Boolean> listener) {
        MlIndexAndAlias.createIndexAndAliasIfNecessary(client, state, resolver, TEMPLATE_NAME, MlStatsIndex.writeAlias(), listener);
    }
}

