/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.TimingStats;
import org.elasticsearch.xpack.core.ml.stats.ForecastStats;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class GetJobsStatsAction
extends ActionType<Response> {
    public static final GetJobsStatsAction INSTANCE = new GetJobsStatsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/job/stats/get";
    private static final String DATA_COUNTS = "data_counts";
    private static final String MODEL_SIZE_STATS = "model_size_stats";
    private static final String FORECASTS_STATS = "forecasts_stats";
    private static final String STATE = "state";
    private static final String NODE = "node";
    private static final String ASSIGNMENT_EXPLANATION = "assignment_explanation";
    private static final String OPEN_TIME = "open_time";
    private static final String TIMING_STATS = "timing_stats";

    private GetJobsStatsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends BaseTasksResponse
    implements ToXContentObject {
        private QueryPage<JobStats> jobsStats;

        public Response(QueryPage<JobStats> jobsStats) {
            super(Collections.emptyList(), Collections.emptyList());
            this.jobsStats = jobsStats;
        }

        public Response(List<TaskOperationFailure> taskFailures, List<? extends ElasticsearchException> nodeFailures, QueryPage<JobStats> jobsStats) {
            super(taskFailures, nodeFailures);
            this.jobsStats = jobsStats;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.jobsStats = new QueryPage(in, JobStats::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.jobsStats.writeTo(out);
        }

        public QueryPage<JobStats> getResponse() {
            return this.jobsStats;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.jobsStats.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobsStats);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.jobsStats, other.jobsStats);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }

        public static class JobStats
        implements ToXContentObject,
        Writeable {
            private final String jobId;
            private final DataCounts dataCounts;
            @Nullable
            private final ModelSizeStats modelSizeStats;
            @Nullable
            private final ForecastStats forecastStats;
            @Nullable
            private final TimeValue openTime;
            private final JobState state;
            @Nullable
            private final DiscoveryNode node;
            @Nullable
            private final String assignmentExplanation;
            @Nullable
            private final TimingStats timingStats;

            public JobStats(String jobId, DataCounts dataCounts, @Nullable ModelSizeStats modelSizeStats, @Nullable ForecastStats forecastStats, JobState state, @Nullable DiscoveryNode node, @Nullable String assignmentExplanation, @Nullable TimeValue openTime, @Nullable TimingStats timingStats) {
                this.jobId = Objects.requireNonNull(jobId);
                this.dataCounts = Objects.requireNonNull(dataCounts);
                this.modelSizeStats = modelSizeStats;
                this.forecastStats = forecastStats;
                this.state = Objects.requireNonNull(state);
                this.node = node;
                this.assignmentExplanation = assignmentExplanation;
                this.openTime = openTime;
                this.timingStats = timingStats;
            }

            public JobStats(StreamInput in) throws IOException {
                this.jobId = in.readString();
                this.dataCounts = new DataCounts(in);
                this.modelSizeStats = (ModelSizeStats)in.readOptionalWriteable(ModelSizeStats::new);
                this.state = JobState.fromStream(in);
                this.node = (DiscoveryNode)in.readOptionalWriteable(DiscoveryNode::new);
                this.assignmentExplanation = in.readOptionalString();
                this.openTime = in.readOptionalTimeValue();
                this.forecastStats = in.getVersion().onOrAfter(Version.V_6_4_0) ? (ForecastStats)in.readOptionalWriteable(ForecastStats::new) : null;
                this.timingStats = in.getVersion().onOrAfter(Version.V_7_3_0) ? (TimingStats)in.readOptionalWriteable(TimingStats::new) : null;
            }

            public String getJobId() {
                return this.jobId;
            }

            public DataCounts getDataCounts() {
                return this.dataCounts;
            }

            public ModelSizeStats getModelSizeStats() {
                return this.modelSizeStats;
            }

            public ForecastStats getForecastStats() {
                return this.forecastStats;
            }

            public JobState getState() {
                return this.state;
            }

            public DiscoveryNode getNode() {
                return this.node;
            }

            public String getAssignmentExplanation() {
                return this.assignmentExplanation;
            }

            public TimeValue getOpenTime() {
                return this.openTime;
            }

            public TimingStats getTimingStats() {
                return this.timingStats;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                this.toUnwrappedXContent(builder);
                return builder.endObject();
            }

            public XContentBuilder toUnwrappedXContent(XContentBuilder builder) throws IOException {
                builder.field(Job.ID.getPreferredName(), this.jobId);
                builder.field(GetJobsStatsAction.DATA_COUNTS, (ToXContent)this.dataCounts);
                if (this.modelSizeStats != null) {
                    builder.field(GetJobsStatsAction.MODEL_SIZE_STATS, (ToXContent)this.modelSizeStats);
                }
                if (this.forecastStats != null) {
                    builder.field(GetJobsStatsAction.FORECASTS_STATS, (ToXContent)this.forecastStats);
                }
                builder.field(GetJobsStatsAction.STATE, this.state.toString());
                if (this.node != null) {
                    builder.startObject(GetJobsStatsAction.NODE);
                    builder.field("id", this.node.getId());
                    builder.field("name", this.node.getName());
                    builder.field("ephemeral_id", this.node.getEphemeralId());
                    builder.field("transport_address", this.node.getAddress().toString());
                    builder.startObject("attributes");
                    for (Map.Entry entry : this.node.getAttributes().entrySet()) {
                        builder.field((String)entry.getKey(), (String)entry.getValue());
                    }
                    builder.endObject();
                    builder.endObject();
                }
                if (this.assignmentExplanation != null) {
                    builder.field(GetJobsStatsAction.ASSIGNMENT_EXPLANATION, this.assignmentExplanation);
                }
                if (this.openTime != null) {
                    builder.field(GetJobsStatsAction.OPEN_TIME, this.openTime.getStringRep());
                }
                if (this.timingStats != null) {
                    builder.field(GetJobsStatsAction.TIMING_STATS, (ToXContent)this.timingStats, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("include_calculated_fields", "true")));
                }
                return builder;
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.jobId);
                this.dataCounts.writeTo(out);
                out.writeOptionalWriteable((Writeable)this.modelSizeStats);
                this.state.writeTo(out);
                out.writeOptionalWriteable((Writeable)this.node);
                out.writeOptionalString(this.assignmentExplanation);
                out.writeOptionalTimeValue(this.openTime);
                if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
                    out.writeOptionalWriteable((Writeable)this.forecastStats);
                }
                if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
                    out.writeOptionalWriteable((Writeable)this.timingStats);
                }
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.jobId, this.dataCounts, this.modelSizeStats, this.forecastStats, this.state, this.node, this.assignmentExplanation, this.openTime, this.timingStats});
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                JobStats other = (JobStats)obj;
                return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.dataCounts, other.dataCounts) && Objects.equals(this.modelSizeStats, other.modelSizeStats) && Objects.equals(this.forecastStats, other.forecastStats) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.node, other.node) && Objects.equals(this.assignmentExplanation, other.assignmentExplanation) && Objects.equals(this.openTime, other.openTime) && Objects.equals(this.timingStats, other.timingStats);
            }
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response> {
        public RequestBuilder(ElasticsearchClient client, GetJobsStatsAction action) {
            super(client, (ActionType)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends BaseTasksRequest<Request> {
        @Deprecated
        public static final String ALLOW_NO_JOBS = "allow_no_jobs";
        public static final String ALLOW_NO_MATCH = "allow_no_match";
        private String jobId;
        private boolean allowNoMatch = true;
        private List<String> expandedJobsIds;

        public Request(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
            this.expandedJobsIds = Collections.singletonList(jobId);
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.jobId = in.readString();
            this.expandedJobsIds = in.readStringList();
            if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
                this.allowNoMatch = in.readBoolean();
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeStringCollection(this.expandedJobsIds);
            if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
                out.writeBoolean(this.allowNoMatch);
            }
        }

        public List<String> getExpandedJobsIds() {
            return this.expandedJobsIds;
        }

        public void setExpandedJobsIds(List<String> expandedJobsIds) {
            this.expandedJobsIds = expandedJobsIds;
        }

        public void setAllowNoMatch(boolean allowNoMatch) {
            this.allowNoMatch = allowNoMatch;
        }

        public String getJobId() {
            return this.jobId;
        }

        public boolean allowNoMatch() {
            return this.allowNoMatch;
        }

        public boolean match(Task task) {
            return this.expandedJobsIds.stream().anyMatch(jobId -> OpenJobAction.JobTaskMatcher.match(task, jobId));
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.allowNoMatch);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.allowNoMatch, other.allowNoMatch);
        }
    }
}

