/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.action.NodeAcknowledgedResponse;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class OpenJobAction
extends ActionType<NodeAcknowledgedResponse> {
    public static final OpenJobAction INSTANCE = new OpenJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/open";

    private OpenJobAction() {
        super(NAME, NodeAcknowledgedResponse::new);
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, NodeAcknowledgedResponse> {
        RequestBuilder(ElasticsearchClient client, OpenJobAction action) {
            super(client, (ActionType)action, (ActionRequest)new Request());
        }
    }

    public static interface JobTaskMatcher {
        public static boolean match(Task task, String expectedJobId) {
            if (task instanceof JobTaskMatcher) {
                if (Strings.isAllOrWildcard((String)expectedJobId)) {
                    return true;
                }
                String expectedDescription = "job-" + expectedJobId;
                return expectedDescription.equals(task.getDescription());
            }
            return false;
        }
    }

    public static class JobParams
    implements XPackPlugin.XPackPersistentTaskParams {
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        public static final ParseField JOB = new ParseField("job", new String[0]);
        public static final ObjectParser<JobParams, Void> PARSER = new ObjectParser("xpack/ml/job", true, JobParams::new);
        private String jobId;
        private TimeValue timeout = MachineLearningField.STATE_PERSIST_RESTORE_TIMEOUT;
        private Job job;

        public static JobParams fromXContent(XContentParser parser) {
            return JobParams.parseRequest(null, parser);
        }

        public static JobParams parseRequest(String jobId, XContentParser parser) {
            JobParams params = (JobParams)PARSER.apply(parser, null);
            if (jobId != null) {
                params.jobId = jobId;
            }
            return params;
        }

        JobParams() {
        }

        public JobParams(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public JobParams(StreamInput in) throws IOException {
            this.jobId = in.readString();
            this.timeout = TimeValue.timeValueMillis((long)in.readVLong());
            if (in.getVersion().onOrAfter(Version.V_6_6_0)) {
                this.job = (Job)in.readOptionalWriteable(Job::new);
            }
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public void setTimeout(TimeValue timeout) {
            this.timeout = timeout;
        }

        @Nullable
        public Job getJob() {
            return this.job;
        }

        public void setJob(Job job) {
            this.job = job;
        }

        public String getWriteableName() {
            return "xpack/ml/job";
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.jobId);
            out.writeVLong(this.timeout.millis());
            if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
                out.writeOptionalWriteable((Writeable)this.job);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
            if (this.job != null) {
                builder.field("job", (ToXContent)this.job);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.jobId, this.timeout, this.job});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            JobParams other = (JobParams)obj;
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.timeout, other.timeout) && Objects.equals((Object)this.job, (Object)other.job);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public Version getMinimalSupportedVersion() {
            return Version.CURRENT.minimumCompatibilityVersion();
        }

        static {
            PARSER.declareString(JobParams::setJobId, Job.ID);
            PARSER.declareString((params, val) -> params.setTimeout(TimeValue.parseTimeValue((String)val, (String)TIMEOUT.getPreferredName())), TIMEOUT);
            PARSER.declareObject(JobParams::setJob, (p, c) -> ((Job.Builder)Job.LENIENT_PARSER.apply(p, c)).build(), JOB);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements ToXContentObject {
        private JobParams jobParams;

        public static Request fromXContent(XContentParser parser) {
            return Request.parseRequest(null, parser);
        }

        public static Request parseRequest(String jobId, XContentParser parser) {
            JobParams jobParams = (JobParams)JobParams.PARSER.apply(parser, null);
            if (jobId != null) {
                jobParams.jobId = jobId;
            }
            return new Request(jobParams);
        }

        public Request(JobParams jobParams) {
            this.jobParams = jobParams;
        }

        public Request(String jobId) {
            this.jobParams = new JobParams(jobId);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.jobParams = new JobParams(in);
        }

        public Request() {
        }

        public JobParams getJobParams() {
            return this.jobParams;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.jobParams.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.jobParams.toXContent(builder, params);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobParams);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobParams, other.jobParams);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

