/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.datafeed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.datafeed.AggProvider;
import org.elasticsearch.xpack.core.ml.datafeed.ChunkingConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DelayedDataCheckConfig;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.ExtractorUtils;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;
import org.elasticsearch.xpack.core.ml.utils.QueryProvider;
import org.elasticsearch.xpack.core.ml.utils.XContentObjectTransformer;

public class DatafeedConfig
extends AbstractDiffable<DatafeedConfig>
implements ToXContentObject {
    public static final int DEFAULT_SCROLL_SIZE = 1000;
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int TWO_MINS_SECONDS = 120;
    private static final int TWENTY_MINS_SECONDS = 1200;
    private static final int HALF_DAY_SECONDS = 43200;
    private static final Logger logger = LogManager.getLogger(DatafeedConfig.class);
    public static final ParseField RESULTS_FIELD = new ParseField("datafeeds", new String[0]);
    public static String TYPE = "datafeed";
    public static final String DOC_COUNT = "doc_count";
    public static final ParseField ID = new ParseField("datafeed_id", new String[0]);
    public static final ParseField CONFIG_TYPE = new ParseField("config_type", new String[0]);
    public static final ParseField QUERY_DELAY = new ParseField("query_delay", new String[0]);
    public static final ParseField FREQUENCY = new ParseField("frequency", new String[0]);
    public static final ParseField INDEXES = new ParseField("indexes", new String[0]);
    public static final ParseField INDICES = new ParseField("indices", new String[0]);
    public static final ParseField QUERY = new ParseField("query", new String[0]);
    public static final ParseField SCROLL_SIZE = new ParseField("scroll_size", new String[0]);
    public static final ParseField AGGREGATIONS = new ParseField("aggregations", new String[0]);
    public static final ParseField AGGS = new ParseField("aggs", new String[0]);
    public static final ParseField SCRIPT_FIELDS = new ParseField("script_fields", new String[0]);
    public static final ParseField CHUNKING_CONFIG = new ParseField("chunking_config", new String[0]);
    public static final ParseField HEADERS = new ParseField("headers", new String[0]);
    public static final ParseField DELAYED_DATA_CHECK_CONFIG = new ParseField("delayed_data_check_config", new String[0]);
    public static final ParseField MAX_EMPTY_SEARCHES = new ParseField("max_empty_searches", new String[0]);
    public static final ParseField INDICES_OPTIONS = new ParseField("indices_options", new String[0]);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = DatafeedConfig.createParser(true);
    public static final ObjectParser<Builder, Void> STRICT_PARSER = DatafeedConfig.createParser(false);
    private final String id;
    private final String jobId;
    private final TimeValue queryDelay;
    private final TimeValue frequency;
    private final List<String> indices;
    private final QueryProvider queryProvider;
    private final AggProvider aggProvider;
    private final List<SearchSourceBuilder.ScriptField> scriptFields;
    private final Integer scrollSize;
    private final ChunkingConfig chunkingConfig;
    private final Map<String, String> headers;
    private final DelayedDataCheckConfig delayedDataCheckConfig;
    private final Integer maxEmptySearches;
    private final IndicesOptions indicesOptions;

    public static void validateAggregations(AggregatorFactories.Builder aggregations) {
        if (aggregations == null) {
            return;
        }
        Collection aggregatorFactories = aggregations.getAggregatorFactories();
        if (aggregatorFactories.isEmpty()) {
            throw ExceptionsHelper.badRequestException("A date_histogram (or histogram) aggregation is required", new Object[0]);
        }
        AggregationBuilder histogramAggregation = ExtractorUtils.getHistogramAggregation(aggregatorFactories);
        Builder.checkNoMoreHistogramAggregations(histogramAggregation.getSubAggregations());
        Builder.checkHistogramAggregationHasChildMaxTimeAgg(histogramAggregation);
        Builder.checkHistogramIntervalIsPositive(histogramAggregation);
    }

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser("datafeed_config", ignoreUnknownFields, Builder::new);
        parser.declareString(Builder::setId, ID);
        parser.declareString((c, s) -> {}, CONFIG_TYPE);
        parser.declareString(Builder::setJobId, Job.ID);
        parser.declareStringArray(Builder::setIndices, INDEXES);
        parser.declareStringArray(Builder::setIndices, INDICES);
        parser.declareString((builder, val) -> builder.setQueryDelay(TimeValue.parseTimeValue((String)val, (String)QUERY_DELAY.getPreferredName())), QUERY_DELAY);
        parser.declareString((builder, val) -> builder.setFrequency(TimeValue.parseTimeValue((String)val, (String)FREQUENCY.getPreferredName())), FREQUENCY);
        parser.declareObject(Builder::setQueryProvider, (p, c) -> QueryProvider.fromXContent(p, ignoreUnknownFields, "Datafeed query is not parsable"), QUERY);
        parser.declareObject((rec$, x$0) -> ((Builder)rec$).setAggregationsSafe(x$0), (p, c) -> AggProvider.fromXContent(p, ignoreUnknownFields), AGGREGATIONS);
        parser.declareObject((rec$, x$0) -> ((Builder)rec$).setAggregationsSafe(x$0), (p, c) -> AggProvider.fromXContent(p, ignoreUnknownFields), AGGS);
        parser.declareObject(Builder::setScriptFields, (p, c) -> {
            ArrayList<SearchSourceBuilder.ScriptField> parsedScriptFields = new ArrayList<SearchSourceBuilder.ScriptField>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                parsedScriptFields.add(new SearchSourceBuilder.ScriptField(p));
            }
            parsedScriptFields.sort(Comparator.comparing(SearchSourceBuilder.ScriptField::fieldName));
            return parsedScriptFields;
        }, SCRIPT_FIELDS);
        parser.declareInt(Builder::setScrollSize, SCROLL_SIZE);
        parser.declareObject(Builder::setChunkingConfig, ignoreUnknownFields ? ChunkingConfig.LENIENT_PARSER : ChunkingConfig.STRICT_PARSER, CHUNKING_CONFIG);
        if (ignoreUnknownFields) {
            parser.declareObject(Builder::setHeaders, (p, c) -> p.mapStrings(), HEADERS);
        }
        parser.declareObject(Builder::setDelayedDataCheckConfig, ignoreUnknownFields ? DelayedDataCheckConfig.LENIENT_PARSER : DelayedDataCheckConfig.STRICT_PARSER, DELAYED_DATA_CHECK_CONFIG);
        parser.declareInt(Builder::setMaxEmptySearches, MAX_EMPTY_SEARCHES);
        parser.declareObject(Builder::setIndicesOptions, (p, c) -> IndicesOptions.fromMap((Map)p.map(), (IndicesOptions)SearchRequest.DEFAULT_INDICES_OPTIONS), INDICES_OPTIONS);
        return parser;
    }

    private DatafeedConfig(String id, String jobId, TimeValue queryDelay, TimeValue frequency, List<String> indices, QueryProvider queryProvider, AggProvider aggProvider, List<SearchSourceBuilder.ScriptField> scriptFields, Integer scrollSize, ChunkingConfig chunkingConfig, Map<String, String> headers, DelayedDataCheckConfig delayedDataCheckConfig, Integer maxEmptySearches, IndicesOptions indicesOptions) {
        this.id = id;
        this.jobId = jobId;
        this.queryDelay = queryDelay;
        this.frequency = frequency;
        this.indices = indices == null ? null : Collections.unmodifiableList(indices);
        this.queryProvider = queryProvider == null ? null : new QueryProvider(queryProvider);
        this.aggProvider = aggProvider == null ? null : new AggProvider(aggProvider);
        this.scriptFields = scriptFields == null ? null : Collections.unmodifiableList(scriptFields);
        this.scrollSize = scrollSize;
        this.chunkingConfig = chunkingConfig;
        this.headers = Collections.unmodifiableMap(headers);
        this.delayedDataCheckConfig = delayedDataCheckConfig;
        this.maxEmptySearches = maxEmptySearches;
        this.indicesOptions = ExceptionsHelper.requireNonNull(indicesOptions, INDICES_OPTIONS);
    }

    public DatafeedConfig(StreamInput in) throws IOException {
        this.id = in.readString();
        this.jobId = in.readString();
        this.queryDelay = in.readOptionalTimeValue();
        this.frequency = in.readOptionalTimeValue();
        this.indices = in.readBoolean() ? Collections.unmodifiableList(in.readStringList()) : null;
        if (in.getVersion().before(Version.V_7_0_0) && in.readBoolean()) {
            in.readStringList();
        }
        this.queryProvider = QueryProvider.fromStream(in);
        this.aggProvider = (AggProvider)in.readOptionalWriteable(AggProvider::fromStream);
        this.scriptFields = in.readBoolean() ? Collections.unmodifiableList(in.readList(SearchSourceBuilder.ScriptField::new)) : null;
        this.scrollSize = in.readOptionalVInt();
        this.chunkingConfig = (ChunkingConfig)in.readOptionalWriteable(ChunkingConfig::new);
        this.headers = in.getVersion().onOrAfter(Version.V_6_2_0) ? Collections.unmodifiableMap(in.readMap(StreamInput::readString, StreamInput::readString)) : Collections.emptyMap();
        this.delayedDataCheckConfig = in.getVersion().onOrAfter(Version.V_6_6_0) ? (DelayedDataCheckConfig)in.readOptionalWriteable(DelayedDataCheckConfig::new) : DelayedDataCheckConfig.defaultDelayedDataCheckConfig();
        this.maxEmptySearches = in.getVersion().onOrAfter(Version.V_7_5_0) ? in.readOptionalVInt() : null;
        this.indicesOptions = in.getVersion().onOrAfter(Version.V_7_7_0) ? IndicesOptions.readIndicesOptions((StreamInput)in) : SearchRequest.DEFAULT_INDICES_OPTIONS;
    }

    public static String documentId(String datafeedId) {
        return TYPE + "-" + datafeedId;
    }

    public String getId() {
        return this.id;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getConfigType() {
        return TYPE;
    }

    public TimeValue getQueryDelay() {
        return this.queryDelay;
    }

    public TimeValue getFrequency() {
        return this.frequency;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public Integer getScrollSize() {
        return this.scrollSize;
    }

    public QueryBuilder getParsedQuery(NamedXContentRegistry namedXContentRegistry) {
        return this.queryProvider == null ? null : this.parseQuery(namedXContentRegistry, new ArrayList<String>());
    }

    private QueryBuilder parseQuery(NamedXContentRegistry namedXContentRegistry, List<String> deprecations) {
        try {
            return this.queryProvider == null || this.queryProvider.getQuery() == null ? null : XContentObjectTransformer.queryBuilderTransformer(namedXContentRegistry).fromMap(this.queryProvider.getQuery(), deprecations);
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof IllegalArgumentException) {
                exception = (Exception)exception.getCause();
            }
            throw ExceptionsHelper.badRequestException("Datafeed query is not parsable", exception, new Object[0]);
        }
    }

    Exception getQueryParsingException() {
        return this.queryProvider == null ? null : this.queryProvider.getParsingException();
    }

    public List<String> getQueryDeprecations(NamedXContentRegistry namedXContentRegistry) {
        ArrayList<String> deprecations = new ArrayList<String>();
        this.parseQuery(namedXContentRegistry, deprecations);
        return deprecations;
    }

    public Map<String, Object> getQuery() {
        return this.queryProvider == null ? null : this.queryProvider.getQuery();
    }

    public AggregatorFactories.Builder getParsedAggregations(NamedXContentRegistry namedXContentRegistry) {
        return this.aggProvider == null ? null : this.parseAggregations(namedXContentRegistry, new ArrayList<String>());
    }

    private AggregatorFactories.Builder parseAggregations(NamedXContentRegistry namedXContentRegistry, List<String> deprecations) {
        try {
            return this.aggProvider == null || this.aggProvider.getAggs() == null ? null : XContentObjectTransformer.aggregatorTransformer(namedXContentRegistry).fromMap(this.aggProvider.getAggs(), deprecations);
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof IllegalArgumentException) {
                exception = (Exception)exception.getCause();
            }
            throw ExceptionsHelper.badRequestException("Datafeed aggregations are not parsable", exception, new Object[0]);
        }
    }

    Exception getAggParsingException() {
        return this.aggProvider == null ? null : this.aggProvider.getParsingException();
    }

    public List<String> getAggDeprecations(NamedXContentRegistry namedXContentRegistry) {
        ArrayList<String> deprecations = new ArrayList<String>();
        this.parseAggregations(namedXContentRegistry, deprecations);
        return deprecations;
    }

    public Map<String, Object> getAggregations() {
        return this.aggProvider == null ? null : this.aggProvider.getAggs();
    }

    public long getHistogramIntervalMillis(NamedXContentRegistry namedXContentRegistry) {
        return ExtractorUtils.getHistogramIntervalMillis(this.getParsedAggregations(namedXContentRegistry));
    }

    public boolean hasAggregations() {
        return this.aggProvider != null && this.aggProvider.getAggs() != null && this.aggProvider.getAggs().size() > 0;
    }

    public List<SearchSourceBuilder.ScriptField> getScriptFields() {
        return this.scriptFields == null ? Collections.emptyList() : this.scriptFields;
    }

    public ChunkingConfig getChunkingConfig() {
        return this.chunkingConfig;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public DelayedDataCheckConfig getDelayedDataCheckConfig() {
        return this.delayedDataCheckConfig;
    }

    public Integer getMaxEmptySearches() {
        return this.maxEmptySearches;
    }

    public IndicesOptions getIndicesOptions() {
        return this.indicesOptions;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.jobId);
        out.writeOptionalTimeValue(this.queryDelay);
        out.writeOptionalTimeValue(this.frequency);
        if (this.indices != null) {
            out.writeBoolean(true);
            out.writeStringCollection(this.indices);
        } else {
            out.writeBoolean(false);
        }
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeBoolean(true);
            out.writeStringCollection(Collections.emptyList());
        }
        this.queryProvider.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.aggProvider);
        if (this.scriptFields != null) {
            out.writeBoolean(true);
            out.writeList(this.scriptFields);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalVInt(this.scrollSize);
        out.writeOptionalWriteable((Writeable)this.chunkingConfig);
        if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeString);
        }
        if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeOptionalWriteable((Writeable)this.delayedDataCheckConfig);
        }
        if (out.getVersion().onOrAfter(Version.V_7_5_0)) {
            out.writeOptionalVInt(this.maxEmptySearches);
        }
        if (out.getVersion().onOrAfter(Version.V_7_7_0)) {
            this.indicesOptions.writeIndicesOptions(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), this.id);
        builder.field(Job.ID.getPreferredName(), this.jobId);
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(CONFIG_TYPE.getPreferredName(), TYPE);
        }
        builder.field(QUERY_DELAY.getPreferredName(), this.queryDelay.getStringRep());
        if (this.frequency != null) {
            builder.field(FREQUENCY.getPreferredName(), this.frequency.getStringRep());
        }
        builder.field(INDICES.getPreferredName(), this.indices);
        builder.field(QUERY.getPreferredName(), this.queryProvider.getQuery());
        if (this.aggProvider != null) {
            builder.field(AGGREGATIONS.getPreferredName(), this.aggProvider.getAggs());
        }
        if (this.scriptFields != null) {
            builder.startObject(SCRIPT_FIELDS.getPreferredName());
            for (SearchSourceBuilder.ScriptField scriptField : this.scriptFields) {
                scriptField.toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.field(SCROLL_SIZE.getPreferredName(), this.scrollSize);
        if (this.chunkingConfig != null) {
            builder.field(CHUNKING_CONFIG.getPreferredName(), (ToXContent)this.chunkingConfig);
        }
        if (!this.headers.isEmpty() && params.paramAsBoolean("for_internal_storage", false)) {
            ClientHelper.assertNoAuthorizationHeader(this.headers);
            builder.field(HEADERS.getPreferredName(), this.headers);
        }
        if (this.delayedDataCheckConfig != null) {
            builder.field(DELAYED_DATA_CHECK_CONFIG.getPreferredName(), (ToXContent)this.delayedDataCheckConfig);
        }
        if (this.maxEmptySearches != null) {
            builder.field(MAX_EMPTY_SEARCHES.getPreferredName(), this.maxEmptySearches);
        }
        builder.startObject(INDICES_OPTIONS.getPreferredName());
        this.indicesOptions.toXContent(builder, params);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DatafeedConfig)) {
            return false;
        }
        DatafeedConfig that = (DatafeedConfig)((Object)other);
        return Objects.equals(this.id, that.id) && Objects.equals(this.jobId, that.jobId) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.queryDelay, that.queryDelay) && Objects.equals(this.indices, that.indices) && Objects.equals(this.queryProvider, that.queryProvider) && Objects.equals(this.scrollSize, that.scrollSize) && Objects.equals(this.aggProvider, that.aggProvider) && Objects.equals(this.scriptFields, that.scriptFields) && Objects.equals(this.chunkingConfig, that.chunkingConfig) && Objects.equals(this.headers, that.headers) && Objects.equals(this.delayedDataCheckConfig, that.delayedDataCheckConfig) && Objects.equals(this.maxEmptySearches, that.maxEmptySearches) && Objects.equals(this.indicesOptions, that.indicesOptions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.jobId, this.frequency, this.queryDelay, this.indices, this.queryProvider, this.scrollSize, this.aggProvider, this.scriptFields, this.chunkingConfig, this.headers, this.delayedDataCheckConfig, this.maxEmptySearches, this.indicesOptions);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public TimeValue defaultFrequency(TimeValue bucketSpan, NamedXContentRegistry xContentRegistry) {
        TimeValue defaultFrequency = this.defaultFrequencyTarget(bucketSpan);
        if (this.hasAggregations()) {
            long targetFrequencyMillis;
            long histogramIntervalMillis = this.getHistogramIntervalMillis(xContentRegistry);
            long defaultFrequencyMillis = histogramIntervalMillis > (targetFrequencyMillis = defaultFrequency.millis()) ? histogramIntervalMillis : targetFrequencyMillis / histogramIntervalMillis * histogramIntervalMillis;
            defaultFrequency = TimeValue.timeValueMillis((long)defaultFrequencyMillis);
        }
        return defaultFrequency;
    }

    private TimeValue defaultFrequencyTarget(TimeValue bucketSpan) {
        long bucketSpanSeconds = bucketSpan.seconds();
        if (bucketSpanSeconds <= 0L) {
            throw new IllegalArgumentException("Bucket span has to be > 0");
        }
        if (bucketSpanSeconds <= 120L) {
            return TimeValue.timeValueSeconds((long)60L);
        }
        if (bucketSpanSeconds <= 1200L) {
            return TimeValue.timeValueSeconds((long)(bucketSpanSeconds / 2L));
        }
        if (bucketSpanSeconds <= 43200L) {
            return TimeValue.timeValueMinutes((long)10L);
        }
        return TimeValue.timeValueHours((long)1L);
    }

    public static class Builder {
        public static final int DEFAULT_AGGREGATION_CHUNKING_BUCKETS = 1000;
        private static final TimeValue MIN_DEFAULT_QUERY_DELAY = TimeValue.timeValueMinutes((long)1L);
        private static final TimeValue MAX_DEFAULT_QUERY_DELAY = TimeValue.timeValueMinutes((long)2L);
        private String id;
        private String jobId;
        private TimeValue queryDelay;
        private TimeValue frequency;
        private List<String> indices = Collections.emptyList();
        private QueryProvider queryProvider = QueryProvider.defaultQuery();
        private AggProvider aggProvider;
        private List<SearchSourceBuilder.ScriptField> scriptFields;
        private Integer scrollSize = 1000;
        private ChunkingConfig chunkingConfig;
        private Map<String, String> headers = Collections.emptyMap();
        private DelayedDataCheckConfig delayedDataCheckConfig = DelayedDataCheckConfig.defaultDelayedDataCheckConfig();
        private Integer maxEmptySearches;
        private IndicesOptions indicesOptions;

        public Builder() {
        }

        public Builder(String id, String jobId) {
            this();
            this.id = ExceptionsHelper.requireNonNull(id, ID.getPreferredName());
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public Builder(DatafeedConfig config) {
            this.id = config.id;
            this.jobId = config.jobId;
            this.queryDelay = config.queryDelay;
            this.frequency = config.frequency;
            this.indices = new ArrayList<String>(config.indices);
            this.queryProvider = config.queryProvider == null ? null : new QueryProvider(config.queryProvider);
            this.aggProvider = config.aggProvider == null ? null : new AggProvider(config.aggProvider);
            this.scriptFields = config.scriptFields == null ? null : new ArrayList(config.scriptFields);
            this.scrollSize = config.scrollSize;
            this.chunkingConfig = config.chunkingConfig;
            this.headers = new HashMap<String, String>(config.headers);
            this.delayedDataCheckConfig = config.getDelayedDataCheckConfig();
            this.maxEmptySearches = config.getMaxEmptySearches();
            this.indicesOptions = config.indicesOptions;
        }

        public Builder setId(String datafeedId) {
            this.id = ExceptionsHelper.requireNonNull(datafeedId, ID.getPreferredName());
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setJobId(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headers = ExceptionsHelper.requireNonNull(headers, HEADERS.getPreferredName());
            return this;
        }

        public Builder setIndices(List<String> indices) {
            this.indices = ExceptionsHelper.requireNonNull(indices, INDICES.getPreferredName());
            return this;
        }

        public Builder setQueryDelay(TimeValue queryDelay) {
            TimeUtils.checkNonNegativeMultiple(queryDelay, TimeUnit.MILLISECONDS, QUERY_DELAY);
            this.queryDelay = queryDelay;
            return this;
        }

        public Builder setFrequency(TimeValue frequency) {
            TimeUtils.checkPositiveMultiple(frequency, TimeUnit.SECONDS, FREQUENCY);
            this.frequency = frequency;
            return this;
        }

        public Builder setQueryProvider(QueryProvider queryProvider) {
            this.queryProvider = ExceptionsHelper.requireNonNull(queryProvider, QUERY.getPreferredName());
            return this;
        }

        public Builder setParsedQuery(QueryBuilder queryBuilder) {
            try {
                this.queryProvider = ExceptionsHelper.requireNonNull(QueryProvider.fromParsedQuery(queryBuilder), QUERY.getPreferredName());
            }
            catch (IOException exception) {
                logger.error("Exception trying to setParsedQuery", (Throwable)exception);
            }
            return this;
        }

        public Builder setParsedAggregations(AggregatorFactories.Builder aggregations) {
            try {
                this.aggProvider = AggProvider.fromParsedAggs(aggregations);
            }
            catch (IOException exception) {
                logger.error("Exception trying to setParsedAggregations", (Throwable)exception);
            }
            return this;
        }

        private Builder setAggregationsSafe(AggProvider aggProvider) {
            if (this.aggProvider != null) {
                throw ExceptionsHelper.badRequestException("Found two aggregation definitions: [aggs] and [aggregations]", new Object[0]);
            }
            this.aggProvider = aggProvider;
            return this;
        }

        public Builder setAggProvider(AggProvider aggProvider) {
            this.aggProvider = aggProvider;
            return this;
        }

        public Builder setScriptFields(List<SearchSourceBuilder.ScriptField> scriptFields) {
            ArrayList<SearchSourceBuilder.ScriptField> sorted = new ArrayList<SearchSourceBuilder.ScriptField>();
            for (SearchSourceBuilder.ScriptField scriptField : scriptFields) {
                sorted.add(scriptField);
            }
            sorted.sort(Comparator.comparing(SearchSourceBuilder.ScriptField::fieldName));
            this.scriptFields = sorted;
            return this;
        }

        public Builder setScrollSize(int scrollSize) {
            if (scrollSize < 0) {
                String msg = Messages.getMessage("Invalid {0} value ''{1}'' in datafeed configuration", SCROLL_SIZE.getPreferredName(), scrollSize);
                throw ExceptionsHelper.badRequestException(msg, new Object[0]);
            }
            this.scrollSize = scrollSize;
            return this;
        }

        public Builder setChunkingConfig(ChunkingConfig chunkingConfig) {
            this.chunkingConfig = chunkingConfig;
            return this;
        }

        public Builder setDelayedDataCheckConfig(DelayedDataCheckConfig delayedDataCheckConfig) {
            this.delayedDataCheckConfig = delayedDataCheckConfig;
            return this;
        }

        public Builder setMaxEmptySearches(int maxEmptySearches) {
            if (maxEmptySearches == -1) {
                this.maxEmptySearches = null;
            } else {
                if (maxEmptySearches <= 0) {
                    String msg = Messages.getMessage("Invalid {0} value ''{1}'' in datafeed configuration", MAX_EMPTY_SEARCHES.getPreferredName(), maxEmptySearches);
                    throw ExceptionsHelper.badRequestException(msg, new Object[0]);
                }
                this.maxEmptySearches = maxEmptySearches;
            }
            return this;
        }

        public Builder setIndicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
            return this;
        }

        public IndicesOptions getIndicesOptions() {
            return this.indicesOptions;
        }

        public DatafeedConfig build() {
            ExceptionsHelper.requireNonNull(this.id, ID.getPreferredName());
            ExceptionsHelper.requireNonNull(this.jobId, Job.ID.getPreferredName());
            if (!MlStrings.isValidId(this.id)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", ID.getPreferredName(), this.id), new Object[0]);
            }
            if (this.indices == null || this.indices.isEmpty() || this.indices.contains(null) || this.indices.contains("")) {
                throw Builder.invalidOptionValue(INDICES.getPreferredName(), this.indices);
            }
            this.validateScriptFields();
            this.setDefaultChunkingConfig();
            this.setDefaultQueryDelay();
            if (this.indicesOptions == null) {
                this.indicesOptions = SearchRequest.DEFAULT_INDICES_OPTIONS;
            }
            return new DatafeedConfig(this.id, this.jobId, this.queryDelay, this.frequency, this.indices, this.queryProvider, this.aggProvider, this.scriptFields, this.scrollSize, this.chunkingConfig, this.headers, this.delayedDataCheckConfig, this.maxEmptySearches, this.indicesOptions);
        }

        void validateScriptFields() {
            if (this.aggProvider == null) {
                return;
            }
            if (this.scriptFields != null && !this.scriptFields.isEmpty()) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("script_fields cannot be used in combination with aggregations"), new Object[0]);
            }
        }

        private static void checkNoMoreHistogramAggregations(Collection<AggregationBuilder> aggregations) {
            for (AggregationBuilder agg : aggregations) {
                if (ExtractorUtils.isHistogram(agg)) {
                    throw ExceptionsHelper.badRequestException("Aggregations can only have 1 date_histogram or histogram aggregation", new Object[0]);
                }
                Builder.checkNoMoreHistogramAggregations(agg.getSubAggregations());
            }
        }

        static void checkHistogramAggregationHasChildMaxTimeAgg(AggregationBuilder histogramAggregation) {
            String timeField = null;
            if (histogramAggregation instanceof ValuesSourceAggregationBuilder) {
                timeField = ((ValuesSourceAggregationBuilder)histogramAggregation).field();
            }
            for (AggregationBuilder agg : histogramAggregation.getSubAggregations()) {
                MaxAggregationBuilder maxAgg;
                if (!(agg instanceof MaxAggregationBuilder) || !(maxAgg = (MaxAggregationBuilder)agg).field().equals(timeField)) continue;
                return;
            }
            throw ExceptionsHelper.badRequestException(Messages.getMessage("Date histogram must have nested max aggregation for time_field [{0}]", timeField), new Object[0]);
        }

        private static void checkHistogramIntervalIsPositive(AggregationBuilder histogramAggregation) {
            long interval = ExtractorUtils.getHistogramIntervalMillis(histogramAggregation);
            if (interval <= 0L) {
                throw ExceptionsHelper.badRequestException("Aggregation interval must be greater than 0", new Object[0]);
            }
        }

        private void setDefaultChunkingConfig() {
            if (this.chunkingConfig == null) {
                if (this.aggProvider == null || this.aggProvider.getParsedAggs() == null) {
                    this.chunkingConfig = ChunkingConfig.newAuto();
                } else {
                    long histogramIntervalMillis = ExtractorUtils.getHistogramIntervalMillis(this.aggProvider.getParsedAggs());
                    if (histogramIntervalMillis <= 0L) {
                        throw ExceptionsHelper.badRequestException("Aggregation interval must be greater than 0", new Object[0]);
                    }
                    this.chunkingConfig = ChunkingConfig.newManual(TimeValue.timeValueMillis((long)(1000L * histogramIntervalMillis)));
                }
            }
        }

        private void setDefaultQueryDelay() {
            if (this.queryDelay == null) {
                Random random = new Random(this.jobId.hashCode());
                long delayMillis = random.longs(MIN_DEFAULT_QUERY_DELAY.millis(), MAX_DEFAULT_QUERY_DELAY.millis()).findFirst().getAsLong();
                this.queryDelay = TimeValue.timeValueMillis((long)delayMillis);
            }
        }

        private static ElasticsearchException invalidOptionValue(String fieldName, Object value) {
            String msg = Messages.getMessage("Invalid {0} value ''{1}'' in datafeed configuration", fieldName, value);
            throw ExceptionsHelper.badRequestException(msg, new Object[0]);
        }
    }
}

