/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public enum DataFrameAnalyticsState implements Writeable
{
    STARTED,
    REINDEXING,
    ANALYZING,
    STOPPING,
    STOPPED,
    FAILED,
    STARTING;


    public static DataFrameAnalyticsState fromString(String name) {
        return DataFrameAnalyticsState.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public static DataFrameAnalyticsState fromStream(StreamInput in) throws IOException {
        return (DataFrameAnalyticsState)in.readEnum(DataFrameAnalyticsState.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        DataFrameAnalyticsState toWrite = this;
        if (out.getVersion().before(Version.V_7_5_0) && toWrite == STARTING) {
            toWrite = STOPPED;
        }
        out.writeEnum((Enum)toWrite);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public boolean isAnyOf(DataFrameAnalyticsState ... candidates) {
        return Arrays.stream(candidates).anyMatch(candidate -> this == candidate);
    }
}

