/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.search.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public final class OpenPointInTimeRequest
extends ActionRequest
implements IndicesRequest.Replaceable {
    private String[] indices;
    private final IndicesOptions indicesOptions;
    private final TimeValue keepAlive;
    @Nullable
    private final String routing;
    @Nullable
    private final String preference;
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.strictExpandOpenAndForbidClosed();

    public OpenPointInTimeRequest(String[] indices, IndicesOptions indicesOptions, TimeValue keepAlive, String routing, String preference) {
        this.indices = Objects.requireNonNull(indices);
        this.indicesOptions = Objects.requireNonNull(indicesOptions);
        this.keepAlive = keepAlive;
        this.routing = routing;
        this.preference = preference;
    }

    public OpenPointInTimeRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
        this.keepAlive = in.readTimeValue();
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeTimeValue(this.keepAlive);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indices.length == 0) {
            validationException = ValidateActions.addValidationError((String)"[index] is not specified", validationException);
        }
        if (this.keepAlive == null) {
            validationException = ValidateActions.addValidationError((String)"[keep_alive] is not specified", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String[] indices() {
        return this.indices;
    }

    public OpenPointInTimeRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public boolean includeDataStreams() {
        return true;
    }

    public TimeValue keepAlive() {
        return this.keepAlive;
    }

    public String routing() {
        return this.routing;
    }

    public String preference() {
        return this.preference;
    }

    public String getDescription() {
        return "open point in time: indices [" + String.join((CharSequence)",", this.indices) + "] keep_alive [" + this.keepAlive + "]";
    }

    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchTask(id, type, action, this::getDescription, parentTaskId, headers);
    }
}

