/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;

public class SecurityFeatureSetUsage
extends XPackFeatureSet.Usage {
    private static final String REALMS_XFIELD = "realms";
    private static final String ROLES_XFIELD = "roles";
    private static final String ROLE_MAPPING_XFIELD = "role_mapping";
    private static final String SSL_XFIELD = "ssl";
    private static final String TOKEN_SERVICE_XFIELD = "token_service";
    private static final String API_KEY_SERVICE_XFIELD = "api_key_service";
    private static final String AUDIT_XFIELD = "audit";
    private static final String IP_FILTER_XFIELD = "ipfilter";
    private static final String ANONYMOUS_XFIELD = "anonymous";
    private static final String FIPS_140_XFIELD = "fips_140";
    private Map<String, Object> realmsUsage;
    private Map<String, Object> rolesStoreUsage;
    private Map<String, Object> sslUsage;
    private Map<String, Object> tokenServiceUsage;
    private Map<String, Object> apiKeyServiceUsage;
    private Map<String, Object> auditUsage;
    private Map<String, Object> ipFilterUsage;
    private Map<String, Object> anonymousUsage;
    private Map<String, Object> roleMappingStoreUsage;
    private Map<String, Object> fips140Usage;

    public SecurityFeatureSetUsage(StreamInput in) throws IOException {
        super(in);
        this.realmsUsage = in.readMap();
        this.rolesStoreUsage = in.readMap();
        this.sslUsage = in.readMap();
        if (in.getVersion().onOrAfter(Version.V_7_2_0)) {
            this.tokenServiceUsage = in.readMap();
            this.apiKeyServiceUsage = in.readMap();
        }
        this.auditUsage = in.readMap();
        this.ipFilterUsage = in.readMap();
        if (in.getVersion().before(Version.V_6_0_0_beta1)) {
            in.readMap();
        }
        this.anonymousUsage = in.readMap();
        this.roleMappingStoreUsage = in.readMap();
        if (in.getVersion().onOrAfter(Version.V_7_5_0)) {
            this.fips140Usage = in.readMap();
        }
    }

    public SecurityFeatureSetUsage(boolean available, boolean enabled, Map<String, Object> realmsUsage, Map<String, Object> rolesStoreUsage, Map<String, Object> roleMappingStoreUsage, Map<String, Object> sslUsage, Map<String, Object> auditUsage, Map<String, Object> ipFilterUsage, Map<String, Object> anonymousUsage, Map<String, Object> tokenServiceUsage, Map<String, Object> apiKeyServiceUsage, Map<String, Object> fips140Usage) {
        super("security", available, enabled);
        this.realmsUsage = realmsUsage;
        this.rolesStoreUsage = rolesStoreUsage;
        this.roleMappingStoreUsage = roleMappingStoreUsage;
        this.sslUsage = sslUsage;
        this.tokenServiceUsage = tokenServiceUsage;
        this.apiKeyServiceUsage = apiKeyServiceUsage;
        this.auditUsage = auditUsage;
        this.ipFilterUsage = ipFilterUsage;
        this.anonymousUsage = anonymousUsage;
        this.fips140Usage = fips140Usage;
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_7_0_0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.realmsUsage);
        out.writeMap(this.rolesStoreUsage);
        out.writeMap(this.sslUsage);
        if (out.getVersion().onOrAfter(Version.V_7_2_0)) {
            out.writeMap(this.tokenServiceUsage);
            out.writeMap(this.apiKeyServiceUsage);
        }
        out.writeMap(this.auditUsage);
        out.writeMap(this.ipFilterUsage);
        if (out.getVersion().before(Version.V_6_0_0_beta1)) {
            out.writeMap(Collections.emptyMap());
        }
        out.writeMap(this.anonymousUsage);
        out.writeMap(this.roleMappingStoreUsage);
        if (out.getVersion().onOrAfter(Version.V_7_5_0)) {
            out.writeMap(this.fips140Usage);
        }
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        if (this.enabled) {
            builder.field(REALMS_XFIELD, this.realmsUsage);
            builder.field(ROLES_XFIELD, this.rolesStoreUsage);
            builder.field(ROLE_MAPPING_XFIELD, this.roleMappingStoreUsage);
            builder.field(SSL_XFIELD, this.sslUsage);
            builder.field(TOKEN_SERVICE_XFIELD, this.tokenServiceUsage);
            builder.field(API_KEY_SERVICE_XFIELD, this.apiKeyServiceUsage);
            builder.field(AUDIT_XFIELD, this.auditUsage);
            builder.field(IP_FILTER_XFIELD, this.ipFilterUsage);
            builder.field(ANONYMOUS_XFIELD, this.anonymousUsage);
            builder.field(FIPS_140_XFIELD, this.fips140Usage);
        } else if (!this.sslUsage.isEmpty()) {
            builder.field(SSL_XFIELD, this.sslUsage);
        }
    }

    public Map<String, Object> getRealmsUsage() {
        return Collections.unmodifiableMap(this.realmsUsage);
    }
}

