/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class InvalidateApiKeyRequest
extends ActionRequest {
    private final String realmName;
    private final String userName;
    private final String[] ids;
    private final String name;
    private final boolean ownedByAuthenticatedUser;

    public InvalidateApiKeyRequest() {
        this(null, null, null, null, false, null);
    }

    public InvalidateApiKeyRequest(StreamInput in) throws IOException {
        super(in);
        this.realmName = in.readOptionalString();
        this.userName = in.readOptionalString();
        if (in.getVersion().onOrAfter(Version.V_7_10_0)) {
            this.ids = in.readOptionalStringArray();
        } else {
            String[] stringArray;
            String id = in.readOptionalString();
            if (!Strings.hasText((String)id)) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = id;
            }
            this.ids = stringArray;
        }
        this.name = in.readOptionalString();
        this.ownedByAuthenticatedUser = in.getVersion().onOrAfter(Version.V_7_4_0) ? in.readOptionalBoolean() : false;
    }

    public InvalidateApiKeyRequest(@Nullable String realmName, @Nullable String userName, @Nullable String id, @Nullable String name, boolean ownedByAuthenticatedUser) {
        this(realmName, userName, id, name, ownedByAuthenticatedUser, null);
    }

    public InvalidateApiKeyRequest(@Nullable String realmName, @Nullable String userName, @Nullable String id, @Nullable String name, boolean ownedByAuthenticatedUser, @Nullable String[] ids) {
        if (id != null && ids != null) {
            throw new IllegalArgumentException("Must use either [id] or [ids], not both at the same time");
        }
        this.realmName = realmName;
        this.userName = userName;
        this.ids = id != null ? new String[]{id} : ids;
        this.name = name;
        this.ownedByAuthenticatedUser = ownedByAuthenticatedUser;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String[] getIds() {
        return this.ids;
    }

    public String getName() {
        return this.name;
    }

    public boolean ownedByAuthenticatedUser() {
        return this.ownedByAuthenticatedUser;
    }

    public static InvalidateApiKeyRequest usingRealmName(String realmName) {
        return new InvalidateApiKeyRequest(realmName, null, null, null, false);
    }

    public static InvalidateApiKeyRequest usingUserName(String userName) {
        return new InvalidateApiKeyRequest(null, userName, null, null, false);
    }

    public static InvalidateApiKeyRequest usingRealmAndUserName(String realmName, String userName) {
        return new InvalidateApiKeyRequest(realmName, userName, null, null, false);
    }

    public static InvalidateApiKeyRequest usingApiKeyId(String id, boolean ownedByAuthenticatedUser) {
        return new InvalidateApiKeyRequest(null, null, id, null, ownedByAuthenticatedUser);
    }

    public static InvalidateApiKeyRequest usingApiKeyName(String name, boolean ownedByAuthenticatedUser) {
        return new InvalidateApiKeyRequest(null, null, null, name, ownedByAuthenticatedUser);
    }

    public static InvalidateApiKeyRequest forOwnedApiKeys() {
        return new InvalidateApiKeyRequest(null, null, null, null, true);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.ids != null) {
            if (this.ids.length == 0) {
                validationException = ValidateActions.addValidationError((String)"Field [ids] cannot be an empty array", validationException);
            } else {
                int[] idxOfBlankIds = IntStream.range(0, this.ids.length).filter(i -> !Strings.hasText((String)this.ids[i])).toArray();
                if (idxOfBlankIds.length > 0) {
                    validationException = ValidateActions.addValidationError((String)("Field [ids] must not contain blank id, but got blank " + (idxOfBlankIds.length == 1 ? "id" : "ids") + " at index " + (idxOfBlankIds.length == 1 ? "position" : "positions") + ": " + Arrays.toString(idxOfBlankIds)), (ActionRequestValidationException)validationException);
                }
            }
        }
        if (!(Strings.hasText((String)this.realmName) || Strings.hasText((String)this.userName) || this.ids != null || Strings.hasText((String)this.name) || this.ownedByAuthenticatedUser)) {
            validationException = ValidateActions.addValidationError((String)"One of [api key id(s), api key name, username, realm name] must be specified if [owner] flag is false", (ActionRequestValidationException)validationException);
        }
        if ((this.ids != null || Strings.hasText((String)this.name)) && (Strings.hasText((String)this.realmName) || Strings.hasText((String)this.userName))) {
            validationException = ValidateActions.addValidationError((String)"username or realm name must not be specified when the api key id(s) or api key name are specified", (ActionRequestValidationException)validationException);
        }
        if (this.ownedByAuthenticatedUser && (Strings.hasText((String)this.realmName) || Strings.hasText((String)this.userName))) {
            validationException = ValidateActions.addValidationError((String)"neither username nor realm-name may be specified when invalidating owned API keys", (ActionRequestValidationException)validationException);
        }
        if (this.ids != null && Strings.hasText((String)this.name)) {
            validationException = ValidateActions.addValidationError((String)"only one of [api key id(s), api key name] can be specified", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.realmName);
        out.writeOptionalString(this.userName);
        if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
            out.writeOptionalStringArray(this.ids);
        } else if (this.ids != null) {
            if (this.ids.length != 1) throw new IllegalArgumentException("a request with multi-valued field [ids] cannot be sent to an older version");
            out.writeOptionalString(this.ids[0]);
        } else {
            out.writeOptionalString(null);
        }
        out.writeOptionalString(this.name);
        if (!out.getVersion().onOrAfter(Version.V_7_4_0)) return;
        out.writeOptionalBoolean(Boolean.valueOf(this.ownedByAuthenticatedUser));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        InvalidateApiKeyRequest that = (InvalidateApiKeyRequest)((Object)o);
        return this.ownedByAuthenticatedUser == that.ownedByAuthenticatedUser && Objects.equals(this.realmName, that.realmName) && Objects.equals(this.userName, that.userName) && Arrays.equals(this.ids, that.ids) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.realmName, this.userName, this.ids, this.name, this.ownedByAuthenticatedUser);
    }
}

