/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.saml;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class SamlPrepareAuthenticationRequest
extends ActionRequest {
    @Nullable
    private String realmName;
    @Nullable
    private String assertionConsumerServiceURL;
    @Nullable
    private String relayState;

    public SamlPrepareAuthenticationRequest(StreamInput in) throws IOException {
        super(in);
        this.realmName = in.readOptionalString();
        this.assertionConsumerServiceURL = in.readOptionalString();
        if (in.getVersion().onOrAfter(Version.V_7_5_0)) {
            this.relayState = in.readOptionalString();
        }
    }

    public SamlPrepareAuthenticationRequest() {
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public String getAssertionConsumerServiceURL() {
        return this.assertionConsumerServiceURL;
    }

    public void setAssertionConsumerServiceURL(String assertionConsumerServiceURL) {
        this.assertionConsumerServiceURL = assertionConsumerServiceURL;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{realmName=" + this.realmName + ", assertionConsumerServiceURL=" + this.assertionConsumerServiceURL + ", relayState=" + this.relayState + '}';
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.realmName);
        out.writeOptionalString(this.assertionConsumerServiceURL);
        if (out.getVersion().onOrAfter(Version.V_7_5_0)) {
            out.writeOptionalString(this.relayState);
        }
    }
}

