/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.set.Sets;

public final class Automatons {
    static final Setting<Integer> MAX_DETERMINIZED_STATES_SETTING = Setting.intSetting((String)"xpack.security.automata.max_determinized_states", (int)100000, (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<Boolean> CACHE_ENABLED = Setting.boolSetting((String)"xpack.security.automata.cache.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<Integer> CACHE_SIZE = Setting.intSetting((String)"xpack.security.automata.cache.size", (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<TimeValue> CACHE_TTL = Setting.timeSetting((String)"xpack.security.automata.cache.ttl", (TimeValue)TimeValue.timeValueHours((long)48L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Automaton EMPTY = Automata.makeEmpty();
    public static final Automaton MATCH_ALL = Automata.makeAnyString();
    private static int maxDeterminizedStates = 100000;
    private static Cache<Object, Automaton> cache = Automatons.buildCache(Settings.EMPTY);
    static final char WILDCARD_STRING = '*';
    static final char WILDCARD_CHAR = '?';
    static final char WILDCARD_ESCAPE = '\\';

    private Automatons() {
    }

    public static Automaton patterns(String ... patterns) {
        return Automatons.patterns(Arrays.asList(patterns));
    }

    public static Automaton patterns(Collection<String> patterns) {
        if (patterns.isEmpty()) {
            return EMPTY;
        }
        if (cache == null) {
            return Automatons.buildAutomaton(patterns);
        }
        try {
            return (Automaton)cache.computeIfAbsent((Object)Sets.newHashSet(patterns), ignore -> Automatons.buildAutomaton(patterns));
        }
        catch (ExecutionException e) {
            throw Automatons.unwrapCacheException(e);
        }
    }

    private static Automaton buildAutomaton(Collection<String> patterns) {
        ArrayList<Automaton> automata = new ArrayList<Automaton>(patterns.size());
        for (String pattern : patterns) {
            Automaton patternAutomaton = Automatons.pattern(pattern);
            automata.add(patternAutomaton);
        }
        return Automatons.unionAndMinimize(automata);
    }

    static Automaton pattern(String pattern) {
        if (cache == null) {
            return Automatons.buildAutomaton(pattern);
        }
        try {
            return (Automaton)cache.computeIfAbsent((Object)pattern, ignore -> Automatons.buildAutomaton(pattern));
        }
        catch (ExecutionException e) {
            throw Automatons.unwrapCacheException(e);
        }
    }

    public static boolean isLuceneRegex(String str) {
        return str.length() > 1 && str.charAt(0) == '/' && str.charAt(str.length() - 1) == '/';
    }

    private static Automaton buildAutomaton(String pattern) {
        if (pattern.startsWith("/")) {
            if (pattern.length() == 1 || !pattern.endsWith("/")) {
                throw new IllegalArgumentException("invalid pattern [" + pattern + "]. patterns starting with '/' indicate regular expression pattern and therefore must also end with '/'. other patterns (those that do not start with '/') will be treated as simple wildcard patterns");
            }
            String regex = pattern.substring(1, pattern.length() - 1);
            return new RegExp(regex).toAutomaton();
        }
        if (pattern.equals("*")) {
            return MATCH_ALL;
        }
        return Automatons.wildcard(pattern);
    }

    private static RuntimeException unwrapCacheException(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        return new RuntimeException(cause);
    }

    static Automaton wildcard(String text) {
        int length;
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        block5: for (int i = 0; i < text.length(); i += length) {
            char c = text.charAt(i);
            length = 1;
            switch (c) {
                case '*': {
                    automata.add(Automata.makeAnyString());
                    continue block5;
                }
                case '?': {
                    automata.add(Automata.makeAnyChar());
                    continue block5;
                }
                case '\\': {
                    if (i + length < text.length()) {
                        char nextChar = text.charAt(i + length);
                        ++length;
                        automata.add(Automata.makeChar((int)nextChar));
                        continue block5;
                    }
                }
                default: {
                    automata.add(Automata.makeChar((int)c));
                }
            }
        }
        return Operations.concatenate(automata);
    }

    public static Automaton unionAndMinimize(Collection<Automaton> automata) {
        Automaton res = Operations.union(automata);
        return MinimizationOperations.minimize((Automaton)res, (int)maxDeterminizedStates);
    }

    public static Automaton minusAndMinimize(Automaton a1, Automaton a2) {
        Automaton res = Operations.minus((Automaton)a1, (Automaton)a2, (int)maxDeterminizedStates);
        return MinimizationOperations.minimize((Automaton)res, (int)maxDeterminizedStates);
    }

    public static Automaton intersectAndMinimize(Automaton a1, Automaton a2) {
        Automaton res = Operations.intersection((Automaton)a1, (Automaton)a2);
        return MinimizationOperations.minimize((Automaton)res, (int)maxDeterminizedStates);
    }

    public static Predicate<String> predicate(String ... patterns) {
        return Automatons.predicate(Arrays.asList(patterns));
    }

    public static Predicate<String> predicate(Collection<String> patterns) {
        return Automatons.predicate(Automatons.patterns(patterns), Strings.collectionToDelimitedString(patterns, (String)"|"));
    }

    public static Predicate<String> predicate(Automaton automaton) {
        return Automatons.predicate(automaton, "Predicate for " + automaton);
    }

    public static void updateConfiguration(Settings settings) {
        maxDeterminizedStates = (Integer)MAX_DETERMINIZED_STATES_SETTING.get(settings);
        cache = Automatons.buildCache(settings);
    }

    private static Cache<Object, Automaton> buildCache(Settings settings) {
        if (!((Boolean)CACHE_ENABLED.get(settings)).booleanValue()) {
            return null;
        }
        return CacheBuilder.builder().setExpireAfterAccess((TimeValue)CACHE_TTL.get(settings)).setMaximumWeight((long)((Integer)CACHE_SIZE.get(settings)).intValue()).build();
    }

    static int getMaxDeterminizedStates() {
        return maxDeterminizedStates;
    }

    private static Predicate<String> predicate(Automaton automaton, final String toString) {
        final CharacterRunAutomaton runAutomaton = new CharacterRunAutomaton(automaton, maxDeterminizedStates);
        return new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return runAutomaton.run(s);
            }

            public String toString() {
                return toString;
            }
        };
    }

    public static void addSettings(List<Setting<?>> settingsList) {
        settingsList.add(MAX_DETERMINIZED_STATES_SETTING);
        settingsList.add(CACHE_ENABLED);
        settingsList.add(CACHE_SIZE);
        settingsList.add(CACHE_TTL);
    }
}

