/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.support;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.elasticsearch.SpecialPermission;

public class RestorableContextClassLoader
implements AutoCloseable {
    private final Thread thread;
    private ClassLoader restore;

    public RestorableContextClassLoader(Class<?> fromClass) throws PrivilegedActionException {
        this(Thread.currentThread(), fromClass.getClassLoader());
    }

    public RestorableContextClassLoader(Thread thread, ClassLoader setClassLoader) throws PrivilegedActionException {
        this.thread = thread;
        SpecialPermission.check();
        AccessController.doPrivileged(() -> {
            this.restore = thread.getContextClassLoader();
            thread.setContextClassLoader(setClassLoader);
            return null;
        });
    }

    @Override
    public void close() throws PrivilegedActionException {
        SpecialPermission.check();
        AccessController.doPrivileged(() -> {
            this.thread.setContextClassLoader(this.restore);
            return null;
        });
    }
}

