/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.slm.history;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicy;

public class SnapshotHistoryItem
implements Writeable,
ToXContentObject {
    static final ParseField TIMESTAMP = new ParseField("@timestamp", new String[0]);
    static final ParseField POLICY_ID = new ParseField("policy", new String[0]);
    static final ParseField REPOSITORY = new ParseField("repository", new String[0]);
    static final ParseField SNAPSHOT_NAME = new ParseField("snapshot_name", new String[0]);
    static final ParseField OPERATION = new ParseField("operation", new String[0]);
    static final ParseField SUCCESS = new ParseField("success", new String[0]);
    public static final String CREATE_OPERATION = "CREATE";
    public static final String DELETE_OPERATION = "DELETE";
    protected final long timestamp;
    protected final String policyId;
    protected final String repository;
    protected final String snapshotName;
    protected final String operation;
    protected final boolean success;
    private final Map<String, Object> snapshotConfiguration;
    @Nullable
    private final String errorDetails;
    static final ParseField SNAPSHOT_CONFIG = new ParseField("configuration", new String[0]);
    static final ParseField ERROR_DETAILS = new ParseField("error_details", new String[0]);
    private static final ConstructingObjectParser<SnapshotHistoryItem, String> PARSER = new ConstructingObjectParser("snapshot_lifecycle_history_item", true, (a, id) -> {
        long timestamp = (Long)a[0];
        String policyId = (String)a[1];
        String repository = (String)a[2];
        String snapshotName = (String)a[3];
        String operation = (String)a[4];
        boolean success = (Boolean)a[5];
        Map snapshotConfiguration = (Map)a[6];
        String errorDetails = (String)a[7];
        return new SnapshotHistoryItem(timestamp, policyId, repository, snapshotName, operation, success, snapshotConfiguration, errorDetails);
    });

    public static SnapshotHistoryItem parse(XContentParser parser, String name) {
        return (SnapshotHistoryItem)PARSER.apply(parser, (Object)name);
    }

    SnapshotHistoryItem(long timestamp, String policyId, String repository, String snapshotName, String operation, boolean success, Map<String, Object> snapshotConfiguration, String errorDetails) {
        this.timestamp = timestamp;
        this.policyId = Objects.requireNonNull(policyId);
        this.repository = Objects.requireNonNull(repository);
        this.snapshotName = Objects.requireNonNull(snapshotName);
        this.operation = Objects.requireNonNull(operation);
        this.success = success;
        this.snapshotConfiguration = snapshotConfiguration;
        this.errorDetails = errorDetails;
    }

    public static SnapshotHistoryItem creationSuccessRecord(long timestamp, SnapshotLifecyclePolicy policy, String snapshotName) {
        return new SnapshotHistoryItem(timestamp, policy.getId(), policy.getRepository(), snapshotName, CREATE_OPERATION, true, policy.getConfig(), null);
    }

    public static SnapshotHistoryItem creationFailureRecord(long timeStamp, SnapshotLifecyclePolicy policy, String snapshotName, Exception exception) throws IOException {
        String exceptionString = SnapshotHistoryItem.exceptionToString(exception);
        return new SnapshotHistoryItem(timeStamp, policy.getId(), policy.getRepository(), snapshotName, CREATE_OPERATION, false, policy.getConfig(), exceptionString);
    }

    public static SnapshotHistoryItem deletionSuccessRecord(long timestamp, String snapshotName, String policyId, String repository) {
        return new SnapshotHistoryItem(timestamp, policyId, repository, snapshotName, DELETE_OPERATION, true, null, null);
    }

    public static SnapshotHistoryItem deletionFailureRecord(long timestamp, String snapshotName, String policyId, String repository, Exception exception) throws IOException {
        String exceptionString = SnapshotHistoryItem.exceptionToString(exception);
        return new SnapshotHistoryItem(timestamp, policyId, repository, snapshotName, DELETE_OPERATION, false, null, exceptionString);
    }

    public SnapshotHistoryItem(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.policyId = in.readString();
        this.repository = in.readString();
        this.snapshotName = in.readString();
        this.operation = in.readString();
        this.success = in.readBoolean();
        this.snapshotConfiguration = in.readMap();
        this.errorDetails = in.readOptionalString();
    }

    public Map<String, Object> getSnapshotConfiguration() {
        return this.snapshotConfiguration;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public String getOperation() {
        return this.operation;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        out.writeString(this.policyId);
        out.writeString(this.repository);
        out.writeString(this.snapshotName);
        out.writeString(this.operation);
        out.writeBoolean(this.success);
        out.writeMap(this.snapshotConfiguration);
        out.writeOptionalString(this.errorDetails);
    }

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.timeField(TIMESTAMP.getPreferredName(), "timestamp_string", this.timestamp);
        builder.field(POLICY_ID.getPreferredName(), this.policyId);
        builder.field(REPOSITORY.getPreferredName(), this.repository);
        builder.field(SNAPSHOT_NAME.getPreferredName(), this.snapshotName);
        builder.field(OPERATION.getPreferredName(), this.operation);
        builder.field(SUCCESS.getPreferredName(), this.success);
        builder.field(SNAPSHOT_CONFIG.getPreferredName(), this.snapshotConfiguration);
        builder.field(ERROR_DETAILS.getPreferredName(), this.errorDetails);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this == o) {
            bl = true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            bl = false;
        }
        SnapshotHistoryItem that1 = (SnapshotHistoryItem)o;
        boolean bl2 = result = this.isSuccess() == that1.isSuccess() && this.timestamp == that1.getTimestamp() && Objects.equals(this.getPolicyId(), that1.getPolicyId()) && Objects.equals(this.getRepository(), that1.getRepository()) && Objects.equals(this.getSnapshotName(), that1.getSnapshotName()) && Objects.equals(this.getOperation(), that1.getOperation());
        if (!result) {
            return false;
        }
        SnapshotHistoryItem that = (SnapshotHistoryItem)o;
        return Objects.equals(this.getSnapshotConfiguration(), that.getSnapshotConfiguration()) && Objects.equals(this.getErrorDetails(), that.getErrorDetails());
    }

    public int hashCode() {
        return Objects.hash(this.getTimestamp(), this.getPolicyId(), this.getRepository(), this.getSnapshotName(), this.getOperation(), this.isSuccess(), this.getSnapshotConfiguration(), this.getErrorDetails());
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    private static String exceptionToString(Exception exception) throws IOException {
        String exceptionString;
        ToXContent.MapParams stacktraceParams = new ToXContent.MapParams(Collections.singletonMap("rest.exception.stacktrace.skip", "false"));
        try (XContentBuilder causeXContentBuilder = JsonXContent.contentBuilder();){
            causeXContentBuilder.startObject();
            ElasticsearchException.generateThrowableXContent((XContentBuilder)causeXContentBuilder, (ToXContent.Params)stacktraceParams, (Throwable)exception);
            causeXContentBuilder.endObject();
            exceptionString = BytesReference.bytes((XContentBuilder)causeXContentBuilder).utf8ToString();
        }
        return exceptionString;
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), TIMESTAMP);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), POLICY_ID);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), REPOSITORY);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SNAPSHOT_NAME);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), OPERATION);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), SUCCESS);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), SNAPSHOT_CONFIG);
        PARSER.declareStringOrNull(ConstructingObjectParser.constructorArg(), ERROR_DETAILS);
    }
}

