/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.sql.SqlFeatureSetUsage;
import org.elasticsearch.xpack.core.watcher.common.stats.Counters;
import org.elasticsearch.xpack.sql.plugin.SqlStatsAction;
import org.elasticsearch.xpack.sql.plugin.SqlStatsRequest;
import org.elasticsearch.xpack.sql.plugin.SqlStatsResponse;

public class SqlFeatureSet
implements XPackFeatureSet {
    private final XPackLicenseState licenseState;
    private final Client client;

    @Inject
    public SqlFeatureSet(@Nullable XPackLicenseState licenseState, Client client) {
        this.licenseState = licenseState;
        this.client = client;
    }

    public String name() {
        return "sql";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isAllowed(XPackLicenseState.Feature.SQL);
    }

    public boolean enabled() {
        return true;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        SqlStatsRequest request = new SqlStatsRequest();
        request.includeStats(true);
        this.client.execute((ActionType)SqlStatsAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(r -> {
            List countersPerNode = r.getNodes().stream().map(SqlStatsResponse.NodeStatsResponse::getStats).filter(Objects::nonNull).collect(Collectors.toList());
            Counters mergedCounters = Counters.merge(countersPerNode);
            listener.onResponse((Object)new SqlFeatureSetUsage(this.available(), mergedCounters.toNestedMap()));
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

