/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.Filters;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.ql.execution.search.FieldExtraction;
import org.elasticsearch.xpack.ql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.ql.execution.search.extractor.ComputingExtractor;
import org.elasticsearch.xpack.ql.execution.search.extractor.ConstantExtractor;
import org.elasticsearch.xpack.ql.execution.search.extractor.HitExtractor;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.AggExtractorInput;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.AggPathInput;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.HitExtractorInput;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.ReferenceInput;
import org.elasticsearch.xpack.ql.index.IndexResolver;
import org.elasticsearch.xpack.ql.type.Schema;
import org.elasticsearch.xpack.ql.util.StringUtils;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.execution.PlanExecutor;
import org.elasticsearch.xpack.sql.execution.search.CompositeAggCursor;
import org.elasticsearch.xpack.sql.execution.search.CompositeAggRowSet;
import org.elasticsearch.xpack.sql.execution.search.PivotCursor;
import org.elasticsearch.xpack.sql.execution.search.PivotRowSet;
import org.elasticsearch.xpack.sql.execution.search.ResultRowSet;
import org.elasticsearch.xpack.sql.execution.search.SchemaCompositeAggRowSet;
import org.elasticsearch.xpack.sql.execution.search.SchemaSearchHitRowSet;
import org.elasticsearch.xpack.sql.execution.search.ScrollCursor;
import org.elasticsearch.xpack.sql.execution.search.SourceGenerator;
import org.elasticsearch.xpack.sql.execution.search.extractor.CompositeKeyExtractor;
import org.elasticsearch.xpack.sql.execution.search.extractor.FieldHitExtractor;
import org.elasticsearch.xpack.sql.execution.search.extractor.MetricAggExtractor;
import org.elasticsearch.xpack.sql.execution.search.extractor.PivotExtractor;
import org.elasticsearch.xpack.sql.execution.search.extractor.TopHitsAggExtractor;
import org.elasticsearch.xpack.sql.planner.PlanningException;
import org.elasticsearch.xpack.sql.querydsl.container.ComputedRef;
import org.elasticsearch.xpack.sql.querydsl.container.GlobalCountRef;
import org.elasticsearch.xpack.sql.querydsl.container.GroupByRef;
import org.elasticsearch.xpack.sql.querydsl.container.MetricAggRef;
import org.elasticsearch.xpack.sql.querydsl.container.PivotColumnRef;
import org.elasticsearch.xpack.sql.querydsl.container.QueryContainer;
import org.elasticsearch.xpack.sql.querydsl.container.ScriptFieldRef;
import org.elasticsearch.xpack.sql.querydsl.container.SearchHitFieldRef;
import org.elasticsearch.xpack.sql.querydsl.container.TopHitsAggRef;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.ListCursor;
import org.elasticsearch.xpack.sql.session.RowSet;
import org.elasticsearch.xpack.sql.session.Rows;
import org.elasticsearch.xpack.sql.session.SchemaRowSet;
import org.elasticsearch.xpack.sql.session.SqlConfiguration;
import org.elasticsearch.xpack.sql.session.SqlSession;

public class Querier {
    private static final Logger log = LogManager.getLogger(Querier.class);
    private final PlanExecutor planExecutor;
    private final SqlConfiguration cfg;
    private final TimeValue keepAlive;
    private final TimeValue timeout;
    private final int size;
    private final Client client;
    @Nullable
    private final QueryBuilder filter;

    public Querier(SqlSession sqlSession) {
        this.planExecutor = sqlSession.planExecutor();
        this.client = sqlSession.client();
        this.cfg = sqlSession.configuration();
        this.keepAlive = this.cfg.requestTimeout();
        this.timeout = this.cfg.pageTimeout();
        this.filter = this.cfg.filter();
        this.size = this.cfg.pageSize();
    }

    public void query(List<Attribute> output, QueryContainer query, String index, ActionListener<Cursor.Page> listener) {
        SearchSourceBuilder sourceBuilder = SourceGenerator.sourceBuilder(query, this.filter, this.size);
        if (this.timeout.getSeconds() > 0L) {
            sourceBuilder.timeout(this.timeout);
        }
        if (log.isTraceEnabled()) {
            log.trace("About to execute query {} on {}", (Object)StringUtils.toString((SearchSourceBuilder)sourceBuilder), (Object)index);
        }
        SearchRequest search = Querier.prepareRequest(this.client, sourceBuilder, this.timeout, query.shouldIncludeFrozen(), Strings.commaDelimitedListToStringArray((String)index));
        List<Tuple<Integer, Comparator>> sortingColumns = query.sortingColumns();
        listener = sortingColumns.isEmpty() ? listener : new LocalAggregationSorterListener(listener, sortingColumns, query.limit());
        BaseActionListener l = null;
        if (query.isAggsOnly()) {
            l = query.aggs().useImplicitGroupBy() ? new ImplicitGroupActionListener(listener, this.client, this.cfg, output, query, search) : new CompositeActionListener(listener, this.client, this.cfg, output, query, search);
        } else {
            search.scroll(this.keepAlive);
            l = new ScrollActionListener(listener, this.client, this.cfg, output, query);
        }
        this.client.search(search, (ActionListener)l);
    }

    public static SearchRequest prepareRequest(Client client, SearchSourceBuilder source, TimeValue timeout, boolean includeFrozen, String ... indices) {
        return (SearchRequest)client.prepareSearch(indices).setTrackTotalHits(true).setAllowPartialSearchResults(false).setSource(source).setTimeout(timeout).setIndicesOptions(includeFrozen ? IndexResolver.FIELD_CAPS_FROZEN_INDICES_OPTIONS : IndexResolver.FIELD_CAPS_INDICES_OPTIONS).request();
    }

    protected static void logSearchResponse(SearchResponse response, Logger logger) {
        List aggs = Collections.emptyList();
        if (response.getAggregations() != null) {
            aggs = response.getAggregations().asList();
        }
        StringBuilder aggsNames = new StringBuilder();
        for (int i = 0; i < aggs.size(); ++i) {
            aggsNames.append(((Aggregation)aggs.get(i)).getName() + (i + 1 == aggs.size() ? "" : ", "));
        }
        logger.trace("Got search response [hits {} {}, {} aggregations: [{}], {} failed shards, {} skipped shards, {} successful shards, {} total shards, took {}, timed out [{}]]", (Object)response.getHits().getTotalHits().relation.toString(), (Object)response.getHits().getTotalHits().value, (Object)aggs.size(), (Object)aggsNames, (Object)response.getFailedShards(), (Object)response.getSkippedShards(), (Object)response.getSuccessfulShards(), (Object)response.getTotalShards(), (Object)response.getTook(), (Object)response.isTimedOut());
    }

    static class AggSortingQueue
    extends PriorityQueue<Tuple<List<?>, Integer>> {
        private List<Tuple<Integer, Comparator>> sortingColumns;

        AggSortingQueue(int maxSize, List<Tuple<Integer, Comparator>> sortingColumns) {
            super(maxSize);
            this.sortingColumns = sortingColumns;
        }

        protected boolean lessThan(Tuple<List<?>, Integer> l, Tuple<List<?>, Integer> r) {
            for (Tuple<Integer, Comparator> tuple : this.sortingColumns) {
                int columnIdx = (Integer)tuple.v1();
                Comparator comparator = (Comparator)tuple.v2();
                Object vl = ((List)l.v1()).get(columnIdx);
                Object vr = ((List)r.v1()).get(columnIdx);
                if (comparator != null) {
                    int result = comparator.compare(vl, vr);
                    if (result == 0) continue;
                    return result > 0;
                }
                if (Objects.equals(vl, vr)) continue;
                return ((Integer)l.v2()).compareTo((Integer)r.v2()) > 0;
            }
            return ((Integer)l.v2()).compareTo((Integer)r.v2()) > 0;
        }

        List<List<?>> asList() {
            Tuple pop;
            ArrayList list = new ArrayList(super.size());
            while ((pop = (Tuple)this.pop()) != null) {
                list.add(0, (List)pop.v1());
            }
            return list;
        }
    }

    static abstract class BaseActionListener
    implements ActionListener<SearchResponse> {
        final ActionListener<Cursor.Page> listener;
        final Client client;
        final SqlConfiguration cfg;
        final TimeValue keepAlive;
        final Schema schema;

        BaseActionListener(ActionListener<Cursor.Page> listener, Client client, SqlConfiguration cfg, List<Attribute> output) {
            this.listener = listener;
            this.client = client;
            this.cfg = cfg;
            this.keepAlive = cfg.requestTimeout();
            this.schema = Rows.schema(output);
        }

        public void onResponse(SearchResponse response) {
            try {
                Object[] failure = response.getShardFailures();
                if (!CollectionUtils.isEmpty((Object[])failure)) {
                    this.cleanup(response, (Exception)((Object)new SqlIllegalArgumentException(failure[0].reason(), failure[0].getCause())));
                } else {
                    this.handleResponse(response, (ActionListener<Cursor.Page>)ActionListener.wrap(arg_0 -> this.listener.onResponse(arg_0), e -> this.cleanup(response, (Exception)e)));
                }
            }
            catch (Exception ex) {
                this.cleanup(response, ex);
            }
        }

        protected abstract void handleResponse(SearchResponse var1, ActionListener<Cursor.Page> var2);

        protected final void cleanup(SearchResponse response, Exception ex) {
            if (response != null && response.getScrollId() != null) {
                this.client.prepareClearScroll().addScrollId(response.getScrollId()).execute(ActionListener.wrap(r -> this.listener.onFailure(ex), e -> {
                    ex.addSuppressed((Throwable)e);
                    this.listener.onFailure(ex);
                }));
            } else {
                this.listener.onFailure(ex);
            }
        }

        protected final void clear(String scrollId, ActionListener<Boolean> listener) {
            if (scrollId != null) {
                this.client.prepareClearScroll().addScrollId(scrollId).execute(ActionListener.wrap(clearScrollResponse -> listener.onResponse((Object)clearScrollResponse.isSucceeded()), arg_0 -> listener.onFailure(arg_0)));
            } else {
                listener.onResponse((Object)false);
            }
        }

        public final void onFailure(Exception ex) {
            this.listener.onFailure(ex);
        }
    }

    static class ScrollActionListener
    extends BaseActionListener {
        private final QueryContainer query;
        private final BitSet mask;
        private final boolean multiValueFieldLeniency;

        ScrollActionListener(ActionListener<Cursor.Page> listener, Client client, SqlConfiguration cfg, List<Attribute> output, QueryContainer query) {
            super(listener, client, cfg, output);
            this.query = query;
            this.mask = query.columnMask(output);
            this.multiValueFieldLeniency = cfg.multiValueFieldLeniency();
        }

        @Override
        protected void handleResponse(SearchResponse response, ActionListener<Cursor.Page> listener) {
            List<Tuple<FieldExtraction, String>> refs = this.query.fields();
            ArrayList<HitExtractor> exts = new ArrayList<HitExtractor>(refs.size());
            for (Tuple<FieldExtraction, String> ref : refs) {
                exts.add(this.createExtractor((FieldExtraction)ref.v1()));
            }
            ScrollCursor.handle(response, () -> new SchemaSearchHitRowSet(this.schema, exts, this.mask, this.query.limit(), response), p -> listener.onResponse(p), p -> this.clear(response.getScrollId(), (ActionListener<Boolean>)ActionListener.wrap(success -> listener.onResponse(p), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), this.schema);
        }

        private HitExtractor createExtractor(FieldExtraction ref) {
            if (ref instanceof SearchHitFieldRef) {
                SearchHitFieldRef f = (SearchHitFieldRef)ref;
                return new FieldHitExtractor(f.name(), f.fullFieldName(), f.getDataType(), this.cfg.zoneId(), f.useDocValue(), f.hitName(), this.multiValueFieldLeniency);
            }
            if (ref instanceof ScriptFieldRef) {
                ScriptFieldRef f = (ScriptFieldRef)ref;
                return new FieldHitExtractor(f.name(), null, this.cfg.zoneId(), true, this.multiValueFieldLeniency);
            }
            if (ref instanceof ComputedRef) {
                Pipe proc = ((ComputedRef)ref).processor();
                LinkedHashSet hitNames = new LinkedHashSet();
                proc = (Pipe)proc.transformDown(l -> {
                    HitExtractor he = this.createExtractor((FieldExtraction)l.context());
                    hitNames.add(he.hitName());
                    if (hitNames.size() > 1) {
                        throw new SqlIllegalArgumentException("Multi-level nested fields [{}] not supported yet", hitNames);
                    }
                    return new HitExtractorInput(l.source(), l.expression(), he);
                }, ReferenceInput.class);
                String hitName = null;
                if (hitNames.size() == 1) {
                    hitName = (String)hitNames.iterator().next();
                }
                return new ComputingExtractor(proc.asProcessor(), hitName);
            }
            throw new SqlIllegalArgumentException("Unexpected value reference {}", ref.getClass());
        }
    }

    static abstract class BaseAggActionListener
    extends BaseActionListener {
        final QueryContainer query;
        final SearchRequest request;
        final BitSet mask;

        BaseAggActionListener(ActionListener<Cursor.Page> listener, Client client, SqlConfiguration cfg, List<Attribute> output, QueryContainer query, SearchRequest request) {
            super(listener, client, cfg, output);
            this.query = query;
            this.request = request;
            this.mask = query.columnMask(output);
        }

        protected List<BucketExtractor> initBucketExtractors(SearchResponse response) {
            List<Tuple<FieldExtraction, String>> refs = this.query.fields();
            ArrayList<BucketExtractor> exts = new ArrayList<BucketExtractor>(refs.size());
            ConstantExtractor totalCount = new ConstantExtractor((Object)response.getHits().getTotalHits().value);
            for (Tuple<FieldExtraction, String> ref : refs) {
                exts.add(this.createExtractor((FieldExtraction)ref.v1(), (BucketExtractor)totalCount));
            }
            return exts;
        }

        private BucketExtractor createExtractor(FieldExtraction ref, BucketExtractor totalCount) {
            if (ref instanceof GroupByRef) {
                GroupByRef r = (GroupByRef)ref;
                return new CompositeKeyExtractor(r.key(), r.property(), this.cfg.zoneId(), r.isDateTimeBased());
            }
            if (ref instanceof MetricAggRef) {
                MetricAggRef r = (MetricAggRef)ref;
                return new MetricAggExtractor(r.name(), r.property(), r.innerKey(), this.cfg.zoneId(), r.isDateTimeBased());
            }
            if (ref instanceof TopHitsAggRef) {
                TopHitsAggRef r = (TopHitsAggRef)ref;
                return new TopHitsAggExtractor(r.name(), r.fieldDataType(), this.cfg.zoneId());
            }
            if (ref instanceof PivotColumnRef) {
                PivotColumnRef r = (PivotColumnRef)ref;
                return new PivotExtractor(this.createExtractor(r.pivot(), totalCount), this.createExtractor(r.agg(), totalCount), r.value());
            }
            if (ref == GlobalCountRef.INSTANCE) {
                return totalCount;
            }
            if (ref instanceof ComputedRef) {
                Pipe proc = ((ComputedRef)ref).processor();
                proc = (Pipe)proc.transformDown(l -> {
                    BucketExtractor be = this.createExtractor((FieldExtraction)l.context(), totalCount);
                    return new AggExtractorInput(l.source(), l.expression(), l.action(), be);
                }, AggPathInput.class);
                return new ComputingExtractor(proc.asProcessor());
            }
            throw new SqlIllegalArgumentException("Unexpected value reference {}", ref.getClass());
        }
    }

    static class CompositeActionListener
    extends BaseAggActionListener {
        private final boolean isPivot;

        CompositeActionListener(ActionListener<Cursor.Page> listener, Client client, SqlConfiguration cfg, List<Attribute> output, QueryContainer query, SearchRequest request) {
            super(listener, client, cfg, output, query, request);
            this.isPivot = query.fields().stream().anyMatch(t -> t.v1() instanceof PivotColumnRef);
        }

        @Override
        protected void handleResponse(SearchResponse response, ActionListener<Cursor.Page> listener) {
            Supplier<CompositeAggRowSet> makeRowSet = this.isPivot ? () -> new PivotRowSet(this.schema, this.initBucketExtractors(response), this.mask, response, this.query.sortingColumns().isEmpty() ? this.query.limit() : -1, null) : () -> new SchemaCompositeAggRowSet(this.schema, this.initBucketExtractors(response), this.mask, response, this.query.sortingColumns().isEmpty() ? this.query.limit() : -1);
            BiFunction<byte[], CompositeAggRowSet, CompositeAggCursor> makeCursor = this.isPivot ? (q, r) -> {
                Map<String, Object> lastAfterKey = r instanceof PivotRowSet ? ((PivotRowSet)r).lastAfterKey() : null;
                return new PivotCursor(lastAfterKey, (byte[])q, r.extractors(), r.mask(), r.remainingData(), this.query.shouldIncludeFrozen(), this.request.indices());
            } : (q, r) -> new CompositeAggCursor((byte[])q, r.extractors(), r.mask(), r.remainingData, this.query.shouldIncludeFrozen(), this.request.indices());
            CompositeAggCursor.handle(response, this.request.source(), makeRowSet, makeCursor, () -> this.client.search(this.request, (ActionListener)this), listener, this.schema);
        }
    }

    static class ImplicitGroupActionListener
    extends BaseAggActionListener {
        private static List<? extends MultiBucketsAggregation.Bucket> EMPTY_BUCKET = Collections.singletonList(new MultiBucketsAggregation.Bucket(){

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                throw new SqlIllegalArgumentException("No group-by/aggs defined");
            }

            public Object getKey() {
                throw new SqlIllegalArgumentException("No group-by/aggs defined");
            }

            public String getKeyAsString() {
                throw new SqlIllegalArgumentException("No group-by/aggs defined");
            }

            public long getDocCount() {
                throw new SqlIllegalArgumentException("No group-by/aggs defined");
            }

            public Aggregations getAggregations() {
                throw new SqlIllegalArgumentException("No group-by/aggs defined");
            }
        });

        ImplicitGroupActionListener(ActionListener<Cursor.Page> listener, Client client, SqlConfiguration cfg, List<Attribute> output, QueryContainer query, SearchRequest request) {
            super(listener, client, cfg, output, query, request);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void handleResponse(SearchResponse response, ActionListener<Cursor.Page> listener) {
            Aggregations aggs;
            if (log.isTraceEnabled()) {
                Querier.logSearchResponse(response, log);
            }
            if ((aggs = response.getAggregations()) != null) {
                Aggregation agg = aggs.get("groupby");
                if (!(agg instanceof Filters)) throw new SqlIllegalArgumentException("Unrecognized root group found; {}", agg.getClass());
                this.handleBuckets(((Filters)agg).getBuckets(), response);
                return;
            } else {
                this.handleBuckets(EMPTY_BUCKET, response);
            }
        }

        private void handleBuckets(List<? extends MultiBucketsAggregation.Bucket> buckets, SearchResponse response) {
            if (buckets.size() == 1) {
                MultiBucketsAggregation.Bucket implicitGroup = buckets.get(0);
                List<BucketExtractor> extractors = this.initBucketExtractors(response);
                Object[] values = new Object[this.mask.cardinality()];
                int index = 0;
                int i = this.mask.nextSetBit(0);
                while (i >= 0) {
                    values[index++] = extractors.get(i).extract(implicitGroup);
                    i = this.mask.nextSetBit(i + 1);
                }
                this.listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.schema, values)));
            } else if (buckets.isEmpty()) {
                this.listener.onResponse((Object)Cursor.Page.last(Rows.empty(this.schema)));
            } else {
                throw new SqlIllegalArgumentException("Too many groups returned by the implicit group; expected 1, received {}", buckets.size());
            }
        }
    }

    class LocalAggregationSorterListener
    implements ActionListener<Cursor.Page> {
        private final ActionListener<Cursor.Page> listener;
        private final AggSortingQueue data;
        private final AtomicInteger counter = new AtomicInteger();
        private volatile Schema schema;
        private static final int MAXIMUM_SIZE = 65535;
        private final boolean noLimit;

        LocalAggregationSorterListener(ActionListener<Cursor.Page> listener, List<Tuple<Integer, Comparator>> sortingColumns, int limit) {
            this.listener = listener;
            int size = 65535;
            if (limit < 0) {
                this.noLimit = true;
            } else {
                this.noLimit = false;
                if (limit > 65535) {
                    throw new PlanningException("The maximum LIMIT for aggregate sorting is [{}], received [{}]", 65535, limit);
                }
                size = limit;
            }
            this.data = new AggSortingQueue(size, sortingColumns);
        }

        public void onResponse(Cursor.Page page) {
            if (this.schema == null) {
                RowSet rowSet = page.rowSet();
                if (rowSet instanceof SchemaRowSet) {
                    this.schema = ((SchemaRowSet)rowSet).schema();
                } else {
                    this.onFailure((Exception)((Object)new SqlIllegalArgumentException("No schema found inside {}", rowSet.getClass())));
                    return;
                }
            }
            if (!this.consumeRowSet(page.rowSet())) {
                return;
            }
            Cursor cursor = page.next();
            if (cursor != Cursor.EMPTY) {
                Querier.this.planExecutor.nextPage(Querier.this.cfg, cursor, this);
                return;
            }
            this.sendResponse();
        }

        private boolean consumeRowSet(RowSet rowSet) {
            ResultRowSet rrs = (ResultRowSet)rowSet;
            boolean hasRows = rrs.hasCurrentRow();
            while (hasRows) {
                ArrayList row = new ArrayList(rrs.columnCount());
                rrs.forEachResultColumn(row::add);
                if (this.data.insertWithOverflow(new Tuple(row, (Object)this.counter.getAndIncrement())) != null && this.noLimit) {
                    this.onFailure((Exception)((Object)new SqlIllegalArgumentException("The default limit [{}] for aggregate sorting has been reached; please specify a LIMIT", 65535)));
                    return false;
                }
                hasRows = rrs.advanceRow();
            }
            return true;
        }

        private void sendResponse() {
            this.listener.onResponse((Object)ListCursor.of(this.schema, this.data.asList(), Querier.this.cfg.pageSize()));
        }

        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }
}

