/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.LocateFunctionPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.LocateFunctionProcessor;

public class Locate
extends ScalarFunction
implements OptionalArgument {
    private final Expression pattern;
    private final Expression input;
    private final Expression start;

    public Locate(Source source, Expression pattern, Expression input, Expression start) {
        super(source, start != null ? Arrays.asList(pattern, input, start) : Arrays.asList(pattern, input));
        this.pattern = pattern;
        this.input = input;
        this.start = start;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution patternResolution = TypeResolutions.isStringAndExact((Expression)this.pattern, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.FIRST);
        if (patternResolution.unresolved()) {
            return patternResolution;
        }
        Expression.TypeResolution sourceResolution = TypeResolutions.isStringAndExact((Expression)this.input, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.SECOND);
        if (sourceResolution.unresolved()) {
            return sourceResolution;
        }
        return this.start == null ? Expression.TypeResolution.TYPE_RESOLVED : TypeResolutions.isNumeric((Expression)this.start, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.THIRD);
    }

    protected Pipe makePipe() {
        return new LocateFunctionPipe(this.source(), (Expression)this, Expressions.pipe((Expression)this.pattern), Expressions.pipe((Expression)this.input), this.start == null ? null : Expressions.pipe((Expression)this.start));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Locate::new, (Object)this.pattern, (Object)this.input, (Object)this.start);
    }

    public boolean foldable() {
        return this.pattern.foldable() && this.input.foldable() && (this.start == null || this.start.foldable());
    }

    public Object fold() {
        return LocateFunctionProcessor.doProcess(this.pattern.fold(), this.input.fold(), this.start == null ? null : this.start.fold());
    }

    public ScriptTemplate asScript() {
        ScriptTemplate patternScript = this.asScript(this.pattern);
        ScriptTemplate inputScript = this.asScript(this.input);
        ScriptTemplate startScript = this.start == null ? null : this.asScript(this.start);
        return this.asScriptFrom(patternScript, inputScript, startScript);
    }

    private ScriptTemplate asScriptFrom(ScriptTemplate patternScript, ScriptTemplate inputScript, ScriptTemplate startScript) {
        if (this.start == null) {
            return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{sql}.%s(%s,%s)"), "locate", patternScript.template(), inputScript.template()), ParamsBuilder.paramsBuilder().script(patternScript.params()).script(inputScript.params()).build(), this.dataType());
        }
        return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{sql}.%s(%s,%s,%s)"), "locate", patternScript.template(), inputScript.template(), startScript.template()), ParamsBuilder.paramsBuilder().script(patternScript.params()).script(inputScript.params()).script(startScript.params()).build(), this.dataType());
    }

    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable((Object)field.exactAttribute().name()).build(), this.dataType());
    }

    public DataType dataType() {
        return DataTypes.INTEGER;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        if (this.start != null && newChildren.size() != 3) {
            throw new IllegalArgumentException("expected [3] children but received [" + newChildren.size() + "]");
        }
        if (this.start == null && newChildren.size() != 2) {
            throw new IllegalArgumentException("expected [2] children but received [" + newChildren.size() + "]");
        }
        return new Locate(this.source(), newChildren.get(0), newChildren.get(1), this.start == null ? null : newChildren.get(2));
    }
}

