/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.ReplaceFunctionPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.ReplaceFunctionProcessor;

public class Replace
extends ScalarFunction {
    private final Expression input;
    private final Expression pattern;
    private final Expression replacement;

    public Replace(Source source, Expression input, Expression pattern, Expression replacement) {
        super(source, Arrays.asList(input, pattern, replacement));
        this.input = input;
        this.pattern = pattern;
        this.replacement = replacement;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution sourceResolution = TypeResolutions.isStringAndExact((Expression)this.input, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.FIRST);
        if (sourceResolution.unresolved()) {
            return sourceResolution;
        }
        Expression.TypeResolution patternResolution = TypeResolutions.isStringAndExact((Expression)this.pattern, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.SECOND);
        if (patternResolution.unresolved()) {
            return patternResolution;
        }
        return TypeResolutions.isStringAndExact((Expression)this.replacement, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.THIRD);
    }

    protected Pipe makePipe() {
        return new ReplaceFunctionPipe(this.source(), (Expression)this, Expressions.pipe((Expression)this.input), Expressions.pipe((Expression)this.pattern), Expressions.pipe((Expression)this.replacement));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Replace::new, (Object)this.input, (Object)this.pattern, (Object)this.replacement);
    }

    public boolean foldable() {
        return this.input.foldable() && this.pattern.foldable() && this.replacement.foldable();
    }

    public Object fold() {
        return ReplaceFunctionProcessor.doProcess(this.input.fold(), this.pattern.fold(), this.replacement.fold());
    }

    public ScriptTemplate asScript() {
        ScriptTemplate inputScript = this.asScript(this.input);
        ScriptTemplate patternScript = this.asScript(this.pattern);
        ScriptTemplate replacementScript = this.asScript(this.replacement);
        return this.asScriptFrom(inputScript, patternScript, replacementScript);
    }

    private ScriptTemplate asScriptFrom(ScriptTemplate inputScript, ScriptTemplate patternScript, ScriptTemplate replacementScript) {
        return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{sql}.%s(%s,%s,%s)"), "replace", inputScript.template(), patternScript.template(), replacementScript.template()), ParamsBuilder.paramsBuilder().script(inputScript.params()).script(patternScript.params()).script(replacementScript.params()).build(), this.dataType());
    }

    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable((Object)field.exactAttribute().name()).build(), this.dataType());
    }

    public DataType dataType() {
        return DataTypes.KEYWORD;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 3) {
            throw new IllegalArgumentException("expected [3] children but received [" + newChildren.size() + "]");
        }
        return new Replace(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }
}

